// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.BotService.Models
{
    /// <summary> Facebook channel definition. </summary>
    public partial class FacebookChannel : BotChannelProperties
    {
        /// <summary> Initializes a new instance of <see cref="FacebookChannel"/>. </summary>
        public FacebookChannel()
        {
            ChannelName = "FacebookChannel";
        }

        /// <summary> Initializes a new instance of <see cref="FacebookChannel"/>. </summary>
        /// <param name="channelName"> The channel name. </param>
        /// <param name="etag"> Entity Tag of the resource. </param>
        /// <param name="provisioningState"> Provisioning state of the resource. </param>
        /// <param name="location"> Specifies the location of the resource. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="properties"> The set of properties specific to bot facebook channel. </param>
        internal FacebookChannel(string channelName, ETag? etag, string provisioningState, AzureLocation? location, IDictionary<string, BinaryData> serializedAdditionalRawData, FacebookChannelProperties properties) : base(channelName, etag, provisioningState, location, serializedAdditionalRawData)
        {
            Properties = properties;
            ChannelName = channelName ?? "FacebookChannel";
        }

        /// <summary> The set of properties specific to bot facebook channel. </summary>
        public FacebookChannelProperties Properties { get; set; }
    }
}
