// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.BotService.Models
{
    public partial class DirectLineSpeechChannelProperties : IUtf8JsonSerializable, IJsonModel<DirectLineSpeechChannelProperties>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<DirectLineSpeechChannelProperties>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<DirectLineSpeechChannelProperties>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DirectLineSpeechChannelProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(DirectLineSpeechChannelProperties)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(CognitiveServiceResourceId))
            {
                writer.WritePropertyName("cognitiveServiceResourceId"u8);
                writer.WriteStringValue(CognitiveServiceResourceId);
            }
            if (Optional.IsDefined(CognitiveServiceRegion))
            {
                if (CognitiveServiceRegion != null)
                {
                    writer.WritePropertyName("cognitiveServiceRegion"u8);
                    writer.WriteStringValue(CognitiveServiceRegion);
                }
                else
                {
                    writer.WriteNull("cognitiveServiceRegion");
                }
            }
            if (Optional.IsDefined(CognitiveServiceSubscriptionKey))
            {
                if (CognitiveServiceSubscriptionKey != null)
                {
                    writer.WritePropertyName("cognitiveServiceSubscriptionKey"u8);
                    writer.WriteStringValue(CognitiveServiceSubscriptionKey);
                }
                else
                {
                    writer.WriteNull("cognitiveServiceSubscriptionKey");
                }
            }
            if (Optional.IsDefined(IsEnabled))
            {
                writer.WritePropertyName("isEnabled"u8);
                writer.WriteBooleanValue(IsEnabled.Value);
            }
            if (Optional.IsDefined(CustomVoiceDeploymentId))
            {
                writer.WritePropertyName("customVoiceDeploymentId"u8);
                writer.WriteStringValue(CustomVoiceDeploymentId);
            }
            if (Optional.IsDefined(CustomSpeechModelId))
            {
                writer.WritePropertyName("customSpeechModelId"u8);
                writer.WriteStringValue(CustomSpeechModelId);
            }
            if (Optional.IsDefined(IsDefaultBotForCogSvcAccount))
            {
                writer.WritePropertyName("isDefaultBotForCogSvcAccount"u8);
                writer.WriteBooleanValue(IsDefaultBotForCogSvcAccount.Value);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        DirectLineSpeechChannelProperties IJsonModel<DirectLineSpeechChannelProperties>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DirectLineSpeechChannelProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(DirectLineSpeechChannelProperties)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeDirectLineSpeechChannelProperties(document.RootElement, options);
        }

        internal static DirectLineSpeechChannelProperties DeserializeDirectLineSpeechChannelProperties(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ResourceIdentifier cognitiveServiceResourceId = default;
            string cognitiveServiceRegion = default;
            string cognitiveServiceSubscriptionKey = default;
            bool? isEnabled = default;
            string customVoiceDeploymentId = default;
            string customSpeechModelId = default;
            bool? isDefaultBotForCogSvcAccount = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("cognitiveServiceResourceId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    cognitiveServiceResourceId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("cognitiveServiceRegion"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        cognitiveServiceRegion = null;
                        continue;
                    }
                    cognitiveServiceRegion = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("cognitiveServiceSubscriptionKey"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        cognitiveServiceSubscriptionKey = null;
                        continue;
                    }
                    cognitiveServiceSubscriptionKey = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("isEnabled"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    isEnabled = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("customVoiceDeploymentId"u8))
                {
                    customVoiceDeploymentId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("customSpeechModelId"u8))
                {
                    customSpeechModelId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("isDefaultBotForCogSvcAccount"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    isDefaultBotForCogSvcAccount = property.Value.GetBoolean();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new DirectLineSpeechChannelProperties(
                cognitiveServiceResourceId,
                cognitiveServiceRegion,
                cognitiveServiceSubscriptionKey,
                isEnabled,
                customVoiceDeploymentId,
                customSpeechModelId,
                isDefaultBotForCogSvcAccount,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<DirectLineSpeechChannelProperties>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DirectLineSpeechChannelProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(DirectLineSpeechChannelProperties)} does not support writing '{options.Format}' format.");
            }
        }

        DirectLineSpeechChannelProperties IPersistableModel<DirectLineSpeechChannelProperties>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DirectLineSpeechChannelProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeDirectLineSpeechChannelProperties(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(DirectLineSpeechChannelProperties)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<DirectLineSpeechChannelProperties>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
