// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.BotService.Models
{
    /// <summary> The parameters to provide for the Direct Line channel. </summary>
    public partial class DirectLineChannelProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DirectLineChannelProperties"/>. </summary>
        public DirectLineChannelProperties()
        {
            Sites = new ChangeTrackingList<DirectLineSite>();
        }

        /// <summary> Initializes a new instance of <see cref="DirectLineChannelProperties"/>. </summary>
        /// <param name="sites"> The list of Direct Line sites. </param>
        /// <param name="extensionKey1"> The extensionKey1. </param>
        /// <param name="extensionKey2"> The extensionKey2. </param>
        /// <param name="directLineEmbedCode"> Direct Line embed code of the resource. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DirectLineChannelProperties(IList<DirectLineSite> sites, string extensionKey1, string extensionKey2, string directLineEmbedCode, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Sites = sites;
            ExtensionKey1 = extensionKey1;
            ExtensionKey2 = extensionKey2;
            DirectLineEmbedCode = directLineEmbedCode;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The list of Direct Line sites. </summary>
        public IList<DirectLineSite> Sites { get; }
        /// <summary> The extensionKey1. </summary>
        public string ExtensionKey1 { get; set; }
        /// <summary> The extensionKey2. </summary>
        public string ExtensionKey2 { get; set; }
        /// <summary> Direct Line embed code of the resource. </summary>
        public string DirectLineEmbedCode { get; set; }
    }
}
