// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.BotService.Models
{
    /// <summary> The name of SKU. </summary>
    public readonly partial struct BotServiceSkuName : IEquatable<BotServiceSkuName>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BotServiceSkuName"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BotServiceSkuName(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string F0Value = "F0";
        private const string S1Value = "S1";

        /// <summary> F0. </summary>
        public static BotServiceSkuName F0 { get; } = new BotServiceSkuName(F0Value);
        /// <summary> S1. </summary>
        public static BotServiceSkuName S1 { get; } = new BotServiceSkuName(S1Value);
        /// <summary> Determines if two <see cref="BotServiceSkuName"/> values are the same. </summary>
        public static bool operator ==(BotServiceSkuName left, BotServiceSkuName right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BotServiceSkuName"/> values are not the same. </summary>
        public static bool operator !=(BotServiceSkuName left, BotServiceSkuName right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BotServiceSkuName"/>. </summary>
        public static implicit operator BotServiceSkuName(string value) => new BotServiceSkuName(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BotServiceSkuName other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BotServiceSkuName other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
