// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.BotService.Models
{
    /// <summary> Whether the bot is in an isolated network. </summary>
    public readonly partial struct BotServicePublicNetworkAccess : IEquatable<BotServicePublicNetworkAccess>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BotServicePublicNetworkAccess"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BotServicePublicNetworkAccess(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";

        /// <summary> Enabled. </summary>
        public static BotServicePublicNetworkAccess Enabled { get; } = new BotServicePublicNetworkAccess(EnabledValue);
        /// <summary> Disabled. </summary>
        public static BotServicePublicNetworkAccess Disabled { get; } = new BotServicePublicNetworkAccess(DisabledValue);
        /// <summary> Determines if two <see cref="BotServicePublicNetworkAccess"/> values are the same. </summary>
        public static bool operator ==(BotServicePublicNetworkAccess left, BotServicePublicNetworkAccess right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BotServicePublicNetworkAccess"/> values are not the same. </summary>
        public static bool operator !=(BotServicePublicNetworkAccess left, BotServicePublicNetworkAccess right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BotServicePublicNetworkAccess"/>. </summary>
        public static implicit operator BotServicePublicNetworkAccess(string value) => new BotServicePublicNetworkAccess(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BotServicePublicNetworkAccess other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BotServicePublicNetworkAccess other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
