// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.BotService.Models
{
    internal static partial class BotServiceKeyExtensions
    {
        public static string ToSerialString(this BotServiceKey value) => value switch
        {
            BotServiceKey.Key1 => "key1",
            BotServiceKey.Key2 => "key2",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown BotServiceKey value.")
        };

        public static BotServiceKey ToBotServiceKey(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "key1")) return BotServiceKey.Key1;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "key2")) return BotServiceKey.Key2;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown BotServiceKey value.");
        }
    }
}
