// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.BotService.Models
{
    /// <summary> The response body returned for a request to Bot Service Management to check per subscription hostSettings. </summary>
    public partial class BotServiceHostSettingsResult
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BotServiceHostSettingsResult"/>. </summary>
        internal BotServiceHostSettingsResult()
        {
        }

        /// <summary> Initializes a new instance of <see cref="BotServiceHostSettingsResult"/>. </summary>
        /// <param name="oAuthUri"> For in-conversation bot user authentication. </param>
        /// <param name="toBotFromChannelOpenIdMetadataUri"> For verifying incoming tokens from the channels. </param>
        /// <param name="toBotFromChannelTokenIssuer"> For verifying incoming tokens from the channels. </param>
        /// <param name="toBotFromEmulatorOpenIdMetadataUri"> For verifying incoming tokens from bot emulator. </param>
        /// <param name="toChannelFromBotLoginUri"> For getting access token to channels from bot host. </param>
        /// <param name="toChannelFromBotOAuthScope"> For getting access token to channels from bot host. </param>
        /// <param name="validateAuthority"> Per cloud OAuth setting on whether authority is validated. </param>
        /// <param name="botOpenIdMetadata"> Same as toBotFromChannelOpenIdMetadataUrl, used by SDK &lt; v4.12. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BotServiceHostSettingsResult(Uri oAuthUri, Uri toBotFromChannelOpenIdMetadataUri, string toBotFromChannelTokenIssuer, Uri toBotFromEmulatorOpenIdMetadataUri, Uri toChannelFromBotLoginUri, string toChannelFromBotOAuthScope, bool? validateAuthority, string botOpenIdMetadata, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            OAuthUri = oAuthUri;
            ToBotFromChannelOpenIdMetadataUri = toBotFromChannelOpenIdMetadataUri;
            ToBotFromChannelTokenIssuer = toBotFromChannelTokenIssuer;
            ToBotFromEmulatorOpenIdMetadataUri = toBotFromEmulatorOpenIdMetadataUri;
            ToChannelFromBotLoginUri = toChannelFromBotLoginUri;
            ToChannelFromBotOAuthScope = toChannelFromBotOAuthScope;
            ValidateAuthority = validateAuthority;
            BotOpenIdMetadata = botOpenIdMetadata;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> For in-conversation bot user authentication. </summary>
        public Uri OAuthUri { get; }
        /// <summary> For verifying incoming tokens from the channels. </summary>
        public Uri ToBotFromChannelOpenIdMetadataUri { get; }
        /// <summary> For verifying incoming tokens from the channels. </summary>
        public string ToBotFromChannelTokenIssuer { get; }
        /// <summary> For verifying incoming tokens from bot emulator. </summary>
        public Uri ToBotFromEmulatorOpenIdMetadataUri { get; }
        /// <summary> For getting access token to channels from bot host. </summary>
        public Uri ToChannelFromBotLoginUri { get; }
        /// <summary> For getting access token to channels from bot host. </summary>
        public string ToChannelFromBotOAuthScope { get; }
        /// <summary> Per cloud OAuth setting on whether authority is validated. </summary>
        public bool? ValidateAuthority { get; }
        /// <summary> Same as toBotFromChannelOpenIdMetadataUrl, used by SDK &lt; v4.12. </summary>
        public string BotOpenIdMetadata { get; }
    }
}
