// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.BotService.Models
{
    /// <summary> Microsoft App Type for the bot. </summary>
    public readonly partial struct BotMsaAppType : IEquatable<BotMsaAppType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BotMsaAppType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BotMsaAppType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UserAssignedMSIValue = "UserAssignedMSI";
        private const string SingleTenantValue = "SingleTenant";
        private const string MultiTenantValue = "MultiTenant";

        /// <summary> UserAssignedMSI. </summary>
        public static BotMsaAppType UserAssignedMSI { get; } = new BotMsaAppType(UserAssignedMSIValue);
        /// <summary> SingleTenant. </summary>
        public static BotMsaAppType SingleTenant { get; } = new BotMsaAppType(SingleTenantValue);
        /// <summary> MultiTenant. </summary>
        public static BotMsaAppType MultiTenant { get; } = new BotMsaAppType(MultiTenantValue);
        /// <summary> Determines if two <see cref="BotMsaAppType"/> values are the same. </summary>
        public static bool operator ==(BotMsaAppType left, BotMsaAppType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BotMsaAppType"/> values are not the same. </summary>
        public static bool operator !=(BotMsaAppType left, BotMsaAppType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BotMsaAppType"/>. </summary>
        public static implicit operator BotMsaAppType(string value) => new BotMsaAppType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BotMsaAppType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BotMsaAppType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
