// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.BotService.Models
{
    /// <summary> Channel settings definition. </summary>
    public partial class BotChannelSettings
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BotChannelSettings"/>. </summary>
        public BotChannelSettings()
        {
            Sites = new ChangeTrackingList<BotChannelSite>();
        }

        /// <summary> Initializes a new instance of <see cref="BotChannelSettings"/>. </summary>
        /// <param name="extensionKey1"> The extensionKey1. </param>
        /// <param name="extensionKey2"> The extensionKey2. </param>
        /// <param name="sites"> The list of sites. </param>
        /// <param name="channelId"> The channel id. </param>
        /// <param name="channelDisplayName"> The channel display name. </param>
        /// <param name="botId"> The bot id. </param>
        /// <param name="botIconUri"> The bot icon url. </param>
        /// <param name="isEnabled"> Whether this channel is enabled for the bot. </param>
        /// <param name="disableLocalAuth"> Opt-out of local authentication and ensure only MSI and AAD can be used exclusively for authentication. </param>
        /// <param name="requireTermsAgreement"> Whether customer needs to agree to new terms. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BotChannelSettings(string extensionKey1, string extensionKey2, IList<BotChannelSite> sites, string channelId, string channelDisplayName, string botId, Uri botIconUri, bool? isEnabled, bool? disableLocalAuth, bool? requireTermsAgreement, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ExtensionKey1 = extensionKey1;
            ExtensionKey2 = extensionKey2;
            Sites = sites;
            ChannelId = channelId;
            ChannelDisplayName = channelDisplayName;
            BotId = botId;
            BotIconUri = botIconUri;
            IsEnabled = isEnabled;
            DisableLocalAuth = disableLocalAuth;
            RequireTermsAgreement = requireTermsAgreement;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The extensionKey1. </summary>
        public string ExtensionKey1 { get; set; }
        /// <summary> The extensionKey2. </summary>
        public string ExtensionKey2 { get; set; }
        /// <summary> The list of sites. </summary>
        public IList<BotChannelSite> Sites { get; }
        /// <summary> The channel id. </summary>
        public string ChannelId { get; set; }
        /// <summary> The channel display name. </summary>
        public string ChannelDisplayName { get; set; }
        /// <summary> The bot id. </summary>
        public string BotId { get; set; }
        /// <summary> The bot icon url. </summary>
        public Uri BotIconUri { get; set; }
        /// <summary> Whether this channel is enabled for the bot. </summary>
        public bool? IsEnabled { get; set; }
        /// <summary> Opt-out of local authentication and ensure only MSI and AAD can be used exclusively for authentication. </summary>
        public bool? DisableLocalAuth { get; set; }
        /// <summary> Whether customer needs to agree to new terms. </summary>
        public bool? RequireTermsAgreement { get; set; }
    }
}
