// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using Azure.Core;

namespace Azure.ResourceManager.BotService.Mocking
{
    /// <summary> A class to add extension methods to ArmClient. </summary>
    public partial class MockableBotServiceArmClient : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableBotServiceArmClient"/> class for mocking. </summary>
        protected MockableBotServiceArmClient()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableBotServiceArmClient"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableBotServiceArmClient(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        internal MockableBotServiceArmClient(ArmClient client) : this(client, ResourceIdentifier.Root)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary>
        /// Gets an object representing a <see cref="BotResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="BotResource.CreateResourceIdentifier" /> to create a <see cref="BotResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="BotResource"/> object. </returns>
        public virtual BotResource GetBotResource(ResourceIdentifier id)
        {
            BotResource.ValidateResourceId(id);
            return new BotResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="BotChannelResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="BotChannelResource.CreateResourceIdentifier" /> to create a <see cref="BotChannelResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="BotChannelResource"/> object. </returns>
        public virtual BotChannelResource GetBotChannelResource(ResourceIdentifier id)
        {
            BotChannelResource.ValidateResourceId(id);
            return new BotChannelResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="BotConnectionSettingResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="BotConnectionSettingResource.CreateResourceIdentifier" /> to create a <see cref="BotConnectionSettingResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="BotConnectionSettingResource"/> object. </returns>
        public virtual BotConnectionSettingResource GetBotConnectionSettingResource(ResourceIdentifier id)
        {
            BotConnectionSettingResource.ValidateResourceId(id);
            return new BotConnectionSettingResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="BotServicePrivateEndpointConnectionResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="BotServicePrivateEndpointConnectionResource.CreateResourceIdentifier" /> to create a <see cref="BotServicePrivateEndpointConnectionResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="BotServicePrivateEndpointConnectionResource"/> object. </returns>
        public virtual BotServicePrivateEndpointConnectionResource GetBotServicePrivateEndpointConnectionResource(ResourceIdentifier id)
        {
            BotServicePrivateEndpointConnectionResource.ValidateResourceId(id);
            return new BotServicePrivateEndpointConnectionResource(Client, id);
        }
    }
}
