// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.BotService.Models;

namespace Azure.ResourceManager.BotService.Samples
{
    public partial class Sample_BotConnectionSettingCollection
    {
        // Create Connection Setting
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateConnectionSetting()
        {
            // Generated from example definition: specification/botservice/resource-manager/Microsoft.BotService/stable/2022-09-15/examples/PutConnection.json
            // this example is just showing the usage of "BotConnection_Create" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BotResource created on azure
            // for more information of creating BotResource, please refer to the document of BotResource
            string subscriptionId = "subscription-id";
            string resourceGroupName = "OneResourceGroupName";
            string resourceName = "samplebotname";
            ResourceIdentifier botResourceId = BotResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName);
            BotResource bot = client.GetBotResource(botResourceId);

            // get the collection of this BotConnectionSettingResource
            BotConnectionSettingCollection collection = bot.GetBotConnectionSettings();

            // invoke the operation
            string connectionName = "sampleConnection";
            BotConnectionSettingData data = new BotConnectionSettingData(new AzureLocation("West US"))
            {
                Properties = new BotConnectionSettingProperties()
                {
                    ClientId = "sampleclientid",
                    ClientSecret = "samplesecret",
                    Scopes = "samplescope",
                    ServiceProviderId = "serviceproviderid",
                    Parameters =
{
new BotConnectionSettingParameter()
{
Key = "key1",
Value = "value1",
},new BotConnectionSettingParameter()
{
Key = "key2",
Value = "value2",
}
},
                },
                ETag = new ETag("etag1"),
            };
            ArmOperation<BotConnectionSettingResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, connectionName, data);
            BotConnectionSettingResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            BotConnectionSettingData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get Connection Setting
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetConnectionSetting()
        {
            // Generated from example definition: specification/botservice/resource-manager/Microsoft.BotService/stable/2022-09-15/examples/GetConnection.json
            // this example is just showing the usage of "BotConnection_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BotResource created on azure
            // for more information of creating BotResource, please refer to the document of BotResource
            string subscriptionId = "subscription-id";
            string resourceGroupName = "OneResourceGroupName";
            string resourceName = "samplebotname";
            ResourceIdentifier botResourceId = BotResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName);
            BotResource bot = client.GetBotResource(botResourceId);

            // get the collection of this BotConnectionSettingResource
            BotConnectionSettingCollection collection = bot.GetBotConnectionSettings();

            // invoke the operation
            string connectionName = "sampleConnection";
            BotConnectionSettingResource result = await collection.GetAsync(connectionName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            BotConnectionSettingData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get Connection Setting
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetConnectionSetting()
        {
            // Generated from example definition: specification/botservice/resource-manager/Microsoft.BotService/stable/2022-09-15/examples/GetConnection.json
            // this example is just showing the usage of "BotConnection_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BotResource created on azure
            // for more information of creating BotResource, please refer to the document of BotResource
            string subscriptionId = "subscription-id";
            string resourceGroupName = "OneResourceGroupName";
            string resourceName = "samplebotname";
            ResourceIdentifier botResourceId = BotResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName);
            BotResource bot = client.GetBotResource(botResourceId);

            // get the collection of this BotConnectionSettingResource
            BotConnectionSettingCollection collection = bot.GetBotConnectionSettings();

            // invoke the operation
            string connectionName = "sampleConnection";
            bool result = await collection.ExistsAsync(connectionName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get Connection Setting
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetConnectionSetting()
        {
            // Generated from example definition: specification/botservice/resource-manager/Microsoft.BotService/stable/2022-09-15/examples/GetConnection.json
            // this example is just showing the usage of "BotConnection_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BotResource created on azure
            // for more information of creating BotResource, please refer to the document of BotResource
            string subscriptionId = "subscription-id";
            string resourceGroupName = "OneResourceGroupName";
            string resourceName = "samplebotname";
            ResourceIdentifier botResourceId = BotResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName);
            BotResource bot = client.GetBotResource(botResourceId);

            // get the collection of this BotConnectionSettingResource
            BotConnectionSettingCollection collection = bot.GetBotConnectionSettings();

            // invoke the operation
            string connectionName = "sampleConnection";
            NullableResponse<BotConnectionSettingResource> response = await collection.GetIfExistsAsync(connectionName);
            BotConnectionSettingResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                BotConnectionSettingData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // List Connection Settings
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_ListConnectionSettings()
        {
            // Generated from example definition: specification/botservice/resource-manager/Microsoft.BotService/stable/2022-09-15/examples/ListConnectionsByBotService.json
            // this example is just showing the usage of "BotConnection_ListByBotService" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BotResource created on azure
            // for more information of creating BotResource, please refer to the document of BotResource
            string subscriptionId = "subscription-id";
            string resourceGroupName = "OneResourceGroupName";
            string resourceName = "samplebotname";
            ResourceIdentifier botResourceId = BotResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName);
            BotResource bot = client.GetBotResource(botResourceId);

            // get the collection of this BotConnectionSettingResource
            BotConnectionSettingCollection collection = bot.GetBotConnectionSettings();

            // invoke the operation and iterate over the result
            await foreach (BotConnectionSettingResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                BotConnectionSettingData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }
    }
}
