// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.BotService.Models;

namespace Azure.ResourceManager.BotService.Samples
{
    public partial class Sample_BotChannelResource
    {
        // Update Alexa Channel
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdateAlexaChannel()
        {
            // Generated from example definition: specification/botservice/resource-manager/Microsoft.BotService/stable/2022-09-15/examples/UpdateAlexaChannel.json
            // this example is just showing the usage of "Channels_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BotChannelResource created on azure
            // for more information of creating BotChannelResource, please refer to the document of BotChannelResource
            string subscriptionId = "subscription-id";
            string resourceGroupName = "OneResourceGroupName";
            string resourceName = "samplebotname";
            BotChannelName channelName = BotChannelName.AlexaChannel;
            ResourceIdentifier botChannelResourceId = BotChannelResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, channelName);
            BotChannelResource botChannel = client.GetBotChannelResource(botChannelResourceId);

            // invoke the operation
            BotChannelData data = new BotChannelData(new AzureLocation("global"))
            {
                Properties = new AlexaChannel()
                {
                    Properties = new AlexaChannelProperties("XAlexaSkillIdX", true),
                },
            };
            BotChannelResource result = await botChannel.UpdateAsync(data);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            BotChannelData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Update Channel
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdateChannel()
        {
            // Generated from example definition: specification/botservice/resource-manager/Microsoft.BotService/stable/2022-09-15/examples/UpdateChannel.json
            // this example is just showing the usage of "Channels_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BotChannelResource created on azure
            // for more information of creating BotChannelResource, please refer to the document of BotChannelResource
            string subscriptionId = "subscription-id";
            string resourceGroupName = "OneResourceGroupName";
            string resourceName = "samplebotname";
            BotChannelName channelName = BotChannelName.EmailChannel;
            ResourceIdentifier botChannelResourceId = BotChannelResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, channelName);
            BotChannelResource botChannel = client.GetBotChannelResource(botChannelResourceId);

            // invoke the operation
            BotChannelData data = new BotChannelData(new AzureLocation("global"))
            {
                Properties = new EmailChannel()
                {
                    Properties = new EmailChannelProperties("a@b.com", true)
                    {
                        Password = "pwd",
                    },
                },
            };
            BotChannelResource result = await botChannel.UpdateAsync(data);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            BotChannelData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Update DirectLine Speech Channel
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdateDirectLineSpeechChannel()
        {
            // Generated from example definition: specification/botservice/resource-manager/Microsoft.BotService/stable/2022-09-15/examples/UpdateDirectLineSpeechChannel.json
            // this example is just showing the usage of "Channels_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BotChannelResource created on azure
            // for more information of creating BotChannelResource, please refer to the document of BotChannelResource
            string subscriptionId = "subscription-id";
            string resourceGroupName = "OneResourceGroupName";
            string resourceName = "samplebotname";
            BotChannelName channelName = BotChannelName.DirectLineSpeechChannel;
            ResourceIdentifier botChannelResourceId = BotChannelResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, channelName);
            BotChannelResource botChannel = client.GetBotChannelResource(botChannelResourceId);

            // invoke the operation
            BotChannelData data = new BotChannelData(new AzureLocation("global"))
            {
                Properties = new DirectLineSpeechChannel()
                {
                    Properties = new DirectLineSpeechChannelProperties()
                    {
                        CognitiveServiceRegion = "XcognitiveServiceRegionX",
                        CognitiveServiceSubscriptionKey = "XcognitiveServiceSubscriptionKeyX",
                        IsEnabled = true,
                    },
                },
            };
            BotChannelResource result = await botChannel.UpdateAsync(data);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            BotChannelData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Update Line Channel
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdateLineChannel()
        {
            // Generated from example definition: specification/botservice/resource-manager/Microsoft.BotService/stable/2022-09-15/examples/UpdateLineChannel.json
            // this example is just showing the usage of "Channels_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BotChannelResource created on azure
            // for more information of creating BotChannelResource, please refer to the document of BotChannelResource
            string subscriptionId = "subscription-id";
            string resourceGroupName = "OneResourceGroupName";
            string resourceName = "samplebotname";
            BotChannelName channelName = BotChannelName.LineChannel;
            ResourceIdentifier botChannelResourceId = BotChannelResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, channelName);
            BotChannelResource botChannel = client.GetBotChannelResource(botChannelResourceId);

            // invoke the operation
            BotChannelData data = new BotChannelData(new AzureLocation("global"))
            {
                Properties = new LineChannel()
                {
                    Properties = new LineChannelProperties(new LineRegistration[]
            {
new LineRegistration()
{
ChannelSecret = "channelSecret",
ChannelAccessToken = "channelAccessToken",
}
            }),
                },
            };
            BotChannelResource result = await botChannel.UpdateAsync(data);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            BotChannelData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Delete Channel
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeleteChannel()
        {
            // Generated from example definition: specification/botservice/resource-manager/Microsoft.BotService/stable/2022-09-15/examples/DeleteChannel.json
            // this example is just showing the usage of "Channels_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BotChannelResource created on azure
            // for more information of creating BotChannelResource, please refer to the document of BotChannelResource
            string subscriptionId = "subscription-id";
            string resourceGroupName = "OneResourceGroupName";
            string resourceName = "samplebotname";
            BotChannelName channelName = BotChannelName.EmailChannel;
            ResourceIdentifier botChannelResourceId = BotChannelResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, channelName);
            BotChannelResource botChannel = client.GetBotChannelResource(botChannelResourceId);

            // invoke the operation
            await botChannel.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // Delete DirectLine Speech Channel
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeleteDirectLineSpeechChannel()
        {
            // Generated from example definition: specification/botservice/resource-manager/Microsoft.BotService/stable/2022-09-15/examples/DeleteDirectLineSpeechChannel.json
            // this example is just showing the usage of "Channels_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BotChannelResource created on azure
            // for more information of creating BotChannelResource, please refer to the document of BotChannelResource
            string subscriptionId = "subscription-id";
            string resourceGroupName = "OneResourceGroupName";
            string resourceName = "samplebotname";
            BotChannelName channelName = BotChannelName.DirectLineSpeechChannel;
            ResourceIdentifier botChannelResourceId = BotChannelResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, channelName);
            BotChannelResource botChannel = client.GetBotChannelResource(botChannelResourceId);

            // invoke the operation
            await botChannel.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // Get Alexa Channel
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetAlexaChannel()
        {
            // Generated from example definition: specification/botservice/resource-manager/Microsoft.BotService/stable/2022-09-15/examples/GetAlexaChannel.json
            // this example is just showing the usage of "Channels_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BotChannelResource created on azure
            // for more information of creating BotChannelResource, please refer to the document of BotChannelResource
            string subscriptionId = "subscription-id";
            string resourceGroupName = "OneResourceGroupName";
            string resourceName = "samplebotname";
            BotChannelName channelName = BotChannelName.AlexaChannel;
            ResourceIdentifier botChannelResourceId = BotChannelResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, channelName);
            BotChannelResource botChannel = client.GetBotChannelResource(botChannelResourceId);

            // invoke the operation
            BotChannelResource result = await botChannel.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            BotChannelData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get Channel
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetChannel()
        {
            // Generated from example definition: specification/botservice/resource-manager/Microsoft.BotService/stable/2022-09-15/examples/GetChannel.json
            // this example is just showing the usage of "Channels_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BotChannelResource created on azure
            // for more information of creating BotChannelResource, please refer to the document of BotChannelResource
            string subscriptionId = "subscription-id";
            string resourceGroupName = "OneResourceGroupName";
            string resourceName = "samplebotname";
            BotChannelName channelName = BotChannelName.EmailChannel;
            ResourceIdentifier botChannelResourceId = BotChannelResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, channelName);
            BotChannelResource botChannel = client.GetBotChannelResource(botChannelResourceId);

            // invoke the operation
            BotChannelResource result = await botChannel.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            BotChannelData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get DirectLine Speech Channel
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetDirectLineSpeechChannel()
        {
            // Generated from example definition: specification/botservice/resource-manager/Microsoft.BotService/stable/2022-09-15/examples/GetDirectLineSpeechChannel.json
            // this example is just showing the usage of "Channels_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BotChannelResource created on azure
            // for more information of creating BotChannelResource, please refer to the document of BotChannelResource
            string subscriptionId = "subscription-id";
            string resourceGroupName = "OneResourceGroupName";
            string resourceName = "samplebotname";
            BotChannelName channelName = BotChannelName.DirectLineSpeechChannel;
            ResourceIdentifier botChannelResourceId = BotChannelResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, channelName);
            BotChannelResource botChannel = client.GetBotChannelResource(botChannelResourceId);

            // invoke the operation
            BotChannelResource result = await botChannel.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            BotChannelData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get Line Channel
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetLineChannel()
        {
            // Generated from example definition: specification/botservice/resource-manager/Microsoft.BotService/stable/2022-09-15/examples/GetLineChannel.json
            // this example is just showing the usage of "Channels_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BotChannelResource created on azure
            // for more information of creating BotChannelResource, please refer to the document of BotChannelResource
            string subscriptionId = "subscription-id";
            string resourceGroupName = "OneResourceGroupName";
            string resourceName = "samplebotname";
            BotChannelName channelName = BotChannelName.LineChannel;
            ResourceIdentifier botChannelResourceId = BotChannelResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, channelName);
            BotChannelResource botChannel = client.GetBotChannelResource(botChannelResourceId);

            // invoke the operation
            BotChannelResource result = await botChannel.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            BotChannelData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // List Channel
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetChannelWithKeys_ListChannel()
        {
            // Generated from example definition: specification/botservice/resource-manager/Microsoft.BotService/stable/2022-09-15/examples/ListChannel.json
            // this example is just showing the usage of "Channels_ListWithKeys" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BotChannelResource created on azure
            // for more information of creating BotChannelResource, please refer to the document of BotChannelResource
            string subscriptionId = "subscription-id";
            string resourceGroupName = "OneResourceGroupName";
            string resourceName = "samplebotname";
            BotChannelName channelName = BotChannelName.EmailChannel;
            ResourceIdentifier botChannelResourceId = BotChannelResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName, channelName);
            BotChannelResource botChannel = client.GetBotChannelResource(botChannelResourceId);

            // invoke the operation
            BotChannelGetWithKeysResult result = await botChannel.GetChannelWithKeysAsync();

            Console.WriteLine($"Succeeded: {result}");
        }
    }
}
