// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.BotService.Models;

namespace Azure.ResourceManager.BotService.Samples
{
    public partial class Sample_BotChannelCollection
    {
        // Create Alexa Channel
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateAlexaChannel()
        {
            // Generated from example definition: specification/botservice/resource-manager/Microsoft.BotService/stable/2022-09-15/examples/PutAlexaChannel.json
            // this example is just showing the usage of "Channels_Create" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BotResource created on azure
            // for more information of creating BotResource, please refer to the document of BotResource
            string subscriptionId = "subscription-id";
            string resourceGroupName = "OneResourceGroupName";
            string resourceName = "samplebotname";
            ResourceIdentifier botResourceId = BotResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName);
            BotResource bot = client.GetBotResource(botResourceId);

            // get the collection of this BotChannelResource
            BotChannelCollection collection = bot.GetBotChannels();

            // invoke the operation
            BotChannelName channelName = BotChannelName.AlexaChannel;
            BotChannelData data = new BotChannelData(new AzureLocation("global"))
            {
                Properties = new AlexaChannel()
                {
                    Properties = new AlexaChannelProperties("XAlexaSkillIdX", true),
                },
            };
            ArmOperation<BotChannelResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, channelName, data);
            BotChannelResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            BotChannelData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create Channel
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateChannel()
        {
            // Generated from example definition: specification/botservice/resource-manager/Microsoft.BotService/stable/2022-09-15/examples/PutChannel.json
            // this example is just showing the usage of "Channels_Create" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BotResource created on azure
            // for more information of creating BotResource, please refer to the document of BotResource
            string subscriptionId = "subscription-id";
            string resourceGroupName = "OneResourceGroupName";
            string resourceName = "samplebotname";
            ResourceIdentifier botResourceId = BotResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName);
            BotResource bot = client.GetBotResource(botResourceId);

            // get the collection of this BotChannelResource
            BotChannelCollection collection = bot.GetBotChannels();

            // invoke the operation
            BotChannelName channelName = BotChannelName.EmailChannel;
            BotChannelData data = new BotChannelData(new AzureLocation("global"))
            {
                Properties = new EmailChannel()
                {
                    Properties = new EmailChannelProperties("a@b.com", true)
                    {
                        Password = "pwd",
                    },
                },
            };
            ArmOperation<BotChannelResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, channelName, data);
            BotChannelResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            BotChannelData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create DirectLine Speech Channel
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateDirectLineSpeechChannel()
        {
            // Generated from example definition: specification/botservice/resource-manager/Microsoft.BotService/stable/2022-09-15/examples/PutDirectLineSpeechChannel.json
            // this example is just showing the usage of "Channels_Create" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BotResource created on azure
            // for more information of creating BotResource, please refer to the document of BotResource
            string subscriptionId = "subscription-id";
            string resourceGroupName = "OneResourceGroupName";
            string resourceName = "samplebotname";
            ResourceIdentifier botResourceId = BotResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName);
            BotResource bot = client.GetBotResource(botResourceId);

            // get the collection of this BotChannelResource
            BotChannelCollection collection = bot.GetBotChannels();

            // invoke the operation
            BotChannelName channelName = BotChannelName.DirectLineSpeechChannel;
            BotChannelData data = new BotChannelData(new AzureLocation("global"))
            {
                Properties = new DirectLineSpeechChannel()
                {
                    Properties = new DirectLineSpeechChannelProperties()
                    {
                        CognitiveServiceRegion = "XcognitiveServiceRegionX",
                        CognitiveServiceSubscriptionKey = "XcognitiveServiceSubscriptionKeyX",
                        IsEnabled = true,
                    },
                },
            };
            ArmOperation<BotChannelResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, channelName, data);
            BotChannelResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            BotChannelData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create Email Channel
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateEmailChannel()
        {
            // Generated from example definition: specification/botservice/resource-manager/Microsoft.BotService/stable/2022-09-15/examples/PutEmailChannel.json
            // this example is just showing the usage of "Channels_Create" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BotResource created on azure
            // for more information of creating BotResource, please refer to the document of BotResource
            string subscriptionId = "subscription-id";
            string resourceGroupName = "OneResourceGroupName";
            string resourceName = "samplebotname";
            ResourceIdentifier botResourceId = BotResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName);
            BotResource bot = client.GetBotResource(botResourceId);

            // get the collection of this BotChannelResource
            BotChannelCollection collection = bot.GetBotChannels();

            // invoke the operation
            BotChannelName channelName = BotChannelName.EmailChannel;
            BotChannelData data = new BotChannelData(new AzureLocation("global"))
            {
                Properties = new EmailChannel()
                {
                    Properties = new EmailChannelProperties("a@b.com", true)
                    {
                        AuthMethod = EmailChannelAuthMethod.Graph,
                        MagicCode = "000000",
                    },
                },
            };
            ArmOperation<BotChannelResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, channelName, data);
            BotChannelResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            BotChannelData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create Line Channel
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateLineChannel()
        {
            // Generated from example definition: specification/botservice/resource-manager/Microsoft.BotService/stable/2022-09-15/examples/PutLineChannel.json
            // this example is just showing the usage of "Channels_Create" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BotResource created on azure
            // for more information of creating BotResource, please refer to the document of BotResource
            string subscriptionId = "subscription-id";
            string resourceGroupName = "OneResourceGroupName";
            string resourceName = "samplebotname";
            ResourceIdentifier botResourceId = BotResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName);
            BotResource bot = client.GetBotResource(botResourceId);

            // get the collection of this BotChannelResource
            BotChannelCollection collection = bot.GetBotChannels();

            // invoke the operation
            BotChannelName channelName = BotChannelName.LineChannel;
            BotChannelData data = new BotChannelData(new AzureLocation("global"))
            {
                Properties = new LineChannel()
                {
                    Properties = new LineChannelProperties(new LineRegistration[]
            {
new LineRegistration()
{
ChannelSecret = "channelSecret",
ChannelAccessToken = "channelAccessToken",
}
            }),
                },
            };
            ArmOperation<BotChannelResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, channelName, data);
            BotChannelResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            BotChannelData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get Alexa Channel
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetAlexaChannel()
        {
            // Generated from example definition: specification/botservice/resource-manager/Microsoft.BotService/stable/2022-09-15/examples/GetAlexaChannel.json
            // this example is just showing the usage of "Channels_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BotResource created on azure
            // for more information of creating BotResource, please refer to the document of BotResource
            string subscriptionId = "subscription-id";
            string resourceGroupName = "OneResourceGroupName";
            string resourceName = "samplebotname";
            ResourceIdentifier botResourceId = BotResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName);
            BotResource bot = client.GetBotResource(botResourceId);

            // get the collection of this BotChannelResource
            BotChannelCollection collection = bot.GetBotChannels();

            // invoke the operation
            BotChannelName channelName = BotChannelName.AlexaChannel;
            BotChannelResource result = await collection.GetAsync(channelName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            BotChannelData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get Alexa Channel
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetAlexaChannel()
        {
            // Generated from example definition: specification/botservice/resource-manager/Microsoft.BotService/stable/2022-09-15/examples/GetAlexaChannel.json
            // this example is just showing the usage of "Channels_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BotResource created on azure
            // for more information of creating BotResource, please refer to the document of BotResource
            string subscriptionId = "subscription-id";
            string resourceGroupName = "OneResourceGroupName";
            string resourceName = "samplebotname";
            ResourceIdentifier botResourceId = BotResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName);
            BotResource bot = client.GetBotResource(botResourceId);

            // get the collection of this BotChannelResource
            BotChannelCollection collection = bot.GetBotChannels();

            // invoke the operation
            BotChannelName channelName = BotChannelName.AlexaChannel;
            bool result = await collection.ExistsAsync(channelName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get Alexa Channel
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetAlexaChannel()
        {
            // Generated from example definition: specification/botservice/resource-manager/Microsoft.BotService/stable/2022-09-15/examples/GetAlexaChannel.json
            // this example is just showing the usage of "Channels_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BotResource created on azure
            // for more information of creating BotResource, please refer to the document of BotResource
            string subscriptionId = "subscription-id";
            string resourceGroupName = "OneResourceGroupName";
            string resourceName = "samplebotname";
            ResourceIdentifier botResourceId = BotResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName);
            BotResource bot = client.GetBotResource(botResourceId);

            // get the collection of this BotChannelResource
            BotChannelCollection collection = bot.GetBotChannels();

            // invoke the operation
            BotChannelName channelName = BotChannelName.AlexaChannel;
            NullableResponse<BotChannelResource> response = await collection.GetIfExistsAsync(channelName);
            BotChannelResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                BotChannelData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // Get Channel
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetChannel()
        {
            // Generated from example definition: specification/botservice/resource-manager/Microsoft.BotService/stable/2022-09-15/examples/GetChannel.json
            // this example is just showing the usage of "Channels_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BotResource created on azure
            // for more information of creating BotResource, please refer to the document of BotResource
            string subscriptionId = "subscription-id";
            string resourceGroupName = "OneResourceGroupName";
            string resourceName = "samplebotname";
            ResourceIdentifier botResourceId = BotResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName);
            BotResource bot = client.GetBotResource(botResourceId);

            // get the collection of this BotChannelResource
            BotChannelCollection collection = bot.GetBotChannels();

            // invoke the operation
            BotChannelName channelName = BotChannelName.EmailChannel;
            BotChannelResource result = await collection.GetAsync(channelName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            BotChannelData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get Channel
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetChannel()
        {
            // Generated from example definition: specification/botservice/resource-manager/Microsoft.BotService/stable/2022-09-15/examples/GetChannel.json
            // this example is just showing the usage of "Channels_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BotResource created on azure
            // for more information of creating BotResource, please refer to the document of BotResource
            string subscriptionId = "subscription-id";
            string resourceGroupName = "OneResourceGroupName";
            string resourceName = "samplebotname";
            ResourceIdentifier botResourceId = BotResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName);
            BotResource bot = client.GetBotResource(botResourceId);

            // get the collection of this BotChannelResource
            BotChannelCollection collection = bot.GetBotChannels();

            // invoke the operation
            BotChannelName channelName = BotChannelName.EmailChannel;
            bool result = await collection.ExistsAsync(channelName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get Channel
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetChannel()
        {
            // Generated from example definition: specification/botservice/resource-manager/Microsoft.BotService/stable/2022-09-15/examples/GetChannel.json
            // this example is just showing the usage of "Channels_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BotResource created on azure
            // for more information of creating BotResource, please refer to the document of BotResource
            string subscriptionId = "subscription-id";
            string resourceGroupName = "OneResourceGroupName";
            string resourceName = "samplebotname";
            ResourceIdentifier botResourceId = BotResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName);
            BotResource bot = client.GetBotResource(botResourceId);

            // get the collection of this BotChannelResource
            BotChannelCollection collection = bot.GetBotChannels();

            // invoke the operation
            BotChannelName channelName = BotChannelName.EmailChannel;
            NullableResponse<BotChannelResource> response = await collection.GetIfExistsAsync(channelName);
            BotChannelResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                BotChannelData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // Get DirectLine Speech Channel
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetDirectLineSpeechChannel()
        {
            // Generated from example definition: specification/botservice/resource-manager/Microsoft.BotService/stable/2022-09-15/examples/GetDirectLineSpeechChannel.json
            // this example is just showing the usage of "Channels_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BotResource created on azure
            // for more information of creating BotResource, please refer to the document of BotResource
            string subscriptionId = "subscription-id";
            string resourceGroupName = "OneResourceGroupName";
            string resourceName = "samplebotname";
            ResourceIdentifier botResourceId = BotResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName);
            BotResource bot = client.GetBotResource(botResourceId);

            // get the collection of this BotChannelResource
            BotChannelCollection collection = bot.GetBotChannels();

            // invoke the operation
            BotChannelName channelName = BotChannelName.DirectLineSpeechChannel;
            BotChannelResource result = await collection.GetAsync(channelName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            BotChannelData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get DirectLine Speech Channel
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetDirectLineSpeechChannel()
        {
            // Generated from example definition: specification/botservice/resource-manager/Microsoft.BotService/stable/2022-09-15/examples/GetDirectLineSpeechChannel.json
            // this example is just showing the usage of "Channels_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BotResource created on azure
            // for more information of creating BotResource, please refer to the document of BotResource
            string subscriptionId = "subscription-id";
            string resourceGroupName = "OneResourceGroupName";
            string resourceName = "samplebotname";
            ResourceIdentifier botResourceId = BotResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName);
            BotResource bot = client.GetBotResource(botResourceId);

            // get the collection of this BotChannelResource
            BotChannelCollection collection = bot.GetBotChannels();

            // invoke the operation
            BotChannelName channelName = BotChannelName.DirectLineSpeechChannel;
            bool result = await collection.ExistsAsync(channelName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get DirectLine Speech Channel
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetDirectLineSpeechChannel()
        {
            // Generated from example definition: specification/botservice/resource-manager/Microsoft.BotService/stable/2022-09-15/examples/GetDirectLineSpeechChannel.json
            // this example is just showing the usage of "Channels_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BotResource created on azure
            // for more information of creating BotResource, please refer to the document of BotResource
            string subscriptionId = "subscription-id";
            string resourceGroupName = "OneResourceGroupName";
            string resourceName = "samplebotname";
            ResourceIdentifier botResourceId = BotResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName);
            BotResource bot = client.GetBotResource(botResourceId);

            // get the collection of this BotChannelResource
            BotChannelCollection collection = bot.GetBotChannels();

            // invoke the operation
            BotChannelName channelName = BotChannelName.DirectLineSpeechChannel;
            NullableResponse<BotChannelResource> response = await collection.GetIfExistsAsync(channelName);
            BotChannelResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                BotChannelData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // Get Line Channel
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetLineChannel()
        {
            // Generated from example definition: specification/botservice/resource-manager/Microsoft.BotService/stable/2022-09-15/examples/GetLineChannel.json
            // this example is just showing the usage of "Channels_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BotResource created on azure
            // for more information of creating BotResource, please refer to the document of BotResource
            string subscriptionId = "subscription-id";
            string resourceGroupName = "OneResourceGroupName";
            string resourceName = "samplebotname";
            ResourceIdentifier botResourceId = BotResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName);
            BotResource bot = client.GetBotResource(botResourceId);

            // get the collection of this BotChannelResource
            BotChannelCollection collection = bot.GetBotChannels();

            // invoke the operation
            BotChannelName channelName = BotChannelName.LineChannel;
            BotChannelResource result = await collection.GetAsync(channelName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            BotChannelData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get Line Channel
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetLineChannel()
        {
            // Generated from example definition: specification/botservice/resource-manager/Microsoft.BotService/stable/2022-09-15/examples/GetLineChannel.json
            // this example is just showing the usage of "Channels_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BotResource created on azure
            // for more information of creating BotResource, please refer to the document of BotResource
            string subscriptionId = "subscription-id";
            string resourceGroupName = "OneResourceGroupName";
            string resourceName = "samplebotname";
            ResourceIdentifier botResourceId = BotResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName);
            BotResource bot = client.GetBotResource(botResourceId);

            // get the collection of this BotChannelResource
            BotChannelCollection collection = bot.GetBotChannels();

            // invoke the operation
            BotChannelName channelName = BotChannelName.LineChannel;
            bool result = await collection.ExistsAsync(channelName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get Line Channel
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetLineChannel()
        {
            // Generated from example definition: specification/botservice/resource-manager/Microsoft.BotService/stable/2022-09-15/examples/GetLineChannel.json
            // this example is just showing the usage of "Channels_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BotResource created on azure
            // for more information of creating BotResource, please refer to the document of BotResource
            string subscriptionId = "subscription-id";
            string resourceGroupName = "OneResourceGroupName";
            string resourceName = "samplebotname";
            ResourceIdentifier botResourceId = BotResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName);
            BotResource bot = client.GetBotResource(botResourceId);

            // get the collection of this BotChannelResource
            BotChannelCollection collection = bot.GetBotChannels();

            // invoke the operation
            BotChannelName channelName = BotChannelName.LineChannel;
            NullableResponse<BotChannelResource> response = await collection.GetIfExistsAsync(channelName);
            BotChannelResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                BotChannelData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // List Channels by Resource Group
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_ListChannelsByResourceGroup()
        {
            // Generated from example definition: specification/botservice/resource-manager/Microsoft.BotService/stable/2022-09-15/examples/ListChannelsByBotService.json
            // this example is just showing the usage of "Channels_ListByResourceGroup" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BotResource created on azure
            // for more information of creating BotResource, please refer to the document of BotResource
            string subscriptionId = "subscription-id";
            string resourceGroupName = "OneResourceGroupName";
            string resourceName = "samplebotname";
            ResourceIdentifier botResourceId = BotResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, resourceName);
            BotResource bot = client.GetBotResource(botResourceId);

            // get the collection of this BotChannelResource
            BotChannelCollection collection = bot.GetBotChannels();

            // invoke the operation and iterate over the result
            await foreach (BotChannelResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                BotChannelData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }
    }
}
