// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Blueprint.Models;

namespace Azure.ResourceManager.Blueprint
{
    internal partial class PublishedArtifactsRestOperations
    {
        private readonly TelemetryDetails _userAgent;
        private readonly HttpPipeline _pipeline;
        private readonly Uri _endpoint;
        private readonly string _apiVersion;

        /// <summary> Initializes a new instance of PublishedArtifactsRestOperations. </summary>
        /// <param name="pipeline"> The HTTP pipeline for sending and receiving REST requests and responses. </param>
        /// <param name="applicationId"> The application id to use for user agent. </param>
        /// <param name="endpoint"> server parameter. </param>
        /// <param name="apiVersion"> Api Version. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="pipeline"/> or <paramref name="apiVersion"/> is null. </exception>
        public PublishedArtifactsRestOperations(HttpPipeline pipeline, string applicationId, Uri endpoint = null, string apiVersion = default)
        {
            _pipeline = pipeline ?? throw new ArgumentNullException(nameof(pipeline));
            _endpoint = endpoint ?? new Uri("https://management.azure.com");
            _apiVersion = apiVersion ?? "2018-11-01-preview";
            _userAgent = new TelemetryDetails(GetType().Assembly, applicationId);
        }

        internal RequestUriBuilder CreateGetRequestUri(string resourceScope, string blueprintName, string versionId, string artifactName)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/", false);
            uri.AppendPath(resourceScope, false);
            uri.AppendPath("/providers/Microsoft.Blueprint/blueprints/", false);
            uri.AppendPath(blueprintName, true);
            uri.AppendPath("/versions/", false);
            uri.AppendPath(versionId, true);
            uri.AppendPath("/artifacts/", false);
            uri.AppendPath(artifactName, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateGetRequest(string resourceScope, string blueprintName, string versionId, string artifactName)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/", false);
            uri.AppendPath(resourceScope, false);
            uri.AppendPath("/providers/Microsoft.Blueprint/blueprints/", false);
            uri.AppendPath(blueprintName, true);
            uri.AppendPath("/versions/", false);
            uri.AppendPath(versionId, true);
            uri.AppendPath("/artifacts/", false);
            uri.AppendPath(artifactName, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Get an artifact for a published blueprint definition. </summary>
        /// <param name="resourceScope"> The scope of the resource. Valid scopes are: management group (format: '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format: '/subscriptions/{subscriptionId}'). </param>
        /// <param name="blueprintName"> Name of the blueprint definition. </param>
        /// <param name="versionId"> Version of the published blueprint definition. </param>
        /// <param name="artifactName"> Name of the blueprint artifact. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="resourceScope"/>, <paramref name="blueprintName"/>, <paramref name="versionId"/> or <paramref name="artifactName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="blueprintName"/>, <paramref name="versionId"/> or <paramref name="artifactName"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<ArtifactData>> GetAsync(string resourceScope, string blueprintName, string versionId, string artifactName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(resourceScope, nameof(resourceScope));
            Argument.AssertNotNullOrEmpty(blueprintName, nameof(blueprintName));
            Argument.AssertNotNullOrEmpty(versionId, nameof(versionId));
            Argument.AssertNotNullOrEmpty(artifactName, nameof(artifactName));

            using var message = CreateGetRequest(resourceScope, blueprintName, versionId, artifactName);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        ArtifactData value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = ArtifactData.DeserializeArtifactData(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                case 404:
                    return Response.FromValue((ArtifactData)null, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Get an artifact for a published blueprint definition. </summary>
        /// <param name="resourceScope"> The scope of the resource. Valid scopes are: management group (format: '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format: '/subscriptions/{subscriptionId}'). </param>
        /// <param name="blueprintName"> Name of the blueprint definition. </param>
        /// <param name="versionId"> Version of the published blueprint definition. </param>
        /// <param name="artifactName"> Name of the blueprint artifact. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="resourceScope"/>, <paramref name="blueprintName"/>, <paramref name="versionId"/> or <paramref name="artifactName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="blueprintName"/>, <paramref name="versionId"/> or <paramref name="artifactName"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<ArtifactData> Get(string resourceScope, string blueprintName, string versionId, string artifactName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(resourceScope, nameof(resourceScope));
            Argument.AssertNotNullOrEmpty(blueprintName, nameof(blueprintName));
            Argument.AssertNotNullOrEmpty(versionId, nameof(versionId));
            Argument.AssertNotNullOrEmpty(artifactName, nameof(artifactName));

            using var message = CreateGetRequest(resourceScope, blueprintName, versionId, artifactName);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        ArtifactData value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = ArtifactData.DeserializeArtifactData(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                case 404:
                    return Response.FromValue((ArtifactData)null, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateListRequestUri(string resourceScope, string blueprintName, string versionId)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/", false);
            uri.AppendPath(resourceScope, false);
            uri.AppendPath("/providers/Microsoft.Blueprint/blueprints/", false);
            uri.AppendPath(blueprintName, true);
            uri.AppendPath("/versions/", false);
            uri.AppendPath(versionId, true);
            uri.AppendPath("/artifacts", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateListRequest(string resourceScope, string blueprintName, string versionId)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/", false);
            uri.AppendPath(resourceScope, false);
            uri.AppendPath("/providers/Microsoft.Blueprint/blueprints/", false);
            uri.AppendPath(blueprintName, true);
            uri.AppendPath("/versions/", false);
            uri.AppendPath(versionId, true);
            uri.AppendPath("/artifacts", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> List artifacts for a version of a published blueprint definition. </summary>
        /// <param name="resourceScope"> The scope of the resource. Valid scopes are: management group (format: '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format: '/subscriptions/{subscriptionId}'). </param>
        /// <param name="blueprintName"> Name of the blueprint definition. </param>
        /// <param name="versionId"> Version of the published blueprint definition. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="resourceScope"/>, <paramref name="blueprintName"/> or <paramref name="versionId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="blueprintName"/> or <paramref name="versionId"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<ArtifactList>> ListAsync(string resourceScope, string blueprintName, string versionId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(resourceScope, nameof(resourceScope));
            Argument.AssertNotNullOrEmpty(blueprintName, nameof(blueprintName));
            Argument.AssertNotNullOrEmpty(versionId, nameof(versionId));

            using var message = CreateListRequest(resourceScope, blueprintName, versionId);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        ArtifactList value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = ArtifactList.DeserializeArtifactList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> List artifacts for a version of a published blueprint definition. </summary>
        /// <param name="resourceScope"> The scope of the resource. Valid scopes are: management group (format: '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format: '/subscriptions/{subscriptionId}'). </param>
        /// <param name="blueprintName"> Name of the blueprint definition. </param>
        /// <param name="versionId"> Version of the published blueprint definition. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="resourceScope"/>, <paramref name="blueprintName"/> or <paramref name="versionId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="blueprintName"/> or <paramref name="versionId"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<ArtifactList> List(string resourceScope, string blueprintName, string versionId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(resourceScope, nameof(resourceScope));
            Argument.AssertNotNullOrEmpty(blueprintName, nameof(blueprintName));
            Argument.AssertNotNullOrEmpty(versionId, nameof(versionId));

            using var message = CreateListRequest(resourceScope, blueprintName, versionId);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        ArtifactList value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = ArtifactList.DeserializeArtifactList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateListNextPageRequestUri(string nextLink, string resourceScope, string blueprintName, string versionId)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRawNextLink(nextLink, false);
            return uri;
        }

        internal HttpMessage CreateListNextPageRequest(string nextLink, string resourceScope, string blueprintName, string versionId)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRawNextLink(nextLink, false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> List artifacts for a version of a published blueprint definition. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="resourceScope"> The scope of the resource. Valid scopes are: management group (format: '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format: '/subscriptions/{subscriptionId}'). </param>
        /// <param name="blueprintName"> Name of the blueprint definition. </param>
        /// <param name="versionId"> Version of the published blueprint definition. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/>, <paramref name="resourceScope"/>, <paramref name="blueprintName"/> or <paramref name="versionId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="blueprintName"/> or <paramref name="versionId"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<ArtifactList>> ListNextPageAsync(string nextLink, string resourceScope, string blueprintName, string versionId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(nextLink, nameof(nextLink));
            Argument.AssertNotNull(resourceScope, nameof(resourceScope));
            Argument.AssertNotNullOrEmpty(blueprintName, nameof(blueprintName));
            Argument.AssertNotNullOrEmpty(versionId, nameof(versionId));

            using var message = CreateListNextPageRequest(nextLink, resourceScope, blueprintName, versionId);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        ArtifactList value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = ArtifactList.DeserializeArtifactList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> List artifacts for a version of a published blueprint definition. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="resourceScope"> The scope of the resource. Valid scopes are: management group (format: '/providers/Microsoft.Management/managementGroups/{managementGroup}'), subscription (format: '/subscriptions/{subscriptionId}'). </param>
        /// <param name="blueprintName"> Name of the blueprint definition. </param>
        /// <param name="versionId"> Version of the published blueprint definition. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/>, <paramref name="resourceScope"/>, <paramref name="blueprintName"/> or <paramref name="versionId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="blueprintName"/> or <paramref name="versionId"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<ArtifactList> ListNextPage(string nextLink, string resourceScope, string blueprintName, string versionId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(nextLink, nameof(nextLink));
            Argument.AssertNotNull(resourceScope, nameof(resourceScope));
            Argument.AssertNotNullOrEmpty(blueprintName, nameof(blueprintName));
            Argument.AssertNotNullOrEmpty(versionId, nameof(versionId));

            using var message = CreateListNextPageRequest(nextLink, resourceScope, blueprintName, versionId);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        ArtifactList value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = ArtifactList.DeserializeArtifactList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }
    }
}
