// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Blueprint.Models
{
    /// <summary> Response schema for querying the Azure Blueprints service principal in the tenant. </summary>
    public partial class WhoIsBlueprintContract
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="WhoIsBlueprintContract"/>. </summary>
        internal WhoIsBlueprintContract()
        {
        }

        /// <summary> Initializes a new instance of <see cref="WhoIsBlueprintContract"/>. </summary>
        /// <param name="objectId"> AAD object Id of the Azure Blueprints service principal in the tenant. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal WhoIsBlueprintContract(string objectId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ObjectId = objectId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> AAD object Id of the Azure Blueprints service principal in the tenant. </summary>
        public string ObjectId { get; }
    }
}
