// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Blueprint.Models
{
    /// <summary> Blueprint artifact that applies a Policy assignment. </summary>
    public partial class PolicyAssignmentArtifact : ArtifactData
    {
        /// <summary> Initializes a new instance of <see cref="PolicyAssignmentArtifact"/>. </summary>
        /// <param name="policyDefinitionId"> Azure resource ID of the policy definition. </param>
        /// <param name="parameters"> Parameter values for the policy definition. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="policyDefinitionId"/> or <paramref name="parameters"/> is null. </exception>
        public PolicyAssignmentArtifact(string policyDefinitionId, IDictionary<string, ParameterValue> parameters)
        {
            Argument.AssertNotNull(policyDefinitionId, nameof(policyDefinitionId));
            Argument.AssertNotNull(parameters, nameof(parameters));

            DependsOn = new ChangeTrackingList<string>();
            PolicyDefinitionId = policyDefinitionId;
            Parameters = parameters;
            Kind = ArtifactKind.PolicyAssignment;
        }

        /// <summary> Initializes a new instance of <see cref="PolicyAssignmentArtifact"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="kind"> Specifies the kind of blueprint artifact. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="displayName"> One-liner string explain this resource. </param>
        /// <param name="description"> Multi-line explain this resource. </param>
        /// <param name="dependsOn"> Artifacts which need to be deployed before the specified artifact. </param>
        /// <param name="policyDefinitionId"> Azure resource ID of the policy definition. </param>
        /// <param name="parameters"> Parameter values for the policy definition. </param>
        /// <param name="resourceGroup"> Name of the resource group placeholder to which the policy will be assigned. </param>
        internal PolicyAssignmentArtifact(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, ArtifactKind kind, IDictionary<string, BinaryData> serializedAdditionalRawData, string displayName, string description, IList<string> dependsOn, string policyDefinitionId, IDictionary<string, ParameterValue> parameters, string resourceGroup) : base(id, name, resourceType, systemData, kind, serializedAdditionalRawData)
        {
            DisplayName = displayName;
            Description = description;
            DependsOn = dependsOn;
            PolicyDefinitionId = policyDefinitionId;
            Parameters = parameters;
            ResourceGroup = resourceGroup;
            Kind = kind;
        }

        /// <summary> Initializes a new instance of <see cref="PolicyAssignmentArtifact"/> for deserialization. </summary>
        internal PolicyAssignmentArtifact()
        {
        }

        /// <summary> One-liner string explain this resource. </summary>
        public string DisplayName { get; set; }
        /// <summary> Multi-line explain this resource. </summary>
        public string Description { get; set; }
        /// <summary> Artifacts which need to be deployed before the specified artifact. </summary>
        public IList<string> DependsOn { get; }
        /// <summary> Azure resource ID of the policy definition. </summary>
        public string PolicyDefinitionId { get; set; }
        /// <summary> Parameter values for the policy definition. </summary>
        public IDictionary<string, ParameterValue> Parameters { get; }
        /// <summary> Name of the resource group placeholder to which the policy will be assigned. </summary>
        public string ResourceGroup { get; set; }
    }
}
