// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Blueprint.Models
{
    /// <summary> The scope where this blueprint definition can be assigned. </summary>
    public readonly partial struct BlueprintTargetScope : IEquatable<BlueprintTargetScope>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BlueprintTargetScope"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BlueprintTargetScope(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SubscriptionValue = "subscription";
        private const string ManagementGroupValue = "managementGroup";

        /// <summary> The blueprint targets a subscription during blueprint assignment. </summary>
        public static BlueprintTargetScope Subscription { get; } = new BlueprintTargetScope(SubscriptionValue);
        /// <summary> The blueprint targets a management group during blueprint assignment. This is reserved for future use. </summary>
        public static BlueprintTargetScope ManagementGroup { get; } = new BlueprintTargetScope(ManagementGroupValue);
        /// <summary> Determines if two <see cref="BlueprintTargetScope"/> values are the same. </summary>
        public static bool operator ==(BlueprintTargetScope left, BlueprintTargetScope right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BlueprintTargetScope"/> values are not the same. </summary>
        public static bool operator !=(BlueprintTargetScope left, BlueprintTargetScope right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BlueprintTargetScope"/>. </summary>
        public static implicit operator BlueprintTargetScope(string value) => new BlueprintTargetScope(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BlueprintTargetScope other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BlueprintTargetScope other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
