// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Blueprint.Models
{
    /// <summary> State of the blueprint assignment. </summary>
    public readonly partial struct AssignmentProvisioningState : IEquatable<AssignmentProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AssignmentProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AssignmentProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CreatingValue = "creating";
        private const string ValidatingValue = "validating";
        private const string WaitingValue = "waiting";
        private const string DeployingValue = "deploying";
        private const string CancellingValue = "cancelling";
        private const string LockingValue = "locking";
        private const string SucceededValue = "succeeded";
        private const string FailedValue = "failed";
        private const string CanceledValue = "canceled";
        private const string DeletingValue = "deleting";

        /// <summary> creating. </summary>
        public static AssignmentProvisioningState Creating { get; } = new AssignmentProvisioningState(CreatingValue);
        /// <summary> validating. </summary>
        public static AssignmentProvisioningState Validating { get; } = new AssignmentProvisioningState(ValidatingValue);
        /// <summary> waiting. </summary>
        public static AssignmentProvisioningState Waiting { get; } = new AssignmentProvisioningState(WaitingValue);
        /// <summary> deploying. </summary>
        public static AssignmentProvisioningState Deploying { get; } = new AssignmentProvisioningState(DeployingValue);
        /// <summary> cancelling. </summary>
        public static AssignmentProvisioningState Cancelling { get; } = new AssignmentProvisioningState(CancellingValue);
        /// <summary> locking. </summary>
        public static AssignmentProvisioningState Locking { get; } = new AssignmentProvisioningState(LockingValue);
        /// <summary> succeeded. </summary>
        public static AssignmentProvisioningState Succeeded { get; } = new AssignmentProvisioningState(SucceededValue);
        /// <summary> failed. </summary>
        public static AssignmentProvisioningState Failed { get; } = new AssignmentProvisioningState(FailedValue);
        /// <summary> canceled. </summary>
        public static AssignmentProvisioningState Canceled { get; } = new AssignmentProvisioningState(CanceledValue);
        /// <summary> deleting. </summary>
        public static AssignmentProvisioningState Deleting { get; } = new AssignmentProvisioningState(DeletingValue);
        /// <summary> Determines if two <see cref="AssignmentProvisioningState"/> values are the same. </summary>
        public static bool operator ==(AssignmentProvisioningState left, AssignmentProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AssignmentProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(AssignmentProvisioningState left, AssignmentProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AssignmentProvisioningState"/>. </summary>
        public static implicit operator AssignmentProvisioningState(string value) => new AssignmentProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AssignmentProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AssignmentProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
