// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Blueprint.Models
{
    /// <summary> Represents individual job in given blueprint assignment operation. </summary>
    public partial class AssignmentDeploymentJob
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AssignmentDeploymentJob"/>. </summary>
        public AssignmentDeploymentJob()
        {
            History = new ChangeTrackingList<AssignmentDeploymentJobResult>();
        }

        /// <summary> Initializes a new instance of <see cref="AssignmentDeploymentJob"/>. </summary>
        /// <param name="kind"> Kind of job. </param>
        /// <param name="action"> Name of the action performed in this job. </param>
        /// <param name="jobId"> Id of this job. </param>
        /// <param name="jobState"> State of this job. </param>
        /// <param name="result"> Deployment job result. </param>
        /// <param name="history"> Result of this deployment job for each retry. </param>
        /// <param name="requestUri"> Reference to deployment job resource id. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AssignmentDeploymentJob(string kind, string action, string jobId, string jobState, AssignmentDeploymentJobResult result, IList<AssignmentDeploymentJobResult> history, Uri requestUri, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Kind = kind;
            Action = action;
            JobId = jobId;
            JobState = jobState;
            Result = result;
            History = history;
            RequestUri = requestUri;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Kind of job. </summary>
        public string Kind { get; set; }
        /// <summary> Name of the action performed in this job. </summary>
        public string Action { get; set; }
        /// <summary> Id of this job. </summary>
        public string JobId { get; set; }
        /// <summary> State of this job. </summary>
        public string JobState { get; set; }
        /// <summary> Deployment job result. </summary>
        public AssignmentDeploymentJobResult Result { get; set; }
        /// <summary> Result of this deployment job for each retry. </summary>
        public IList<AssignmentDeploymentJobResult> History { get; }
        /// <summary> Reference to deployment job resource id. </summary>
        public Uri RequestUri { get; set; }
    }
}
