// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Blueprint.Mocking
{
    /// <summary> A class to add extension methods to ArmClient. </summary>
    public partial class MockableBlueprintArmClient : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableBlueprintArmClient"/> class for mocking. </summary>
        protected MockableBlueprintArmClient()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableBlueprintArmClient"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableBlueprintArmClient(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        internal MockableBlueprintArmClient(ArmClient client) : this(client, ResourceIdentifier.Root)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary> Gets a collection of BlueprintResources in the ArmClient. </summary>
        /// <param name="scope"> The scope that the resource will apply against. </param>
        /// <returns> An object representing collection of BlueprintResources and their operations over a BlueprintResource. </returns>
        public virtual BlueprintCollection GetBlueprints(ResourceIdentifier scope)
        {
            return new BlueprintCollection(Client, scope);
        }

        /// <summary>
        /// Get a blueprint definition.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceScope}/providers/Microsoft.Blueprint/blueprints/{blueprintName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Blueprints_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2018-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BlueprintResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="scope"> The scope that the resource will apply against. </param>
        /// <param name="blueprintName"> Name of the blueprint definition. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="blueprintName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="blueprintName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual async Task<Response<BlueprintResource>> GetBlueprintAsync(ResourceIdentifier scope, string blueprintName, CancellationToken cancellationToken = default)
        {
            return await GetBlueprints(scope).GetAsync(blueprintName, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Get a blueprint definition.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceScope}/providers/Microsoft.Blueprint/blueprints/{blueprintName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Blueprints_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2018-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BlueprintResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="scope"> The scope that the resource will apply against. </param>
        /// <param name="blueprintName"> Name of the blueprint definition. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="blueprintName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="blueprintName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual Response<BlueprintResource> GetBlueprint(ResourceIdentifier scope, string blueprintName, CancellationToken cancellationToken = default)
        {
            return GetBlueprints(scope).Get(blueprintName, cancellationToken);
        }

        /// <summary> Gets a collection of AssignmentResources in the ArmClient. </summary>
        /// <param name="scope"> The scope that the resource will apply against. </param>
        /// <returns> An object representing collection of AssignmentResources and their operations over a AssignmentResource. </returns>
        public virtual AssignmentCollection GetAssignments(ResourceIdentifier scope)
        {
            return new AssignmentCollection(Client, scope);
        }

        /// <summary>
        /// Get a blueprint assignment.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceScope}/providers/Microsoft.Blueprint/blueprintAssignments/{assignmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Assignments_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2018-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AssignmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="scope"> The scope that the resource will apply against. </param>
        /// <param name="assignmentName"> Name of the blueprint assignment. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="assignmentName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="assignmentName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual async Task<Response<AssignmentResource>> GetAssignmentAsync(ResourceIdentifier scope, string assignmentName, CancellationToken cancellationToken = default)
        {
            return await GetAssignments(scope).GetAsync(assignmentName, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Get a blueprint assignment.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceScope}/providers/Microsoft.Blueprint/blueprintAssignments/{assignmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Assignments_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2018-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AssignmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="scope"> The scope that the resource will apply against. </param>
        /// <param name="assignmentName"> Name of the blueprint assignment. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="assignmentName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="assignmentName"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual Response<AssignmentResource> GetAssignment(ResourceIdentifier scope, string assignmentName, CancellationToken cancellationToken = default)
        {
            return GetAssignments(scope).Get(assignmentName, cancellationToken);
        }

        /// <summary>
        /// Gets an object representing a <see cref="BlueprintResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="BlueprintResource.CreateResourceIdentifier" /> to create a <see cref="BlueprintResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="BlueprintResource"/> object. </returns>
        public virtual BlueprintResource GetBlueprintResource(ResourceIdentifier id)
        {
            BlueprintResource.ValidateResourceId(id);
            return new BlueprintResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="BlueprintArtifactResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="BlueprintArtifactResource.CreateResourceIdentifier" /> to create a <see cref="BlueprintArtifactResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="BlueprintArtifactResource"/> object. </returns>
        public virtual BlueprintArtifactResource GetBlueprintArtifactResource(ResourceIdentifier id)
        {
            BlueprintArtifactResource.ValidateResourceId(id);
            return new BlueprintArtifactResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="BlueprintVersionArtifactResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="BlueprintVersionArtifactResource.CreateResourceIdentifier" /> to create a <see cref="BlueprintVersionArtifactResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="BlueprintVersionArtifactResource"/> object. </returns>
        public virtual BlueprintVersionArtifactResource GetBlueprintVersionArtifactResource(ResourceIdentifier id)
        {
            BlueprintVersionArtifactResource.ValidateResourceId(id);
            return new BlueprintVersionArtifactResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="PublishedBlueprintResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="PublishedBlueprintResource.CreateResourceIdentifier" /> to create a <see cref="PublishedBlueprintResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="PublishedBlueprintResource"/> object. </returns>
        public virtual PublishedBlueprintResource GetPublishedBlueprintResource(ResourceIdentifier id)
        {
            PublishedBlueprintResource.ValidateResourceId(id);
            return new PublishedBlueprintResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="AssignmentResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="AssignmentResource.CreateResourceIdentifier" /> to create an <see cref="AssignmentResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="AssignmentResource"/> object. </returns>
        public virtual AssignmentResource GetAssignmentResource(ResourceIdentifier id)
        {
            AssignmentResource.ValidateResourceId(id);
            return new AssignmentResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="AssignmentOperationResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="AssignmentOperationResource.CreateResourceIdentifier" /> to create an <see cref="AssignmentOperationResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="AssignmentOperationResource"/> object. </returns>
        public virtual AssignmentOperationResource GetAssignmentOperationResource(ResourceIdentifier id)
        {
            AssignmentOperationResource.ValidateResourceId(id);
            return new AssignmentOperationResource(Client, id);
        }
    }
}
