// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.Blueprint
{
    /// <summary>
    /// A Class representing a BlueprintVersionArtifact along with the instance operations that can be performed on it.
    /// If you have a <see cref="ResourceIdentifier"/> you can construct a <see cref="BlueprintVersionArtifactResource"/>
    /// from an instance of <see cref="ArmClient"/> using the GetBlueprintVersionArtifactResource method.
    /// Otherwise you can get one from its parent resource <see cref="PublishedBlueprintResource"/> using the GetBlueprintVersionArtifact method.
    /// </summary>
    public partial class BlueprintVersionArtifactResource : ArmResource
    {
        /// <summary> Generate the resource identifier of a <see cref="BlueprintVersionArtifactResource"/> instance. </summary>
        /// <param name="resourceScope"> The resourceScope. </param>
        /// <param name="blueprintName"> The blueprintName. </param>
        /// <param name="versionId"> The versionId. </param>
        /// <param name="artifactName"> The artifactName. </param>
        public static ResourceIdentifier CreateResourceIdentifier(string resourceScope, string blueprintName, string versionId, string artifactName)
        {
            var resourceId = $"{resourceScope}/providers/Microsoft.Blueprint/blueprints/{blueprintName}/versions/{versionId}/artifacts/{artifactName}";
            return new ResourceIdentifier(resourceId);
        }

        private readonly ClientDiagnostics _blueprintVersionArtifactPublishedArtifactsClientDiagnostics;
        private readonly PublishedArtifactsRestOperations _blueprintVersionArtifactPublishedArtifactsRestClient;
        private readonly ArtifactData _data;

        /// <summary> Gets the resource type for the operations. </summary>
        public static readonly ResourceType ResourceType = "Microsoft.Blueprint/blueprints/versions/artifacts";

        /// <summary> Initializes a new instance of the <see cref="BlueprintVersionArtifactResource"/> class for mocking. </summary>
        protected BlueprintVersionArtifactResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="BlueprintVersionArtifactResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="data"> The resource that is the target of operations. </param>
        internal BlueprintVersionArtifactResource(ArmClient client, ArtifactData data) : this(client, data.Id)
        {
            HasData = true;
            _data = data;
        }

        /// <summary> Initializes a new instance of the <see cref="BlueprintVersionArtifactResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal BlueprintVersionArtifactResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _blueprintVersionArtifactPublishedArtifactsClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Blueprint", ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(ResourceType, out string blueprintVersionArtifactPublishedArtifactsApiVersion);
            _blueprintVersionArtifactPublishedArtifactsRestClient = new PublishedArtifactsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, blueprintVersionArtifactPublishedArtifactsApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        /// <summary> Gets whether or not the current instance has data. </summary>
        public virtual bool HasData { get; }

        /// <summary> Gets the data representing this Feature. </summary>
        /// <exception cref="InvalidOperationException"> Throws if there is no data loaded in the current instance. </exception>
        public virtual ArtifactData Data
        {
            get
            {
                if (!HasData)
                    throw new InvalidOperationException("The current instance does not have data, you must call Get first.");
                return _data;
            }
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, ResourceType), nameof(id));
        }

        /// <summary>
        /// Get an artifact for a published blueprint definition.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceScope}/providers/Microsoft.Blueprint/blueprints/{blueprintName}/versions/{versionId}/artifacts/{artifactName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>PublishedArtifacts_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2018-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BlueprintVersionArtifactResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<BlueprintVersionArtifactResource>> GetAsync(CancellationToken cancellationToken = default)
        {
            using var scope = _blueprintVersionArtifactPublishedArtifactsClientDiagnostics.CreateScope("BlueprintVersionArtifactResource.Get");
            scope.Start();
            try
            {
                var response = await _blueprintVersionArtifactPublishedArtifactsRestClient.GetAsync(Id.Parent.Parent.Parent, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new BlueprintVersionArtifactResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get an artifact for a published blueprint definition.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceScope}/providers/Microsoft.Blueprint/blueprints/{blueprintName}/versions/{versionId}/artifacts/{artifactName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>PublishedArtifacts_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2018-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="BlueprintVersionArtifactResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<BlueprintVersionArtifactResource> Get(CancellationToken cancellationToken = default)
        {
            using var scope = _blueprintVersionArtifactPublishedArtifactsClientDiagnostics.CreateScope("BlueprintVersionArtifactResource.Get");
            scope.Start();
            try
            {
                var response = _blueprintVersionArtifactPublishedArtifactsRestClient.Get(Id.Parent.Parent.Parent, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new BlueprintVersionArtifactResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }
    }
}
