// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Blueprint.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Blueprint
{
    /// <summary>
    /// A class representing the AssignmentOperation data model.
    /// Represents underlying deployment detail for each update to the blueprint assignment.
    /// </summary>
    public partial class AssignmentOperationData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AssignmentOperationData"/>. </summary>
        public AssignmentOperationData()
        {
            Deployments = new ChangeTrackingList<AssignmentDeploymentJob>();
        }

        /// <summary> Initializes a new instance of <see cref="AssignmentOperationData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="blueprintVersion"> The published version of the blueprint definition used for the blueprint assignment operation. </param>
        /// <param name="assignmentState"> State of this blueprint assignment operation. </param>
        /// <param name="timeCreated"> Create time of this blueprint assignment operation. </param>
        /// <param name="timeStarted"> Start time of the underlying deployment. </param>
        /// <param name="timeFinished"> Finish time of the overall underlying deployments. </param>
        /// <param name="deployments"> List of jobs in this blueprint assignment operation. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AssignmentOperationData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, string blueprintVersion, string assignmentState, string timeCreated, string timeStarted, string timeFinished, IList<AssignmentDeploymentJob> deployments, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            BlueprintVersion = blueprintVersion;
            AssignmentState = assignmentState;
            TimeCreated = timeCreated;
            TimeStarted = timeStarted;
            TimeFinished = timeFinished;
            Deployments = deployments;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The published version of the blueprint definition used for the blueprint assignment operation. </summary>
        public string BlueprintVersion { get; set; }
        /// <summary> State of this blueprint assignment operation. </summary>
        public string AssignmentState { get; set; }
        /// <summary> Create time of this blueprint assignment operation. </summary>
        public string TimeCreated { get; set; }
        /// <summary> Start time of the underlying deployment. </summary>
        public string TimeStarted { get; set; }
        /// <summary> Finish time of the overall underlying deployments. </summary>
        public string TimeFinished { get; set; }
        /// <summary> List of jobs in this blueprint assignment operation. </summary>
        public IList<AssignmentDeploymentJob> Deployments { get; }
    }
}
