// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.Blueprint.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Blueprint
{
    public partial class AssignmentOperationData : IUtf8JsonSerializable, IJsonModel<AssignmentOperationData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<AssignmentOperationData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<AssignmentOperationData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AssignmentOperationData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AssignmentOperationData)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (Optional.IsDefined(BlueprintVersion))
            {
                writer.WritePropertyName("blueprintVersion"u8);
                writer.WriteStringValue(BlueprintVersion);
            }
            if (Optional.IsDefined(AssignmentState))
            {
                writer.WritePropertyName("assignmentState"u8);
                writer.WriteStringValue(AssignmentState);
            }
            if (Optional.IsDefined(TimeCreated))
            {
                writer.WritePropertyName("timeCreated"u8);
                writer.WriteStringValue(TimeCreated);
            }
            if (Optional.IsDefined(TimeStarted))
            {
                writer.WritePropertyName("timeStarted"u8);
                writer.WriteStringValue(TimeStarted);
            }
            if (Optional.IsDefined(TimeFinished))
            {
                writer.WritePropertyName("timeFinished"u8);
                writer.WriteStringValue(TimeFinished);
            }
            if (Optional.IsCollectionDefined(Deployments))
            {
                writer.WritePropertyName("deployments"u8);
                writer.WriteStartArray();
                foreach (var item in Deployments)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            writer.WriteEndObject();
        }

        AssignmentOperationData IJsonModel<AssignmentOperationData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AssignmentOperationData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(AssignmentOperationData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeAssignmentOperationData(document.RootElement, options);
        }

        internal static AssignmentOperationData DeserializeAssignmentOperationData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ResourceIdentifier id = default;
            string name = default;
            ResourceType type = default;
            SystemData systemData = default;
            string blueprintVersion = default;
            string assignmentState = default;
            string timeCreated = default;
            string timeStarted = default;
            string timeFinished = default;
            IList<AssignmentDeploymentJob> deployments = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("id"u8))
                {
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemData = JsonSerializer.Deserialize<SystemData>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("blueprintVersion"u8))
                        {
                            blueprintVersion = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("assignmentState"u8))
                        {
                            assignmentState = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("timeCreated"u8))
                        {
                            timeCreated = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("timeStarted"u8))
                        {
                            timeStarted = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("timeFinished"u8))
                        {
                            timeFinished = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("deployments"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<AssignmentDeploymentJob> array = new List<AssignmentDeploymentJob>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(AssignmentDeploymentJob.DeserializeAssignmentDeploymentJob(item, options));
                            }
                            deployments = array;
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new AssignmentOperationData(
                id,
                name,
                type,
                systemData,
                blueprintVersion,
                assignmentState,
                timeCreated,
                timeStarted,
                timeFinished,
                deployments ?? new ChangeTrackingList<AssignmentDeploymentJob>(),
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<AssignmentOperationData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AssignmentOperationData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(AssignmentOperationData)} does not support writing '{options.Format}' format.");
            }
        }

        AssignmentOperationData IPersistableModel<AssignmentOperationData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<AssignmentOperationData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeAssignmentOperationData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(AssignmentOperationData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<AssignmentOperationData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
