// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.Blueprint
{
    /// <summary>
    /// A class representing a collection of <see cref="AssignmentResource"/> and their operations.
    /// Each <see cref="AssignmentResource"/> in the collection will belong to the same instance of <see cref="ArmResource"/>.
    /// To get an <see cref="AssignmentCollection"/> instance call the GetAssignments method from an instance of <see cref="ArmResource"/>.
    /// </summary>
    public partial class AssignmentCollection : ArmCollection, IEnumerable<AssignmentResource>, IAsyncEnumerable<AssignmentResource>
    {
        private readonly ClientDiagnostics _assignmentClientDiagnostics;
        private readonly AssignmentsRestOperations _assignmentRestClient;

        /// <summary> Initializes a new instance of the <see cref="AssignmentCollection"/> class for mocking. </summary>
        protected AssignmentCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="AssignmentCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal AssignmentCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _assignmentClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Blueprint", AssignmentResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(AssignmentResource.ResourceType, out string assignmentApiVersion);
            _assignmentRestClient = new AssignmentsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, assignmentApiVersion);
        }

        /// <summary>
        /// Create or update a blueprint assignment.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceScope}/providers/Microsoft.Blueprint/blueprintAssignments/{assignmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Assignments_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2018-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AssignmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="assignmentName"> Name of the blueprint assignment. </param>
        /// <param name="data"> Blueprint assignment object to save. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="assignmentName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="assignmentName"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<AssignmentResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string assignmentName, AssignmentData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(assignmentName, nameof(assignmentName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _assignmentClientDiagnostics.CreateScope("AssignmentCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _assignmentRestClient.CreateOrUpdateAsync(Id, assignmentName, data, cancellationToken).ConfigureAwait(false);
                var uri = _assignmentRestClient.CreateCreateOrUpdateRequestUri(Id, assignmentName, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new BlueprintArmOperation<AssignmentResource>(Response.FromValue(new AssignmentResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Create or update a blueprint assignment.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceScope}/providers/Microsoft.Blueprint/blueprintAssignments/{assignmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Assignments_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2018-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AssignmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="assignmentName"> Name of the blueprint assignment. </param>
        /// <param name="data"> Blueprint assignment object to save. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="assignmentName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="assignmentName"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<AssignmentResource> CreateOrUpdate(WaitUntil waitUntil, string assignmentName, AssignmentData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(assignmentName, nameof(assignmentName));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _assignmentClientDiagnostics.CreateScope("AssignmentCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _assignmentRestClient.CreateOrUpdate(Id, assignmentName, data, cancellationToken);
                var uri = _assignmentRestClient.CreateCreateOrUpdateRequestUri(Id, assignmentName, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new BlueprintArmOperation<AssignmentResource>(Response.FromValue(new AssignmentResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get a blueprint assignment.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceScope}/providers/Microsoft.Blueprint/blueprintAssignments/{assignmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Assignments_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2018-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AssignmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="assignmentName"> Name of the blueprint assignment. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="assignmentName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="assignmentName"/> is null. </exception>
        public virtual async Task<Response<AssignmentResource>> GetAsync(string assignmentName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(assignmentName, nameof(assignmentName));

            using var scope = _assignmentClientDiagnostics.CreateScope("AssignmentCollection.Get");
            scope.Start();
            try
            {
                var response = await _assignmentRestClient.GetAsync(Id, assignmentName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new AssignmentResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get a blueprint assignment.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceScope}/providers/Microsoft.Blueprint/blueprintAssignments/{assignmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Assignments_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2018-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AssignmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="assignmentName"> Name of the blueprint assignment. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="assignmentName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="assignmentName"/> is null. </exception>
        public virtual Response<AssignmentResource> Get(string assignmentName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(assignmentName, nameof(assignmentName));

            using var scope = _assignmentClientDiagnostics.CreateScope("AssignmentCollection.Get");
            scope.Start();
            try
            {
                var response = _assignmentRestClient.Get(Id, assignmentName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new AssignmentResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// List blueprint assignments within a subscription or a management group.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceScope}/providers/Microsoft.Blueprint/blueprintAssignments</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Assignments_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2018-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AssignmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="AssignmentResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<AssignmentResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _assignmentRestClient.CreateListRequest(Id);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _assignmentRestClient.CreateListNextPageRequest(nextLink, Id);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new AssignmentResource(Client, AssignmentData.DeserializeAssignmentData(e)), _assignmentClientDiagnostics, Pipeline, "AssignmentCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// List blueprint assignments within a subscription or a management group.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceScope}/providers/Microsoft.Blueprint/blueprintAssignments</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Assignments_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2018-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AssignmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="AssignmentResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<AssignmentResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _assignmentRestClient.CreateListRequest(Id);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _assignmentRestClient.CreateListNextPageRequest(nextLink, Id);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new AssignmentResource(Client, AssignmentData.DeserializeAssignmentData(e)), _assignmentClientDiagnostics, Pipeline, "AssignmentCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceScope}/providers/Microsoft.Blueprint/blueprintAssignments/{assignmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Assignments_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2018-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AssignmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="assignmentName"> Name of the blueprint assignment. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="assignmentName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="assignmentName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string assignmentName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(assignmentName, nameof(assignmentName));

            using var scope = _assignmentClientDiagnostics.CreateScope("AssignmentCollection.Exists");
            scope.Start();
            try
            {
                var response = await _assignmentRestClient.GetAsync(Id, assignmentName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceScope}/providers/Microsoft.Blueprint/blueprintAssignments/{assignmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Assignments_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2018-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AssignmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="assignmentName"> Name of the blueprint assignment. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="assignmentName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="assignmentName"/> is null. </exception>
        public virtual Response<bool> Exists(string assignmentName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(assignmentName, nameof(assignmentName));

            using var scope = _assignmentClientDiagnostics.CreateScope("AssignmentCollection.Exists");
            scope.Start();
            try
            {
                var response = _assignmentRestClient.Get(Id, assignmentName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceScope}/providers/Microsoft.Blueprint/blueprintAssignments/{assignmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Assignments_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2018-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AssignmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="assignmentName"> Name of the blueprint assignment. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="assignmentName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="assignmentName"/> is null. </exception>
        public virtual async Task<NullableResponse<AssignmentResource>> GetIfExistsAsync(string assignmentName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(assignmentName, nameof(assignmentName));

            using var scope = _assignmentClientDiagnostics.CreateScope("AssignmentCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _assignmentRestClient.GetAsync(Id, assignmentName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<AssignmentResource>(response.GetRawResponse());
                return Response.FromValue(new AssignmentResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/{resourceScope}/providers/Microsoft.Blueprint/blueprintAssignments/{assignmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Assignments_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2018-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="AssignmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="assignmentName"> Name of the blueprint assignment. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="assignmentName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="assignmentName"/> is null. </exception>
        public virtual NullableResponse<AssignmentResource> GetIfExists(string assignmentName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(assignmentName, nameof(assignmentName));

            using var scope = _assignmentClientDiagnostics.CreateScope("AssignmentCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _assignmentRestClient.Get(Id, assignmentName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<AssignmentResource>(response.GetRawResponse());
                return Response.FromValue(new AssignmentResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<AssignmentResource> IEnumerable<AssignmentResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<AssignmentResource> IAsyncEnumerable<AssignmentResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
