// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Blueprint.Models;

namespace Azure.ResourceManager.Blueprint.Samples
{
    public partial class Sample_BlueprintArtifactResource
    {
        // MG-ARMTemplateArtifact
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_MGARMTemplateArtifact()
        {
            // Generated from example definition: specification/blueprint/resource-manager/Microsoft.Blueprint/preview/2018-11-01-preview/examples/managementGroupBPDef/ARMTemplateArtifact_Create.json
            // this example is just showing the usage of "Artifacts_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BlueprintArtifactResource created on azure
            // for more information of creating BlueprintArtifactResource, please refer to the document of BlueprintArtifactResource
            string resourceScope = "providers/Microsoft.Management/managementGroups/ContosoOnlineGroup";
            string blueprintName = "simpleBlueprint";
            string artifactName = "storageTemplate";
            ResourceIdentifier blueprintArtifactResourceId = BlueprintArtifactResource.CreateResourceIdentifier(resourceScope, blueprintName, artifactName);
            BlueprintArtifactResource blueprintArtifact = client.GetBlueprintArtifactResource(blueprintArtifactResourceId);

            // invoke the operation
            ArtifactData data = new TemplateArtifact(BinaryData.FromObjectAsJson(new Dictionary<string, object>()
            {
                ["contentVersion"] = "1.0.0.0",
                ["outputs"] = new Dictionary<string, object>()
                {
                    ["storageAccountName"] = new Dictionary<string, object>()
                    {
                        ["type"] = "string",
                        ["value"] = "[variables('storageAccountName')]"
                    }
                },
                ["parameters"] = new Dictionary<string, object>()
                {
                    ["storageAccountType"] = new Dictionary<string, object>()
                    {
                        ["type"] = "string",
                        ["allowedValues"] = new object[] { "Standard_LRS", "Standard_GRS", "Standard_ZRS", "Premium_LRS" },
                        ["defaultValue"] = "Standard_LRS",
                        ["metadata"] = new Dictionary<string, object>()
                        {
                            ["description"] = "Storage Account type"
                        }
                    }
                },
                ["resources"] = new object[] { new Dictionary<string, object>()
{
["name"] = "[variables('storageAccountName')]",
["type"] = "Microsoft.Storage/storageAccounts",
["apiVersion"] = "2016-01-01",
["kind"] = "Storage",
["location"] = "[resourceGroup().location]",
["properties"] = new Dictionary<string, object>()
{
},
["sku"] = new Dictionary<string, object>()
{
["name"] = "[parameters('storageAccountType')]"}} },
                ["variables"] = new Dictionary<string, object>()
                {
                    ["storageAccountName"] = "[concat(uniquestring(resourceGroup().id), 'standardsa')]"
                }
            }), new Dictionary<string, ParameterValue>()
            {
                ["storageAccountType"] = new ParameterValue()
                {
                    Value = BinaryData.FromString("\"[parameters('storageAccountType')]\""),
                },
            })
            {
                ResourceGroup = "storageRG",
            };
            ArmOperation<BlueprintArtifactResource> lro = await blueprintArtifact.UpdateAsync(WaitUntil.Completed, data);
            BlueprintArtifactResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ArtifactData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // MG-PolicyAssignmentArtifact
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_MGPolicyAssignmentArtifact()
        {
            // Generated from example definition: specification/blueprint/resource-manager/Microsoft.Blueprint/preview/2018-11-01-preview/examples/managementGroupBPDef/PolicyAssignmentArtifact_Create.json
            // this example is just showing the usage of "Artifacts_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BlueprintArtifactResource created on azure
            // for more information of creating BlueprintArtifactResource, please refer to the document of BlueprintArtifactResource
            string resourceScope = "providers/Microsoft.Management/managementGroups/ContosoOnlineGroup";
            string blueprintName = "simpleBlueprint";
            string artifactName = "costCenterPolicy";
            ResourceIdentifier blueprintArtifactResourceId = BlueprintArtifactResource.CreateResourceIdentifier(resourceScope, blueprintName, artifactName);
            BlueprintArtifactResource blueprintArtifact = client.GetBlueprintArtifactResource(blueprintArtifactResourceId);

            // invoke the operation
            ArtifactData data = new PolicyAssignmentArtifact("/providers/Microsoft.Authorization/policyDefinitions/1e30110a-5ceb-460c-a204-c1c3969c6d62", new Dictionary<string, ParameterValue>()
            {
                ["tagName"] = new ParameterValue()
                {
                    Value = BinaryData.FromString("\"costCenter\""),
                },
                ["tagValue"] = new ParameterValue()
                {
                    Value = BinaryData.FromString("\"[parameter('costCenter')]\""),
                },
            })
            {
                DisplayName = "force costCenter tag on all resources",
            };
            ArmOperation<BlueprintArtifactResource> lro = await blueprintArtifact.UpdateAsync(WaitUntil.Completed, data);
            BlueprintArtifactResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ArtifactData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // MG-RoleAssignmentArtifact
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_MGRoleAssignmentArtifact()
        {
            // Generated from example definition: specification/blueprint/resource-manager/Microsoft.Blueprint/preview/2018-11-01-preview/examples/managementGroupBPDef/RoleAssignmentArtifact_Create.json
            // this example is just showing the usage of "Artifacts_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BlueprintArtifactResource created on azure
            // for more information of creating BlueprintArtifactResource, please refer to the document of BlueprintArtifactResource
            string resourceScope = "providers/Microsoft.Management/managementGroups/ContosoOnlineGroup";
            string blueprintName = "simpleBlueprint";
            string artifactName = "ownerAssignment";
            ResourceIdentifier blueprintArtifactResourceId = BlueprintArtifactResource.CreateResourceIdentifier(resourceScope, blueprintName, artifactName);
            BlueprintArtifactResource blueprintArtifact = client.GetBlueprintArtifactResource(blueprintArtifactResourceId);

            // invoke the operation
            ArtifactData data = new RoleAssignmentArtifact("/providers/Microsoft.Authorization/roleDefinitions/acdd72a7-3385-48ef-bd42-f606fba81ae7", BinaryData.FromString("\"[parameters('owners')]\""))
            {
                DisplayName = "enforce owners of given subscription",
            };
            ArmOperation<BlueprintArtifactResource> lro = await blueprintArtifact.UpdateAsync(WaitUntil.Completed, data);
            BlueprintArtifactResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ArtifactData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Sub-ARMTemplateArtifact
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_SubARMTemplateArtifact()
        {
            // Generated from example definition: specification/blueprint/resource-manager/Microsoft.Blueprint/preview/2018-11-01-preview/examples/subscriptionBPDef/ARMTemplateArtifact_Create.json
            // this example is just showing the usage of "Artifacts_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BlueprintArtifactResource created on azure
            // for more information of creating BlueprintArtifactResource, please refer to the document of BlueprintArtifactResource
            string resourceScope = "subscriptions/00000000-0000-0000-0000-000000000000";
            string blueprintName = "simpleBlueprint";
            string artifactName = "storageTemplate";
            ResourceIdentifier blueprintArtifactResourceId = BlueprintArtifactResource.CreateResourceIdentifier(resourceScope, blueprintName, artifactName);
            BlueprintArtifactResource blueprintArtifact = client.GetBlueprintArtifactResource(blueprintArtifactResourceId);

            // invoke the operation
            ArtifactData data = new TemplateArtifact(BinaryData.FromObjectAsJson(new Dictionary<string, object>()
            {
                ["contentVersion"] = "1.0.0.0",
                ["outputs"] = new Dictionary<string, object>()
                {
                    ["storageAccountName"] = new Dictionary<string, object>()
                    {
                        ["type"] = "string",
                        ["value"] = "[variables('storageAccountName')]"
                    }
                },
                ["parameters"] = new Dictionary<string, object>()
                {
                    ["storageAccountType"] = new Dictionary<string, object>()
                    {
                        ["type"] = "string",
                        ["allowedValues"] = new object[] { "Standard_LRS", "Standard_GRS", "Standard_ZRS", "Premium_LRS" },
                        ["defaultValue"] = "Standard_LRS",
                        ["metadata"] = new Dictionary<string, object>()
                        {
                            ["description"] = "Storage Account type"
                        }
                    }
                },
                ["resources"] = new object[] { new Dictionary<string, object>()
{
["name"] = "[variables('storageAccountName')]",
["type"] = "Microsoft.Storage/storageAccounts",
["apiVersion"] = "2016-01-01",
["kind"] = "Storage",
["location"] = "[resourceGroup().location]",
["properties"] = new Dictionary<string, object>()
{
},
["sku"] = new Dictionary<string, object>()
{
["name"] = "[parameters('storageAccountType')]"}} },
                ["variables"] = new Dictionary<string, object>()
                {
                    ["storageAccountName"] = "[concat(uniquestring(resourceGroup().id), 'standardsa')]"
                }
            }), new Dictionary<string, ParameterValue>()
            {
                ["storageAccountType"] = new ParameterValue()
                {
                    Value = BinaryData.FromString("\"[parameters('storageAccountType')]\""),
                },
            })
            {
                ResourceGroup = "storageRG",
            };
            ArmOperation<BlueprintArtifactResource> lro = await blueprintArtifact.UpdateAsync(WaitUntil.Completed, data);
            BlueprintArtifactResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ArtifactData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Sub-PolicyAssignmentArtifact
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_SubPolicyAssignmentArtifact()
        {
            // Generated from example definition: specification/blueprint/resource-manager/Microsoft.Blueprint/preview/2018-11-01-preview/examples/subscriptionBPDef/PolicyAssignmentArtifact_Create.json
            // this example is just showing the usage of "Artifacts_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BlueprintArtifactResource created on azure
            // for more information of creating BlueprintArtifactResource, please refer to the document of BlueprintArtifactResource
            string resourceScope = "subscriptions/00000000-0000-0000-0000-000000000000";
            string blueprintName = "simpleBlueprint";
            string artifactName = "costCenterPolicy";
            ResourceIdentifier blueprintArtifactResourceId = BlueprintArtifactResource.CreateResourceIdentifier(resourceScope, blueprintName, artifactName);
            BlueprintArtifactResource blueprintArtifact = client.GetBlueprintArtifactResource(blueprintArtifactResourceId);

            // invoke the operation
            ArtifactData data = new PolicyAssignmentArtifact("/providers/Microsoft.Authorization/policyDefinitions/1e30110a-5ceb-460c-a204-c1c3969c6d62", new Dictionary<string, ParameterValue>()
            {
                ["tagName"] = new ParameterValue()
                {
                    Value = BinaryData.FromString("\"costCenter\""),
                },
                ["tagValue"] = new ParameterValue()
                {
                    Value = BinaryData.FromString("\"[parameter('costCenter')]\""),
                },
            })
            {
                DisplayName = "force costCenter tag on all resources",
            };
            ArmOperation<BlueprintArtifactResource> lro = await blueprintArtifact.UpdateAsync(WaitUntil.Completed, data);
            BlueprintArtifactResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ArtifactData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Sub-RoleAssignmentArtifact
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_SubRoleAssignmentArtifact()
        {
            // Generated from example definition: specification/blueprint/resource-manager/Microsoft.Blueprint/preview/2018-11-01-preview/examples/subscriptionBPDef/RoleAssignmentArtifact_Create.json
            // this example is just showing the usage of "Artifacts_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BlueprintArtifactResource created on azure
            // for more information of creating BlueprintArtifactResource, please refer to the document of BlueprintArtifactResource
            string resourceScope = "subscriptions/00000000-0000-0000-0000-000000000000";
            string blueprintName = "simpleBlueprint";
            string artifactName = "ownerAssignment";
            ResourceIdentifier blueprintArtifactResourceId = BlueprintArtifactResource.CreateResourceIdentifier(resourceScope, blueprintName, artifactName);
            BlueprintArtifactResource blueprintArtifact = client.GetBlueprintArtifactResource(blueprintArtifactResourceId);

            // invoke the operation
            ArtifactData data = new RoleAssignmentArtifact("/providers/Microsoft.Authorization/roleDefinitions/acdd72a7-3385-48ef-bd42-f606fba81ae7", BinaryData.FromString("\"[parameters('owners')]\""))
            {
                DisplayName = "enforce owners of given subscription",
            };
            ArmOperation<BlueprintArtifactResource> lro = await blueprintArtifact.UpdateAsync(WaitUntil.Completed, data);
            BlueprintArtifactResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ArtifactData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // MG-ARMTemplateArtifact
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_MGARMTemplateArtifact()
        {
            // Generated from example definition: specification/blueprint/resource-manager/Microsoft.Blueprint/preview/2018-11-01-preview/examples/managementGroupBPDef/ARMTemplateArtifact_Get.json
            // this example is just showing the usage of "Artifacts_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BlueprintArtifactResource created on azure
            // for more information of creating BlueprintArtifactResource, please refer to the document of BlueprintArtifactResource
            string resourceScope = "providers/Microsoft.Management/managementGroups/ContosoOnlineGroup";
            string blueprintName = "simpleBlueprint";
            string artifactName = "storageTemplate";
            ResourceIdentifier blueprintArtifactResourceId = BlueprintArtifactResource.CreateResourceIdentifier(resourceScope, blueprintName, artifactName);
            BlueprintArtifactResource blueprintArtifact = client.GetBlueprintArtifactResource(blueprintArtifactResourceId);

            // invoke the operation
            BlueprintArtifactResource result = await blueprintArtifact.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ArtifactData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // MG-PolicyAssignmentArtifact
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_MGPolicyAssignmentArtifact()
        {
            // Generated from example definition: specification/blueprint/resource-manager/Microsoft.Blueprint/preview/2018-11-01-preview/examples/managementGroupBPDef/PolicyAssignmentArtifact_Get.json
            // this example is just showing the usage of "Artifacts_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BlueprintArtifactResource created on azure
            // for more information of creating BlueprintArtifactResource, please refer to the document of BlueprintArtifactResource
            string resourceScope = "providers/Microsoft.Management/managementGroups/ContosoOnlineGroup";
            string blueprintName = "simpleBlueprint";
            string artifactName = "costCenterPolicy";
            ResourceIdentifier blueprintArtifactResourceId = BlueprintArtifactResource.CreateResourceIdentifier(resourceScope, blueprintName, artifactName);
            BlueprintArtifactResource blueprintArtifact = client.GetBlueprintArtifactResource(blueprintArtifactResourceId);

            // invoke the operation
            BlueprintArtifactResource result = await blueprintArtifact.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ArtifactData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // MG-RoleAssignmentArtifact
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_MGRoleAssignmentArtifact()
        {
            // Generated from example definition: specification/blueprint/resource-manager/Microsoft.Blueprint/preview/2018-11-01-preview/examples/managementGroupBPDef/RoleAssignmentArtifact_Get.json
            // this example is just showing the usage of "Artifacts_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BlueprintArtifactResource created on azure
            // for more information of creating BlueprintArtifactResource, please refer to the document of BlueprintArtifactResource
            string resourceScope = "providers/Microsoft.Management/managementGroups/ContosoOnlineGroup";
            string blueprintName = "simpleBlueprint";
            string artifactName = "ownerAssignment";
            ResourceIdentifier blueprintArtifactResourceId = BlueprintArtifactResource.CreateResourceIdentifier(resourceScope, blueprintName, artifactName);
            BlueprintArtifactResource blueprintArtifact = client.GetBlueprintArtifactResource(blueprintArtifactResourceId);

            // invoke the operation
            BlueprintArtifactResource result = await blueprintArtifact.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ArtifactData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Sub-ARMTemplateArtifact
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_SubARMTemplateArtifact()
        {
            // Generated from example definition: specification/blueprint/resource-manager/Microsoft.Blueprint/preview/2018-11-01-preview/examples/subscriptionBPDef/ARMTemplateArtifact_Get.json
            // this example is just showing the usage of "Artifacts_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BlueprintArtifactResource created on azure
            // for more information of creating BlueprintArtifactResource, please refer to the document of BlueprintArtifactResource
            string resourceScope = "subscriptions/00000000-0000-0000-0000-000000000000";
            string blueprintName = "simpleBlueprint";
            string artifactName = "storageTemplate";
            ResourceIdentifier blueprintArtifactResourceId = BlueprintArtifactResource.CreateResourceIdentifier(resourceScope, blueprintName, artifactName);
            BlueprintArtifactResource blueprintArtifact = client.GetBlueprintArtifactResource(blueprintArtifactResourceId);

            // invoke the operation
            BlueprintArtifactResource result = await blueprintArtifact.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ArtifactData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Sub-PolicyAssignmentArtifact
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_SubPolicyAssignmentArtifact()
        {
            // Generated from example definition: specification/blueprint/resource-manager/Microsoft.Blueprint/preview/2018-11-01-preview/examples/subscriptionBPDef/PolicyAssignmentArtifact_Get.json
            // this example is just showing the usage of "Artifacts_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BlueprintArtifactResource created on azure
            // for more information of creating BlueprintArtifactResource, please refer to the document of BlueprintArtifactResource
            string resourceScope = "subscriptions/00000000-0000-0000-0000-000000000000";
            string blueprintName = "simpleBlueprint";
            string artifactName = "costCenterPolicy";
            ResourceIdentifier blueprintArtifactResourceId = BlueprintArtifactResource.CreateResourceIdentifier(resourceScope, blueprintName, artifactName);
            BlueprintArtifactResource blueprintArtifact = client.GetBlueprintArtifactResource(blueprintArtifactResourceId);

            // invoke the operation
            BlueprintArtifactResource result = await blueprintArtifact.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ArtifactData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Sub-RoleAssignmentArtifact
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_SubRoleAssignmentArtifact()
        {
            // Generated from example definition: specification/blueprint/resource-manager/Microsoft.Blueprint/preview/2018-11-01-preview/examples/subscriptionBPDef/RoleAssignmentArtifact_Get.json
            // this example is just showing the usage of "Artifacts_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BlueprintArtifactResource created on azure
            // for more information of creating BlueprintArtifactResource, please refer to the document of BlueprintArtifactResource
            string resourceScope = "subscriptions/00000000-0000-0000-0000-000000000000";
            string blueprintName = "simpleBlueprint";
            string artifactName = "ownerAssignment";
            ResourceIdentifier blueprintArtifactResourceId = BlueprintArtifactResource.CreateResourceIdentifier(resourceScope, blueprintName, artifactName);
            BlueprintArtifactResource blueprintArtifact = client.GetBlueprintArtifactResource(blueprintArtifactResourceId);

            // invoke the operation
            BlueprintArtifactResource result = await blueprintArtifact.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ArtifactData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // MG-ARMTemplateArtifact
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_MGARMTemplateArtifact()
        {
            // Generated from example definition: specification/blueprint/resource-manager/Microsoft.Blueprint/preview/2018-11-01-preview/examples/managementGroupBPDef/ARMTemplateArtifact_Delete.json
            // this example is just showing the usage of "Artifacts_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BlueprintArtifactResource created on azure
            // for more information of creating BlueprintArtifactResource, please refer to the document of BlueprintArtifactResource
            string resourceScope = "providers/Microsoft.Management/managementGroups/ContosoOnlineGroup";
            string blueprintName = "simpleBlueprint";
            string artifactName = "storageTemplate";
            ResourceIdentifier blueprintArtifactResourceId = BlueprintArtifactResource.CreateResourceIdentifier(resourceScope, blueprintName, artifactName);
            BlueprintArtifactResource blueprintArtifact = client.GetBlueprintArtifactResource(blueprintArtifactResourceId);

            // invoke the operation
            ArmOperation<BlueprintArtifactResource> lro = await blueprintArtifact.DeleteAsync(WaitUntil.Completed);
            BlueprintArtifactResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ArtifactData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // MG-PolicyAssignmentArtifact
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_MGPolicyAssignmentArtifact()
        {
            // Generated from example definition: specification/blueprint/resource-manager/Microsoft.Blueprint/preview/2018-11-01-preview/examples/managementGroupBPDef/PolicyAssignmentArtifact_Delete.json
            // this example is just showing the usage of "Artifacts_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BlueprintArtifactResource created on azure
            // for more information of creating BlueprintArtifactResource, please refer to the document of BlueprintArtifactResource
            string resourceScope = "providers/Microsoft.Management/managementGroups/ContosoOnlineGroup";
            string blueprintName = "simpleBlueprint";
            string artifactName = "costCenterPolicy";
            ResourceIdentifier blueprintArtifactResourceId = BlueprintArtifactResource.CreateResourceIdentifier(resourceScope, blueprintName, artifactName);
            BlueprintArtifactResource blueprintArtifact = client.GetBlueprintArtifactResource(blueprintArtifactResourceId);

            // invoke the operation
            ArmOperation<BlueprintArtifactResource> lro = await blueprintArtifact.DeleteAsync(WaitUntil.Completed);
            BlueprintArtifactResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ArtifactData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // MG-RoleAssignmentArtifact
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_MGRoleAssignmentArtifact()
        {
            // Generated from example definition: specification/blueprint/resource-manager/Microsoft.Blueprint/preview/2018-11-01-preview/examples/managementGroupBPDef/RoleAssignmentArtifact_Delete.json
            // this example is just showing the usage of "Artifacts_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BlueprintArtifactResource created on azure
            // for more information of creating BlueprintArtifactResource, please refer to the document of BlueprintArtifactResource
            string resourceScope = "providers/Microsoft.Management/managementGroups/ContosoOnlineGroup";
            string blueprintName = "simpleBlueprint";
            string artifactName = "ownerAssignment";
            ResourceIdentifier blueprintArtifactResourceId = BlueprintArtifactResource.CreateResourceIdentifier(resourceScope, blueprintName, artifactName);
            BlueprintArtifactResource blueprintArtifact = client.GetBlueprintArtifactResource(blueprintArtifactResourceId);

            // invoke the operation
            ArmOperation<BlueprintArtifactResource> lro = await blueprintArtifact.DeleteAsync(WaitUntil.Completed);
            BlueprintArtifactResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ArtifactData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Sub-ARMTemplateArtifact
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_SubARMTemplateArtifact()
        {
            // Generated from example definition: specification/blueprint/resource-manager/Microsoft.Blueprint/preview/2018-11-01-preview/examples/subscriptionBPDef/ARMTemplateArtifact_Delete.json
            // this example is just showing the usage of "Artifacts_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BlueprintArtifactResource created on azure
            // for more information of creating BlueprintArtifactResource, please refer to the document of BlueprintArtifactResource
            string resourceScope = "subscriptions/00000000-0000-0000-0000-000000000000";
            string blueprintName = "simpleBlueprint";
            string artifactName = "storageTemplate";
            ResourceIdentifier blueprintArtifactResourceId = BlueprintArtifactResource.CreateResourceIdentifier(resourceScope, blueprintName, artifactName);
            BlueprintArtifactResource blueprintArtifact = client.GetBlueprintArtifactResource(blueprintArtifactResourceId);

            // invoke the operation
            ArmOperation<BlueprintArtifactResource> lro = await blueprintArtifact.DeleteAsync(WaitUntil.Completed);
            BlueprintArtifactResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ArtifactData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Sub-PolicyAssignmentArtifact
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_SubPolicyAssignmentArtifact()
        {
            // Generated from example definition: specification/blueprint/resource-manager/Microsoft.Blueprint/preview/2018-11-01-preview/examples/subscriptionBPDef/PolicyAssignmentArtifact_Delete.json
            // this example is just showing the usage of "Artifacts_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BlueprintArtifactResource created on azure
            // for more information of creating BlueprintArtifactResource, please refer to the document of BlueprintArtifactResource
            string resourceScope = "subscriptions/00000000-0000-0000-0000-000000000000";
            string blueprintName = "simpleBlueprint";
            string artifactName = "costCenterPolicy";
            ResourceIdentifier blueprintArtifactResourceId = BlueprintArtifactResource.CreateResourceIdentifier(resourceScope, blueprintName, artifactName);
            BlueprintArtifactResource blueprintArtifact = client.GetBlueprintArtifactResource(blueprintArtifactResourceId);

            // invoke the operation
            ArmOperation<BlueprintArtifactResource> lro = await blueprintArtifact.DeleteAsync(WaitUntil.Completed);
            BlueprintArtifactResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ArtifactData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Sub-RoleAssignmentArtifact
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_SubRoleAssignmentArtifact()
        {
            // Generated from example definition: specification/blueprint/resource-manager/Microsoft.Blueprint/preview/2018-11-01-preview/examples/subscriptionBPDef/RoleAssignmentArtifact_Delete.json
            // this example is just showing the usage of "Artifacts_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BlueprintArtifactResource created on azure
            // for more information of creating BlueprintArtifactResource, please refer to the document of BlueprintArtifactResource
            string resourceScope = "subscriptions/00000000-0000-0000-0000-000000000000";
            string blueprintName = "simpleBlueprint";
            string artifactName = "ownerAssignment";
            ResourceIdentifier blueprintArtifactResourceId = BlueprintArtifactResource.CreateResourceIdentifier(resourceScope, blueprintName, artifactName);
            BlueprintArtifactResource blueprintArtifact = client.GetBlueprintArtifactResource(blueprintArtifactResourceId);

            // invoke the operation
            ArmOperation<BlueprintArtifactResource> lro = await blueprintArtifact.DeleteAsync(WaitUntil.Completed);
            BlueprintArtifactResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ArtifactData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
