// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Blueprint.Models;

namespace Azure.ResourceManager.Blueprint.Samples
{
    public partial class Sample_BlueprintArtifactCollection
    {
        // MG-ARMTemplateArtifact
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_MGARMTemplateArtifact()
        {
            // Generated from example definition: specification/blueprint/resource-manager/Microsoft.Blueprint/preview/2018-11-01-preview/examples/managementGroupBPDef/ARMTemplateArtifact_Create.json
            // this example is just showing the usage of "Artifacts_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BlueprintResource created on azure
            // for more information of creating BlueprintResource, please refer to the document of BlueprintResource
            string resourceScope = "providers/Microsoft.Management/managementGroups/ContosoOnlineGroup";
            string blueprintName = "simpleBlueprint";
            ResourceIdentifier blueprintResourceId = BlueprintResource.CreateResourceIdentifier(resourceScope, blueprintName);
            BlueprintResource blueprint = client.GetBlueprintResource(blueprintResourceId);

            // get the collection of this BlueprintArtifactResource
            BlueprintArtifactCollection collection = blueprint.GetBlueprintArtifacts();

            // invoke the operation
            string artifactName = "storageTemplate";
            ArtifactData data = new TemplateArtifact(BinaryData.FromObjectAsJson(new Dictionary<string, object>()
            {
                ["contentVersion"] = "1.0.0.0",
                ["outputs"] = new Dictionary<string, object>()
                {
                    ["storageAccountName"] = new Dictionary<string, object>()
                    {
                        ["type"] = "string",
                        ["value"] = "[variables('storageAccountName')]"
                    }
                },
                ["parameters"] = new Dictionary<string, object>()
                {
                    ["storageAccountType"] = new Dictionary<string, object>()
                    {
                        ["type"] = "string",
                        ["allowedValues"] = new object[] { "Standard_LRS", "Standard_GRS", "Standard_ZRS", "Premium_LRS" },
                        ["defaultValue"] = "Standard_LRS",
                        ["metadata"] = new Dictionary<string, object>()
                        {
                            ["description"] = "Storage Account type"
                        }
                    }
                },
                ["resources"] = new object[] { new Dictionary<string, object>()
{
["name"] = "[variables('storageAccountName')]",
["type"] = "Microsoft.Storage/storageAccounts",
["apiVersion"] = "2016-01-01",
["kind"] = "Storage",
["location"] = "[resourceGroup().location]",
["properties"] = new Dictionary<string, object>()
{
},
["sku"] = new Dictionary<string, object>()
{
["name"] = "[parameters('storageAccountType')]"}} },
                ["variables"] = new Dictionary<string, object>()
                {
                    ["storageAccountName"] = "[concat(uniquestring(resourceGroup().id), 'standardsa')]"
                }
            }), new Dictionary<string, ParameterValue>()
            {
                ["storageAccountType"] = new ParameterValue()
                {
                    Value = BinaryData.FromString("\"[parameters('storageAccountType')]\""),
                },
            })
            {
                ResourceGroup = "storageRG",
            };
            ArmOperation<BlueprintArtifactResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, artifactName, data);
            BlueprintArtifactResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ArtifactData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // MG-PolicyAssignmentArtifact
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_MGPolicyAssignmentArtifact()
        {
            // Generated from example definition: specification/blueprint/resource-manager/Microsoft.Blueprint/preview/2018-11-01-preview/examples/managementGroupBPDef/PolicyAssignmentArtifact_Create.json
            // this example is just showing the usage of "Artifacts_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BlueprintResource created on azure
            // for more information of creating BlueprintResource, please refer to the document of BlueprintResource
            string resourceScope = "providers/Microsoft.Management/managementGroups/ContosoOnlineGroup";
            string blueprintName = "simpleBlueprint";
            ResourceIdentifier blueprintResourceId = BlueprintResource.CreateResourceIdentifier(resourceScope, blueprintName);
            BlueprintResource blueprint = client.GetBlueprintResource(blueprintResourceId);

            // get the collection of this BlueprintArtifactResource
            BlueprintArtifactCollection collection = blueprint.GetBlueprintArtifacts();

            // invoke the operation
            string artifactName = "costCenterPolicy";
            ArtifactData data = new PolicyAssignmentArtifact("/providers/Microsoft.Authorization/policyDefinitions/1e30110a-5ceb-460c-a204-c1c3969c6d62", new Dictionary<string, ParameterValue>()
            {
                ["tagName"] = new ParameterValue()
                {
                    Value = BinaryData.FromString("\"costCenter\""),
                },
                ["tagValue"] = new ParameterValue()
                {
                    Value = BinaryData.FromString("\"[parameter('costCenter')]\""),
                },
            })
            {
                DisplayName = "force costCenter tag on all resources",
            };
            ArmOperation<BlueprintArtifactResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, artifactName, data);
            BlueprintArtifactResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ArtifactData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // MG-RoleAssignmentArtifact
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_MGRoleAssignmentArtifact()
        {
            // Generated from example definition: specification/blueprint/resource-manager/Microsoft.Blueprint/preview/2018-11-01-preview/examples/managementGroupBPDef/RoleAssignmentArtifact_Create.json
            // this example is just showing the usage of "Artifacts_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BlueprintResource created on azure
            // for more information of creating BlueprintResource, please refer to the document of BlueprintResource
            string resourceScope = "providers/Microsoft.Management/managementGroups/ContosoOnlineGroup";
            string blueprintName = "simpleBlueprint";
            ResourceIdentifier blueprintResourceId = BlueprintResource.CreateResourceIdentifier(resourceScope, blueprintName);
            BlueprintResource blueprint = client.GetBlueprintResource(blueprintResourceId);

            // get the collection of this BlueprintArtifactResource
            BlueprintArtifactCollection collection = blueprint.GetBlueprintArtifacts();

            // invoke the operation
            string artifactName = "ownerAssignment";
            ArtifactData data = new RoleAssignmentArtifact("/providers/Microsoft.Authorization/roleDefinitions/acdd72a7-3385-48ef-bd42-f606fba81ae7", BinaryData.FromString("\"[parameters('owners')]\""))
            {
                DisplayName = "enforce owners of given subscription",
            };
            ArmOperation<BlueprintArtifactResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, artifactName, data);
            BlueprintArtifactResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ArtifactData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Sub-ARMTemplateArtifact
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_SubARMTemplateArtifact()
        {
            // Generated from example definition: specification/blueprint/resource-manager/Microsoft.Blueprint/preview/2018-11-01-preview/examples/subscriptionBPDef/ARMTemplateArtifact_Create.json
            // this example is just showing the usage of "Artifacts_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BlueprintResource created on azure
            // for more information of creating BlueprintResource, please refer to the document of BlueprintResource
            string resourceScope = "subscriptions/00000000-0000-0000-0000-000000000000";
            string blueprintName = "simpleBlueprint";
            ResourceIdentifier blueprintResourceId = BlueprintResource.CreateResourceIdentifier(resourceScope, blueprintName);
            BlueprintResource blueprint = client.GetBlueprintResource(blueprintResourceId);

            // get the collection of this BlueprintArtifactResource
            BlueprintArtifactCollection collection = blueprint.GetBlueprintArtifacts();

            // invoke the operation
            string artifactName = "storageTemplate";
            ArtifactData data = new TemplateArtifact(BinaryData.FromObjectAsJson(new Dictionary<string, object>()
            {
                ["contentVersion"] = "1.0.0.0",
                ["outputs"] = new Dictionary<string, object>()
                {
                    ["storageAccountName"] = new Dictionary<string, object>()
                    {
                        ["type"] = "string",
                        ["value"] = "[variables('storageAccountName')]"
                    }
                },
                ["parameters"] = new Dictionary<string, object>()
                {
                    ["storageAccountType"] = new Dictionary<string, object>()
                    {
                        ["type"] = "string",
                        ["allowedValues"] = new object[] { "Standard_LRS", "Standard_GRS", "Standard_ZRS", "Premium_LRS" },
                        ["defaultValue"] = "Standard_LRS",
                        ["metadata"] = new Dictionary<string, object>()
                        {
                            ["description"] = "Storage Account type"
                        }
                    }
                },
                ["resources"] = new object[] { new Dictionary<string, object>()
{
["name"] = "[variables('storageAccountName')]",
["type"] = "Microsoft.Storage/storageAccounts",
["apiVersion"] = "2016-01-01",
["kind"] = "Storage",
["location"] = "[resourceGroup().location]",
["properties"] = new Dictionary<string, object>()
{
},
["sku"] = new Dictionary<string, object>()
{
["name"] = "[parameters('storageAccountType')]"}} },
                ["variables"] = new Dictionary<string, object>()
                {
                    ["storageAccountName"] = "[concat(uniquestring(resourceGroup().id), 'standardsa')]"
                }
            }), new Dictionary<string, ParameterValue>()
            {
                ["storageAccountType"] = new ParameterValue()
                {
                    Value = BinaryData.FromString("\"[parameters('storageAccountType')]\""),
                },
            })
            {
                ResourceGroup = "storageRG",
            };
            ArmOperation<BlueprintArtifactResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, artifactName, data);
            BlueprintArtifactResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ArtifactData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Sub-PolicyAssignmentArtifact
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_SubPolicyAssignmentArtifact()
        {
            // Generated from example definition: specification/blueprint/resource-manager/Microsoft.Blueprint/preview/2018-11-01-preview/examples/subscriptionBPDef/PolicyAssignmentArtifact_Create.json
            // this example is just showing the usage of "Artifacts_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BlueprintResource created on azure
            // for more information of creating BlueprintResource, please refer to the document of BlueprintResource
            string resourceScope = "subscriptions/00000000-0000-0000-0000-000000000000";
            string blueprintName = "simpleBlueprint";
            ResourceIdentifier blueprintResourceId = BlueprintResource.CreateResourceIdentifier(resourceScope, blueprintName);
            BlueprintResource blueprint = client.GetBlueprintResource(blueprintResourceId);

            // get the collection of this BlueprintArtifactResource
            BlueprintArtifactCollection collection = blueprint.GetBlueprintArtifacts();

            // invoke the operation
            string artifactName = "costCenterPolicy";
            ArtifactData data = new PolicyAssignmentArtifact("/providers/Microsoft.Authorization/policyDefinitions/1e30110a-5ceb-460c-a204-c1c3969c6d62", new Dictionary<string, ParameterValue>()
            {
                ["tagName"] = new ParameterValue()
                {
                    Value = BinaryData.FromString("\"costCenter\""),
                },
                ["tagValue"] = new ParameterValue()
                {
                    Value = BinaryData.FromString("\"[parameter('costCenter')]\""),
                },
            })
            {
                DisplayName = "force costCenter tag on all resources",
            };
            ArmOperation<BlueprintArtifactResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, artifactName, data);
            BlueprintArtifactResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ArtifactData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Sub-RoleAssignmentArtifact
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_SubRoleAssignmentArtifact()
        {
            // Generated from example definition: specification/blueprint/resource-manager/Microsoft.Blueprint/preview/2018-11-01-preview/examples/subscriptionBPDef/RoleAssignmentArtifact_Create.json
            // this example is just showing the usage of "Artifacts_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BlueprintResource created on azure
            // for more information of creating BlueprintResource, please refer to the document of BlueprintResource
            string resourceScope = "subscriptions/00000000-0000-0000-0000-000000000000";
            string blueprintName = "simpleBlueprint";
            ResourceIdentifier blueprintResourceId = BlueprintResource.CreateResourceIdentifier(resourceScope, blueprintName);
            BlueprintResource blueprint = client.GetBlueprintResource(blueprintResourceId);

            // get the collection of this BlueprintArtifactResource
            BlueprintArtifactCollection collection = blueprint.GetBlueprintArtifacts();

            // invoke the operation
            string artifactName = "ownerAssignment";
            ArtifactData data = new RoleAssignmentArtifact("/providers/Microsoft.Authorization/roleDefinitions/acdd72a7-3385-48ef-bd42-f606fba81ae7", BinaryData.FromString("\"[parameters('owners')]\""))
            {
                DisplayName = "enforce owners of given subscription",
            };
            ArmOperation<BlueprintArtifactResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, artifactName, data);
            BlueprintArtifactResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ArtifactData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // MG-ARMTemplateArtifact
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_MGARMTemplateArtifact()
        {
            // Generated from example definition: specification/blueprint/resource-manager/Microsoft.Blueprint/preview/2018-11-01-preview/examples/managementGroupBPDef/ARMTemplateArtifact_Get.json
            // this example is just showing the usage of "Artifacts_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BlueprintResource created on azure
            // for more information of creating BlueprintResource, please refer to the document of BlueprintResource
            string resourceScope = "providers/Microsoft.Management/managementGroups/ContosoOnlineGroup";
            string blueprintName = "simpleBlueprint";
            ResourceIdentifier blueprintResourceId = BlueprintResource.CreateResourceIdentifier(resourceScope, blueprintName);
            BlueprintResource blueprint = client.GetBlueprintResource(blueprintResourceId);

            // get the collection of this BlueprintArtifactResource
            BlueprintArtifactCollection collection = blueprint.GetBlueprintArtifacts();

            // invoke the operation
            string artifactName = "storageTemplate";
            BlueprintArtifactResource result = await collection.GetAsync(artifactName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ArtifactData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // MG-ARMTemplateArtifact
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_MGARMTemplateArtifact()
        {
            // Generated from example definition: specification/blueprint/resource-manager/Microsoft.Blueprint/preview/2018-11-01-preview/examples/managementGroupBPDef/ARMTemplateArtifact_Get.json
            // this example is just showing the usage of "Artifacts_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BlueprintResource created on azure
            // for more information of creating BlueprintResource, please refer to the document of BlueprintResource
            string resourceScope = "providers/Microsoft.Management/managementGroups/ContosoOnlineGroup";
            string blueprintName = "simpleBlueprint";
            ResourceIdentifier blueprintResourceId = BlueprintResource.CreateResourceIdentifier(resourceScope, blueprintName);
            BlueprintResource blueprint = client.GetBlueprintResource(blueprintResourceId);

            // get the collection of this BlueprintArtifactResource
            BlueprintArtifactCollection collection = blueprint.GetBlueprintArtifacts();

            // invoke the operation
            string artifactName = "storageTemplate";
            bool result = await collection.ExistsAsync(artifactName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // MG-ARMTemplateArtifact
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_MGARMTemplateArtifact()
        {
            // Generated from example definition: specification/blueprint/resource-manager/Microsoft.Blueprint/preview/2018-11-01-preview/examples/managementGroupBPDef/ARMTemplateArtifact_Get.json
            // this example is just showing the usage of "Artifacts_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BlueprintResource created on azure
            // for more information of creating BlueprintResource, please refer to the document of BlueprintResource
            string resourceScope = "providers/Microsoft.Management/managementGroups/ContosoOnlineGroup";
            string blueprintName = "simpleBlueprint";
            ResourceIdentifier blueprintResourceId = BlueprintResource.CreateResourceIdentifier(resourceScope, blueprintName);
            BlueprintResource blueprint = client.GetBlueprintResource(blueprintResourceId);

            // get the collection of this BlueprintArtifactResource
            BlueprintArtifactCollection collection = blueprint.GetBlueprintArtifacts();

            // invoke the operation
            string artifactName = "storageTemplate";
            NullableResponse<BlueprintArtifactResource> response = await collection.GetIfExistsAsync(artifactName);
            BlueprintArtifactResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                ArtifactData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // MG-PolicyAssignmentArtifact
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_MGPolicyAssignmentArtifact()
        {
            // Generated from example definition: specification/blueprint/resource-manager/Microsoft.Blueprint/preview/2018-11-01-preview/examples/managementGroupBPDef/PolicyAssignmentArtifact_Get.json
            // this example is just showing the usage of "Artifacts_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BlueprintResource created on azure
            // for more information of creating BlueprintResource, please refer to the document of BlueprintResource
            string resourceScope = "providers/Microsoft.Management/managementGroups/ContosoOnlineGroup";
            string blueprintName = "simpleBlueprint";
            ResourceIdentifier blueprintResourceId = BlueprintResource.CreateResourceIdentifier(resourceScope, blueprintName);
            BlueprintResource blueprint = client.GetBlueprintResource(blueprintResourceId);

            // get the collection of this BlueprintArtifactResource
            BlueprintArtifactCollection collection = blueprint.GetBlueprintArtifacts();

            // invoke the operation
            string artifactName = "costCenterPolicy";
            BlueprintArtifactResource result = await collection.GetAsync(artifactName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ArtifactData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // MG-PolicyAssignmentArtifact
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_MGPolicyAssignmentArtifact()
        {
            // Generated from example definition: specification/blueprint/resource-manager/Microsoft.Blueprint/preview/2018-11-01-preview/examples/managementGroupBPDef/PolicyAssignmentArtifact_Get.json
            // this example is just showing the usage of "Artifacts_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BlueprintResource created on azure
            // for more information of creating BlueprintResource, please refer to the document of BlueprintResource
            string resourceScope = "providers/Microsoft.Management/managementGroups/ContosoOnlineGroup";
            string blueprintName = "simpleBlueprint";
            ResourceIdentifier blueprintResourceId = BlueprintResource.CreateResourceIdentifier(resourceScope, blueprintName);
            BlueprintResource blueprint = client.GetBlueprintResource(blueprintResourceId);

            // get the collection of this BlueprintArtifactResource
            BlueprintArtifactCollection collection = blueprint.GetBlueprintArtifacts();

            // invoke the operation
            string artifactName = "costCenterPolicy";
            bool result = await collection.ExistsAsync(artifactName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // MG-PolicyAssignmentArtifact
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_MGPolicyAssignmentArtifact()
        {
            // Generated from example definition: specification/blueprint/resource-manager/Microsoft.Blueprint/preview/2018-11-01-preview/examples/managementGroupBPDef/PolicyAssignmentArtifact_Get.json
            // this example is just showing the usage of "Artifacts_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BlueprintResource created on azure
            // for more information of creating BlueprintResource, please refer to the document of BlueprintResource
            string resourceScope = "providers/Microsoft.Management/managementGroups/ContosoOnlineGroup";
            string blueprintName = "simpleBlueprint";
            ResourceIdentifier blueprintResourceId = BlueprintResource.CreateResourceIdentifier(resourceScope, blueprintName);
            BlueprintResource blueprint = client.GetBlueprintResource(blueprintResourceId);

            // get the collection of this BlueprintArtifactResource
            BlueprintArtifactCollection collection = blueprint.GetBlueprintArtifacts();

            // invoke the operation
            string artifactName = "costCenterPolicy";
            NullableResponse<BlueprintArtifactResource> response = await collection.GetIfExistsAsync(artifactName);
            BlueprintArtifactResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                ArtifactData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // MG-RoleAssignmentArtifact
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_MGRoleAssignmentArtifact()
        {
            // Generated from example definition: specification/blueprint/resource-manager/Microsoft.Blueprint/preview/2018-11-01-preview/examples/managementGroupBPDef/RoleAssignmentArtifact_Get.json
            // this example is just showing the usage of "Artifacts_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BlueprintResource created on azure
            // for more information of creating BlueprintResource, please refer to the document of BlueprintResource
            string resourceScope = "providers/Microsoft.Management/managementGroups/ContosoOnlineGroup";
            string blueprintName = "simpleBlueprint";
            ResourceIdentifier blueprintResourceId = BlueprintResource.CreateResourceIdentifier(resourceScope, blueprintName);
            BlueprintResource blueprint = client.GetBlueprintResource(blueprintResourceId);

            // get the collection of this BlueprintArtifactResource
            BlueprintArtifactCollection collection = blueprint.GetBlueprintArtifacts();

            // invoke the operation
            string artifactName = "ownerAssignment";
            BlueprintArtifactResource result = await collection.GetAsync(artifactName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ArtifactData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // MG-RoleAssignmentArtifact
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_MGRoleAssignmentArtifact()
        {
            // Generated from example definition: specification/blueprint/resource-manager/Microsoft.Blueprint/preview/2018-11-01-preview/examples/managementGroupBPDef/RoleAssignmentArtifact_Get.json
            // this example is just showing the usage of "Artifacts_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BlueprintResource created on azure
            // for more information of creating BlueprintResource, please refer to the document of BlueprintResource
            string resourceScope = "providers/Microsoft.Management/managementGroups/ContosoOnlineGroup";
            string blueprintName = "simpleBlueprint";
            ResourceIdentifier blueprintResourceId = BlueprintResource.CreateResourceIdentifier(resourceScope, blueprintName);
            BlueprintResource blueprint = client.GetBlueprintResource(blueprintResourceId);

            // get the collection of this BlueprintArtifactResource
            BlueprintArtifactCollection collection = blueprint.GetBlueprintArtifacts();

            // invoke the operation
            string artifactName = "ownerAssignment";
            bool result = await collection.ExistsAsync(artifactName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // MG-RoleAssignmentArtifact
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_MGRoleAssignmentArtifact()
        {
            // Generated from example definition: specification/blueprint/resource-manager/Microsoft.Blueprint/preview/2018-11-01-preview/examples/managementGroupBPDef/RoleAssignmentArtifact_Get.json
            // this example is just showing the usage of "Artifacts_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BlueprintResource created on azure
            // for more information of creating BlueprintResource, please refer to the document of BlueprintResource
            string resourceScope = "providers/Microsoft.Management/managementGroups/ContosoOnlineGroup";
            string blueprintName = "simpleBlueprint";
            ResourceIdentifier blueprintResourceId = BlueprintResource.CreateResourceIdentifier(resourceScope, blueprintName);
            BlueprintResource blueprint = client.GetBlueprintResource(blueprintResourceId);

            // get the collection of this BlueprintArtifactResource
            BlueprintArtifactCollection collection = blueprint.GetBlueprintArtifacts();

            // invoke the operation
            string artifactName = "ownerAssignment";
            NullableResponse<BlueprintArtifactResource> response = await collection.GetIfExistsAsync(artifactName);
            BlueprintArtifactResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                ArtifactData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // Sub-ARMTemplateArtifact
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_SubARMTemplateArtifact()
        {
            // Generated from example definition: specification/blueprint/resource-manager/Microsoft.Blueprint/preview/2018-11-01-preview/examples/subscriptionBPDef/ARMTemplateArtifact_Get.json
            // this example is just showing the usage of "Artifacts_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BlueprintResource created on azure
            // for more information of creating BlueprintResource, please refer to the document of BlueprintResource
            string resourceScope = "subscriptions/00000000-0000-0000-0000-000000000000";
            string blueprintName = "simpleBlueprint";
            ResourceIdentifier blueprintResourceId = BlueprintResource.CreateResourceIdentifier(resourceScope, blueprintName);
            BlueprintResource blueprint = client.GetBlueprintResource(blueprintResourceId);

            // get the collection of this BlueprintArtifactResource
            BlueprintArtifactCollection collection = blueprint.GetBlueprintArtifacts();

            // invoke the operation
            string artifactName = "storageTemplate";
            BlueprintArtifactResource result = await collection.GetAsync(artifactName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ArtifactData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Sub-ARMTemplateArtifact
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_SubARMTemplateArtifact()
        {
            // Generated from example definition: specification/blueprint/resource-manager/Microsoft.Blueprint/preview/2018-11-01-preview/examples/subscriptionBPDef/ARMTemplateArtifact_Get.json
            // this example is just showing the usage of "Artifacts_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BlueprintResource created on azure
            // for more information of creating BlueprintResource, please refer to the document of BlueprintResource
            string resourceScope = "subscriptions/00000000-0000-0000-0000-000000000000";
            string blueprintName = "simpleBlueprint";
            ResourceIdentifier blueprintResourceId = BlueprintResource.CreateResourceIdentifier(resourceScope, blueprintName);
            BlueprintResource blueprint = client.GetBlueprintResource(blueprintResourceId);

            // get the collection of this BlueprintArtifactResource
            BlueprintArtifactCollection collection = blueprint.GetBlueprintArtifacts();

            // invoke the operation
            string artifactName = "storageTemplate";
            bool result = await collection.ExistsAsync(artifactName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Sub-ARMTemplateArtifact
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_SubARMTemplateArtifact()
        {
            // Generated from example definition: specification/blueprint/resource-manager/Microsoft.Blueprint/preview/2018-11-01-preview/examples/subscriptionBPDef/ARMTemplateArtifact_Get.json
            // this example is just showing the usage of "Artifacts_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BlueprintResource created on azure
            // for more information of creating BlueprintResource, please refer to the document of BlueprintResource
            string resourceScope = "subscriptions/00000000-0000-0000-0000-000000000000";
            string blueprintName = "simpleBlueprint";
            ResourceIdentifier blueprintResourceId = BlueprintResource.CreateResourceIdentifier(resourceScope, blueprintName);
            BlueprintResource blueprint = client.GetBlueprintResource(blueprintResourceId);

            // get the collection of this BlueprintArtifactResource
            BlueprintArtifactCollection collection = blueprint.GetBlueprintArtifacts();

            // invoke the operation
            string artifactName = "storageTemplate";
            NullableResponse<BlueprintArtifactResource> response = await collection.GetIfExistsAsync(artifactName);
            BlueprintArtifactResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                ArtifactData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // Sub-PolicyAssignmentArtifact
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_SubPolicyAssignmentArtifact()
        {
            // Generated from example definition: specification/blueprint/resource-manager/Microsoft.Blueprint/preview/2018-11-01-preview/examples/subscriptionBPDef/PolicyAssignmentArtifact_Get.json
            // this example is just showing the usage of "Artifacts_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BlueprintResource created on azure
            // for more information of creating BlueprintResource, please refer to the document of BlueprintResource
            string resourceScope = "subscriptions/00000000-0000-0000-0000-000000000000";
            string blueprintName = "simpleBlueprint";
            ResourceIdentifier blueprintResourceId = BlueprintResource.CreateResourceIdentifier(resourceScope, blueprintName);
            BlueprintResource blueprint = client.GetBlueprintResource(blueprintResourceId);

            // get the collection of this BlueprintArtifactResource
            BlueprintArtifactCollection collection = blueprint.GetBlueprintArtifacts();

            // invoke the operation
            string artifactName = "costCenterPolicy";
            BlueprintArtifactResource result = await collection.GetAsync(artifactName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ArtifactData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Sub-PolicyAssignmentArtifact
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_SubPolicyAssignmentArtifact()
        {
            // Generated from example definition: specification/blueprint/resource-manager/Microsoft.Blueprint/preview/2018-11-01-preview/examples/subscriptionBPDef/PolicyAssignmentArtifact_Get.json
            // this example is just showing the usage of "Artifacts_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BlueprintResource created on azure
            // for more information of creating BlueprintResource, please refer to the document of BlueprintResource
            string resourceScope = "subscriptions/00000000-0000-0000-0000-000000000000";
            string blueprintName = "simpleBlueprint";
            ResourceIdentifier blueprintResourceId = BlueprintResource.CreateResourceIdentifier(resourceScope, blueprintName);
            BlueprintResource blueprint = client.GetBlueprintResource(blueprintResourceId);

            // get the collection of this BlueprintArtifactResource
            BlueprintArtifactCollection collection = blueprint.GetBlueprintArtifacts();

            // invoke the operation
            string artifactName = "costCenterPolicy";
            bool result = await collection.ExistsAsync(artifactName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Sub-PolicyAssignmentArtifact
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_SubPolicyAssignmentArtifact()
        {
            // Generated from example definition: specification/blueprint/resource-manager/Microsoft.Blueprint/preview/2018-11-01-preview/examples/subscriptionBPDef/PolicyAssignmentArtifact_Get.json
            // this example is just showing the usage of "Artifacts_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BlueprintResource created on azure
            // for more information of creating BlueprintResource, please refer to the document of BlueprintResource
            string resourceScope = "subscriptions/00000000-0000-0000-0000-000000000000";
            string blueprintName = "simpleBlueprint";
            ResourceIdentifier blueprintResourceId = BlueprintResource.CreateResourceIdentifier(resourceScope, blueprintName);
            BlueprintResource blueprint = client.GetBlueprintResource(blueprintResourceId);

            // get the collection of this BlueprintArtifactResource
            BlueprintArtifactCollection collection = blueprint.GetBlueprintArtifacts();

            // invoke the operation
            string artifactName = "costCenterPolicy";
            NullableResponse<BlueprintArtifactResource> response = await collection.GetIfExistsAsync(artifactName);
            BlueprintArtifactResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                ArtifactData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // Sub-RoleAssignmentArtifact
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_SubRoleAssignmentArtifact()
        {
            // Generated from example definition: specification/blueprint/resource-manager/Microsoft.Blueprint/preview/2018-11-01-preview/examples/subscriptionBPDef/RoleAssignmentArtifact_Get.json
            // this example is just showing the usage of "Artifacts_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BlueprintResource created on azure
            // for more information of creating BlueprintResource, please refer to the document of BlueprintResource
            string resourceScope = "subscriptions/00000000-0000-0000-0000-000000000000";
            string blueprintName = "simpleBlueprint";
            ResourceIdentifier blueprintResourceId = BlueprintResource.CreateResourceIdentifier(resourceScope, blueprintName);
            BlueprintResource blueprint = client.GetBlueprintResource(blueprintResourceId);

            // get the collection of this BlueprintArtifactResource
            BlueprintArtifactCollection collection = blueprint.GetBlueprintArtifacts();

            // invoke the operation
            string artifactName = "ownerAssignment";
            BlueprintArtifactResource result = await collection.GetAsync(artifactName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ArtifactData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Sub-RoleAssignmentArtifact
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_SubRoleAssignmentArtifact()
        {
            // Generated from example definition: specification/blueprint/resource-manager/Microsoft.Blueprint/preview/2018-11-01-preview/examples/subscriptionBPDef/RoleAssignmentArtifact_Get.json
            // this example is just showing the usage of "Artifacts_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BlueprintResource created on azure
            // for more information of creating BlueprintResource, please refer to the document of BlueprintResource
            string resourceScope = "subscriptions/00000000-0000-0000-0000-000000000000";
            string blueprintName = "simpleBlueprint";
            ResourceIdentifier blueprintResourceId = BlueprintResource.CreateResourceIdentifier(resourceScope, blueprintName);
            BlueprintResource blueprint = client.GetBlueprintResource(blueprintResourceId);

            // get the collection of this BlueprintArtifactResource
            BlueprintArtifactCollection collection = blueprint.GetBlueprintArtifacts();

            // invoke the operation
            string artifactName = "ownerAssignment";
            bool result = await collection.ExistsAsync(artifactName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Sub-RoleAssignmentArtifact
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_SubRoleAssignmentArtifact()
        {
            // Generated from example definition: specification/blueprint/resource-manager/Microsoft.Blueprint/preview/2018-11-01-preview/examples/subscriptionBPDef/RoleAssignmentArtifact_Get.json
            // this example is just showing the usage of "Artifacts_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BlueprintResource created on azure
            // for more information of creating BlueprintResource, please refer to the document of BlueprintResource
            string resourceScope = "subscriptions/00000000-0000-0000-0000-000000000000";
            string blueprintName = "simpleBlueprint";
            ResourceIdentifier blueprintResourceId = BlueprintResource.CreateResourceIdentifier(resourceScope, blueprintName);
            BlueprintResource blueprint = client.GetBlueprintResource(blueprintResourceId);

            // get the collection of this BlueprintArtifactResource
            BlueprintArtifactCollection collection = blueprint.GetBlueprintArtifacts();

            // invoke the operation
            string artifactName = "ownerAssignment";
            NullableResponse<BlueprintArtifactResource> response = await collection.GetIfExistsAsync(artifactName);
            BlueprintArtifactResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                ArtifactData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // MG-ArtifactList
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_MGArtifactList()
        {
            // Generated from example definition: specification/blueprint/resource-manager/Microsoft.Blueprint/preview/2018-11-01-preview/examples/managementGroupBPDef/Artifact_List.json
            // this example is just showing the usage of "Artifacts_List" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BlueprintResource created on azure
            // for more information of creating BlueprintResource, please refer to the document of BlueprintResource
            string resourceScope = "providers/Microsoft.Management/managementGroups/ContosoOnlineGroup";
            string blueprintName = "simpleBlueprint";
            ResourceIdentifier blueprintResourceId = BlueprintResource.CreateResourceIdentifier(resourceScope, blueprintName);
            BlueprintResource blueprint = client.GetBlueprintResource(blueprintResourceId);

            // get the collection of this BlueprintArtifactResource
            BlueprintArtifactCollection collection = blueprint.GetBlueprintArtifacts();

            // invoke the operation and iterate over the result
            await foreach (BlueprintArtifactResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                ArtifactData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // Sub-ArtifactList
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_SubArtifactList()
        {
            // Generated from example definition: specification/blueprint/resource-manager/Microsoft.Blueprint/preview/2018-11-01-preview/examples/subscriptionBPDef/Artifact_List.json
            // this example is just showing the usage of "Artifacts_List" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this BlueprintResource created on azure
            // for more information of creating BlueprintResource, please refer to the document of BlueprintResource
            string resourceScope = "subscriptions/00000000-0000-0000-0000-000000000000";
            string blueprintName = "simpleBlueprint";
            ResourceIdentifier blueprintResourceId = BlueprintResource.CreateResourceIdentifier(resourceScope, blueprintName);
            BlueprintResource blueprint = client.GetBlueprintResource(blueprintResourceId);

            // get the collection of this BlueprintArtifactResource
            BlueprintArtifactCollection collection = blueprint.GetBlueprintArtifacts();

            // invoke the operation and iterate over the result
            await foreach (BlueprintArtifactResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                ArtifactData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }
    }
}
