// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.BillingBenefits.Models;

namespace Azure.ResourceManager.BillingBenefits
{
    internal partial class SavingsPlanRestOperations
    {
        private readonly TelemetryDetails _userAgent;
        private readonly HttpPipeline _pipeline;
        private readonly Uri _endpoint;
        private readonly string _apiVersion;

        /// <summary> Initializes a new instance of SavingsPlanRestOperations. </summary>
        /// <param name="pipeline"> The HTTP pipeline for sending and receiving REST requests and responses. </param>
        /// <param name="applicationId"> The application id to use for user agent. </param>
        /// <param name="endpoint"> server parameter. </param>
        /// <param name="apiVersion"> Api Version. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="pipeline"/> or <paramref name="apiVersion"/> is null. </exception>
        public SavingsPlanRestOperations(HttpPipeline pipeline, string applicationId, Uri endpoint = null, string apiVersion = default)
        {
            _pipeline = pipeline ?? throw new ArgumentNullException(nameof(pipeline));
            _endpoint = endpoint ?? new Uri("https://management.azure.com");
            _apiVersion = apiVersion ?? "2022-11-01";
            _userAgent = new TelemetryDetails(GetType().Assembly, applicationId);
        }

        internal RequestUriBuilder CreateListRequestUri(string savingsPlanOrderId)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/providers/Microsoft.BillingBenefits/savingsPlanOrders/", false);
            uri.AppendPath(savingsPlanOrderId, true);
            uri.AppendPath("/savingsPlans", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateListRequest(string savingsPlanOrderId)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/providers/Microsoft.BillingBenefits/savingsPlanOrders/", false);
            uri.AppendPath(savingsPlanOrderId, true);
            uri.AppendPath("/savingsPlans", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> List savings plans in an order. </summary>
        /// <param name="savingsPlanOrderId"> Order ID of the savings plan. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="savingsPlanOrderId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="savingsPlanOrderId"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<SavingsPlanModelList>> ListAsync(string savingsPlanOrderId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(savingsPlanOrderId, nameof(savingsPlanOrderId));

            using var message = CreateListRequest(savingsPlanOrderId);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        SavingsPlanModelList value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = SavingsPlanModelList.DeserializeSavingsPlanModelList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> List savings plans in an order. </summary>
        /// <param name="savingsPlanOrderId"> Order ID of the savings plan. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="savingsPlanOrderId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="savingsPlanOrderId"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<SavingsPlanModelList> List(string savingsPlanOrderId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(savingsPlanOrderId, nameof(savingsPlanOrderId));

            using var message = CreateListRequest(savingsPlanOrderId);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        SavingsPlanModelList value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = SavingsPlanModelList.DeserializeSavingsPlanModelList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateListAllRequestUri(string filter, string orderBy, string refreshSummary, float? skipToken, string selectedState, float? take)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/providers/Microsoft.BillingBenefits/savingsPlans", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (filter != null)
            {
                uri.AppendQuery("$filter", filter, true);
            }
            if (orderBy != null)
            {
                uri.AppendQuery("$orderby", orderBy, true);
            }
            if (refreshSummary != null)
            {
                uri.AppendQuery("refreshSummary", refreshSummary, true);
            }
            if (skipToken != null)
            {
                uri.AppendQuery("$skiptoken", skipToken.Value, true);
            }
            if (selectedState != null)
            {
                uri.AppendQuery("selectedState", selectedState, true);
            }
            if (take != null)
            {
                uri.AppendQuery("take", take.Value, true);
            }
            return uri;
        }

        internal HttpMessage CreateListAllRequest(string filter, string orderBy, string refreshSummary, float? skipToken, string selectedState, float? take)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/providers/Microsoft.BillingBenefits/savingsPlans", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (filter != null)
            {
                uri.AppendQuery("$filter", filter, true);
            }
            if (orderBy != null)
            {
                uri.AppendQuery("$orderby", orderBy, true);
            }
            if (refreshSummary != null)
            {
                uri.AppendQuery("refreshSummary", refreshSummary, true);
            }
            if (skipToken != null)
            {
                uri.AppendQuery("$skiptoken", skipToken.Value, true);
            }
            if (selectedState != null)
            {
                uri.AppendQuery("selectedState", selectedState, true);
            }
            if (take != null)
            {
                uri.AppendQuery("take", take.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> List savings plans. </summary>
        /// <param name="filter"> May be used to filter by reservation properties. The filter supports 'eq', 'or', and 'and'. It does not currently support 'ne', 'gt', 'le', 'ge', or 'not'. Reservation properties include sku/name, properties/{appliedScopeType, archived, displayName, displayProvisioningState, effectiveDateTime, expiryDate, provisioningState, quantity, renew, reservedResourceType, term, userFriendlyAppliedScopeType, userFriendlyRenewState}. </param>
        /// <param name="orderBy"> May be used to sort order by reservation properties. </param>
        /// <param name="refreshSummary"> To indicate whether to refresh the roll up counts of the savings plans group by provisioning states. </param>
        /// <param name="skipToken"> The number of savings plans to skip from the list before returning results. </param>
        /// <param name="selectedState"> The selected provisioning state. </param>
        /// <param name="take"> To number of savings plans to return. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public async Task<Response<SavingsPlanModelListResult>> ListAllAsync(string filter = null, string orderBy = null, string refreshSummary = null, float? skipToken = null, string selectedState = null, float? take = null, CancellationToken cancellationToken = default)
        {
            using var message = CreateListAllRequest(filter, orderBy, refreshSummary, skipToken, selectedState, take);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        SavingsPlanModelListResult value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = SavingsPlanModelListResult.DeserializeSavingsPlanModelListResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> List savings plans. </summary>
        /// <param name="filter"> May be used to filter by reservation properties. The filter supports 'eq', 'or', and 'and'. It does not currently support 'ne', 'gt', 'le', 'ge', or 'not'. Reservation properties include sku/name, properties/{appliedScopeType, archived, displayName, displayProvisioningState, effectiveDateTime, expiryDate, provisioningState, quantity, renew, reservedResourceType, term, userFriendlyAppliedScopeType, userFriendlyRenewState}. </param>
        /// <param name="orderBy"> May be used to sort order by reservation properties. </param>
        /// <param name="refreshSummary"> To indicate whether to refresh the roll up counts of the savings plans group by provisioning states. </param>
        /// <param name="skipToken"> The number of savings plans to skip from the list before returning results. </param>
        /// <param name="selectedState"> The selected provisioning state. </param>
        /// <param name="take"> To number of savings plans to return. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public Response<SavingsPlanModelListResult> ListAll(string filter = null, string orderBy = null, string refreshSummary = null, float? skipToken = null, string selectedState = null, float? take = null, CancellationToken cancellationToken = default)
        {
            using var message = CreateListAllRequest(filter, orderBy, refreshSummary, skipToken, selectedState, take);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        SavingsPlanModelListResult value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = SavingsPlanModelListResult.DeserializeSavingsPlanModelListResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateGetRequestUri(string savingsPlanOrderId, string savingsPlanId, string expand)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/providers/Microsoft.BillingBenefits/savingsPlanOrders/", false);
            uri.AppendPath(savingsPlanOrderId, true);
            uri.AppendPath("/savingsPlans/", false);
            uri.AppendPath(savingsPlanId, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (expand != null)
            {
                uri.AppendQuery("$expand", expand, true);
            }
            return uri;
        }

        internal HttpMessage CreateGetRequest(string savingsPlanOrderId, string savingsPlanId, string expand)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/providers/Microsoft.BillingBenefits/savingsPlanOrders/", false);
            uri.AppendPath(savingsPlanOrderId, true);
            uri.AppendPath("/savingsPlans/", false);
            uri.AppendPath(savingsPlanId, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (expand != null)
            {
                uri.AppendQuery("$expand", expand, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Get savings plan. </summary>
        /// <param name="savingsPlanOrderId"> Order ID of the savings plan. </param>
        /// <param name="savingsPlanId"> ID of the savings plan. </param>
        /// <param name="expand"> May be used to expand the detail information of some properties. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="savingsPlanOrderId"/> or <paramref name="savingsPlanId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="savingsPlanOrderId"/> or <paramref name="savingsPlanId"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<BillingBenefitsSavingsPlanData>> GetAsync(string savingsPlanOrderId, string savingsPlanId, string expand = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(savingsPlanOrderId, nameof(savingsPlanOrderId));
            Argument.AssertNotNullOrEmpty(savingsPlanId, nameof(savingsPlanId));

            using var message = CreateGetRequest(savingsPlanOrderId, savingsPlanId, expand);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        BillingBenefitsSavingsPlanData value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = BillingBenefitsSavingsPlanData.DeserializeBillingBenefitsSavingsPlanData(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                case 404:
                    return Response.FromValue((BillingBenefitsSavingsPlanData)null, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Get savings plan. </summary>
        /// <param name="savingsPlanOrderId"> Order ID of the savings plan. </param>
        /// <param name="savingsPlanId"> ID of the savings plan. </param>
        /// <param name="expand"> May be used to expand the detail information of some properties. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="savingsPlanOrderId"/> or <paramref name="savingsPlanId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="savingsPlanOrderId"/> or <paramref name="savingsPlanId"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<BillingBenefitsSavingsPlanData> Get(string savingsPlanOrderId, string savingsPlanId, string expand = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(savingsPlanOrderId, nameof(savingsPlanOrderId));
            Argument.AssertNotNullOrEmpty(savingsPlanId, nameof(savingsPlanId));

            using var message = CreateGetRequest(savingsPlanOrderId, savingsPlanId, expand);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        BillingBenefitsSavingsPlanData value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = BillingBenefitsSavingsPlanData.DeserializeBillingBenefitsSavingsPlanData(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                case 404:
                    return Response.FromValue((BillingBenefitsSavingsPlanData)null, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateUpdateRequestUri(string savingsPlanOrderId, string savingsPlanId, BillingBenefitsSavingsPlanPatch patch)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/providers/Microsoft.BillingBenefits/savingsPlanOrders/", false);
            uri.AppendPath(savingsPlanOrderId, true);
            uri.AppendPath("/savingsPlans/", false);
            uri.AppendPath(savingsPlanId, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateUpdateRequest(string savingsPlanOrderId, string savingsPlanId, BillingBenefitsSavingsPlanPatch patch)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Patch;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/providers/Microsoft.BillingBenefits/savingsPlanOrders/", false);
            uri.AppendPath(savingsPlanOrderId, true);
            uri.AppendPath("/savingsPlans/", false);
            uri.AppendPath(savingsPlanId, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(patch, ModelSerializationExtensions.WireOptions);
            request.Content = content;
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Update savings plan. </summary>
        /// <param name="savingsPlanOrderId"> Order ID of the savings plan. </param>
        /// <param name="savingsPlanId"> ID of the savings plan. </param>
        /// <param name="patch"> Request body for patching a savings plan order alias. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="savingsPlanOrderId"/>, <paramref name="savingsPlanId"/> or <paramref name="patch"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="savingsPlanOrderId"/> or <paramref name="savingsPlanId"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<BillingBenefitsSavingsPlanData>> UpdateAsync(string savingsPlanOrderId, string savingsPlanId, BillingBenefitsSavingsPlanPatch patch, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(savingsPlanOrderId, nameof(savingsPlanOrderId));
            Argument.AssertNotNullOrEmpty(savingsPlanId, nameof(savingsPlanId));
            Argument.AssertNotNull(patch, nameof(patch));

            using var message = CreateUpdateRequest(savingsPlanOrderId, savingsPlanId, patch);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        BillingBenefitsSavingsPlanData value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = BillingBenefitsSavingsPlanData.DeserializeBillingBenefitsSavingsPlanData(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                case 202:
                    return Response.FromValue((BillingBenefitsSavingsPlanData)null, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Update savings plan. </summary>
        /// <param name="savingsPlanOrderId"> Order ID of the savings plan. </param>
        /// <param name="savingsPlanId"> ID of the savings plan. </param>
        /// <param name="patch"> Request body for patching a savings plan order alias. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="savingsPlanOrderId"/>, <paramref name="savingsPlanId"/> or <paramref name="patch"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="savingsPlanOrderId"/> or <paramref name="savingsPlanId"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<BillingBenefitsSavingsPlanData> Update(string savingsPlanOrderId, string savingsPlanId, BillingBenefitsSavingsPlanPatch patch, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(savingsPlanOrderId, nameof(savingsPlanOrderId));
            Argument.AssertNotNullOrEmpty(savingsPlanId, nameof(savingsPlanId));
            Argument.AssertNotNull(patch, nameof(patch));

            using var message = CreateUpdateRequest(savingsPlanOrderId, savingsPlanId, patch);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        BillingBenefitsSavingsPlanData value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = BillingBenefitsSavingsPlanData.DeserializeBillingBenefitsSavingsPlanData(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                case 202:
                    return Response.FromValue((BillingBenefitsSavingsPlanData)null, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateValidateUpdateRequestUri(string savingsPlanOrderId, string savingsPlanId, SavingsPlanUpdateValidateContent content)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/providers/Microsoft.BillingBenefits/savingsPlanOrders/", false);
            uri.AppendPath(savingsPlanOrderId, true);
            uri.AppendPath("/savingsPlans/", false);
            uri.AppendPath(savingsPlanId, true);
            uri.AppendPath("/validate", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateValidateUpdateRequest(string savingsPlanOrderId, string savingsPlanId, SavingsPlanUpdateValidateContent content)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Post;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/providers/Microsoft.BillingBenefits/savingsPlanOrders/", false);
            uri.AppendPath(savingsPlanOrderId, true);
            uri.AppendPath("/savingsPlans/", false);
            uri.AppendPath(savingsPlanId, true);
            uri.AppendPath("/validate", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content0 = new Utf8JsonRequestContent();
            content0.JsonWriter.WriteObjectValue(content, ModelSerializationExtensions.WireOptions);
            request.Content = content0;
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Validate savings plan patch. </summary>
        /// <param name="savingsPlanOrderId"> Order ID of the savings plan. </param>
        /// <param name="savingsPlanId"> ID of the savings plan. </param>
        /// <param name="content"> Request body for validating a savings plan patch request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="savingsPlanOrderId"/>, <paramref name="savingsPlanId"/> or <paramref name="content"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="savingsPlanOrderId"/> or <paramref name="savingsPlanId"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<SavingsPlanValidateResponse>> ValidateUpdateAsync(string savingsPlanOrderId, string savingsPlanId, SavingsPlanUpdateValidateContent content, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(savingsPlanOrderId, nameof(savingsPlanOrderId));
            Argument.AssertNotNullOrEmpty(savingsPlanId, nameof(savingsPlanId));
            Argument.AssertNotNull(content, nameof(content));

            using var message = CreateValidateUpdateRequest(savingsPlanOrderId, savingsPlanId, content);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        SavingsPlanValidateResponse value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = SavingsPlanValidateResponse.DeserializeSavingsPlanValidateResponse(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Validate savings plan patch. </summary>
        /// <param name="savingsPlanOrderId"> Order ID of the savings plan. </param>
        /// <param name="savingsPlanId"> ID of the savings plan. </param>
        /// <param name="content"> Request body for validating a savings plan patch request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="savingsPlanOrderId"/>, <paramref name="savingsPlanId"/> or <paramref name="content"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="savingsPlanOrderId"/> or <paramref name="savingsPlanId"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<SavingsPlanValidateResponse> ValidateUpdate(string savingsPlanOrderId, string savingsPlanId, SavingsPlanUpdateValidateContent content, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(savingsPlanOrderId, nameof(savingsPlanOrderId));
            Argument.AssertNotNullOrEmpty(savingsPlanId, nameof(savingsPlanId));
            Argument.AssertNotNull(content, nameof(content));

            using var message = CreateValidateUpdateRequest(savingsPlanOrderId, savingsPlanId, content);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        SavingsPlanValidateResponse value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = SavingsPlanValidateResponse.DeserializeSavingsPlanValidateResponse(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateListNextPageRequestUri(string nextLink, string savingsPlanOrderId)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRawNextLink(nextLink, false);
            return uri;
        }

        internal HttpMessage CreateListNextPageRequest(string nextLink, string savingsPlanOrderId)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRawNextLink(nextLink, false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> List savings plans in an order. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="savingsPlanOrderId"> Order ID of the savings plan. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> or <paramref name="savingsPlanOrderId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="savingsPlanOrderId"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<SavingsPlanModelList>> ListNextPageAsync(string nextLink, string savingsPlanOrderId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(nextLink, nameof(nextLink));
            Argument.AssertNotNullOrEmpty(savingsPlanOrderId, nameof(savingsPlanOrderId));

            using var message = CreateListNextPageRequest(nextLink, savingsPlanOrderId);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        SavingsPlanModelList value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = SavingsPlanModelList.DeserializeSavingsPlanModelList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> List savings plans in an order. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="savingsPlanOrderId"> Order ID of the savings plan. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> or <paramref name="savingsPlanOrderId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="savingsPlanOrderId"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<SavingsPlanModelList> ListNextPage(string nextLink, string savingsPlanOrderId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(nextLink, nameof(nextLink));
            Argument.AssertNotNullOrEmpty(savingsPlanOrderId, nameof(savingsPlanOrderId));

            using var message = CreateListNextPageRequest(nextLink, savingsPlanOrderId);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        SavingsPlanModelList value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = SavingsPlanModelList.DeserializeSavingsPlanModelList(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateListAllNextPageRequestUri(string nextLink, string filter, string orderBy, string refreshSummary, float? skipToken, string selectedState, float? take)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRawNextLink(nextLink, false);
            return uri;
        }

        internal HttpMessage CreateListAllNextPageRequest(string nextLink, string filter, string orderBy, string refreshSummary, float? skipToken, string selectedState, float? take)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRawNextLink(nextLink, false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> List savings plans. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="filter"> May be used to filter by reservation properties. The filter supports 'eq', 'or', and 'and'. It does not currently support 'ne', 'gt', 'le', 'ge', or 'not'. Reservation properties include sku/name, properties/{appliedScopeType, archived, displayName, displayProvisioningState, effectiveDateTime, expiryDate, provisioningState, quantity, renew, reservedResourceType, term, userFriendlyAppliedScopeType, userFriendlyRenewState}. </param>
        /// <param name="orderBy"> May be used to sort order by reservation properties. </param>
        /// <param name="refreshSummary"> To indicate whether to refresh the roll up counts of the savings plans group by provisioning states. </param>
        /// <param name="skipToken"> The number of savings plans to skip from the list before returning results. </param>
        /// <param name="selectedState"> The selected provisioning state. </param>
        /// <param name="take"> To number of savings plans to return. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> is null. </exception>
        public async Task<Response<SavingsPlanModelListResult>> ListAllNextPageAsync(string nextLink, string filter = null, string orderBy = null, string refreshSummary = null, float? skipToken = null, string selectedState = null, float? take = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(nextLink, nameof(nextLink));

            using var message = CreateListAllNextPageRequest(nextLink, filter, orderBy, refreshSummary, skipToken, selectedState, take);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        SavingsPlanModelListResult value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = SavingsPlanModelListResult.DeserializeSavingsPlanModelListResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> List savings plans. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="filter"> May be used to filter by reservation properties. The filter supports 'eq', 'or', and 'and'. It does not currently support 'ne', 'gt', 'le', 'ge', or 'not'. Reservation properties include sku/name, properties/{appliedScopeType, archived, displayName, displayProvisioningState, effectiveDateTime, expiryDate, provisioningState, quantity, renew, reservedResourceType, term, userFriendlyAppliedScopeType, userFriendlyRenewState}. </param>
        /// <param name="orderBy"> May be used to sort order by reservation properties. </param>
        /// <param name="refreshSummary"> To indicate whether to refresh the roll up counts of the savings plans group by provisioning states. </param>
        /// <param name="skipToken"> The number of savings plans to skip from the list before returning results. </param>
        /// <param name="selectedState"> The selected provisioning state. </param>
        /// <param name="take"> To number of savings plans to return. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/> is null. </exception>
        public Response<SavingsPlanModelListResult> ListAllNextPage(string nextLink, string filter = null, string orderBy = null, string refreshSummary = null, float? skipToken = null, string selectedState = null, float? take = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(nextLink, nameof(nextLink));

            using var message = CreateListAllNextPageRequest(nextLink, filter, orderBy, refreshSummary, skipToken, selectedState, take);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        SavingsPlanModelListResult value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = SavingsPlanModelListResult.DeserializeSavingsPlanModelListResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateValidateUpdateNextPageRequestUri(string nextLink, string savingsPlanOrderId, string savingsPlanId, SavingsPlanUpdateValidateContent content)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRawNextLink(nextLink, false);
            return uri;
        }

        internal HttpMessage CreateValidateUpdateNextPageRequest(string nextLink, string savingsPlanOrderId, string savingsPlanId, SavingsPlanUpdateValidateContent content)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRawNextLink(nextLink, false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Validate savings plan patch. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="savingsPlanOrderId"> Order ID of the savings plan. </param>
        /// <param name="savingsPlanId"> ID of the savings plan. </param>
        /// <param name="content"> Request body for validating a savings plan patch request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/>, <paramref name="savingsPlanOrderId"/>, <paramref name="savingsPlanId"/> or <paramref name="content"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="savingsPlanOrderId"/> or <paramref name="savingsPlanId"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<SavingsPlanValidateResponse>> ValidateUpdateNextPageAsync(string nextLink, string savingsPlanOrderId, string savingsPlanId, SavingsPlanUpdateValidateContent content, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(nextLink, nameof(nextLink));
            Argument.AssertNotNullOrEmpty(savingsPlanOrderId, nameof(savingsPlanOrderId));
            Argument.AssertNotNullOrEmpty(savingsPlanId, nameof(savingsPlanId));
            Argument.AssertNotNull(content, nameof(content));

            using var message = CreateValidateUpdateNextPageRequest(nextLink, savingsPlanOrderId, savingsPlanId, content);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        SavingsPlanValidateResponse value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = SavingsPlanValidateResponse.DeserializeSavingsPlanValidateResponse(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Validate savings plan patch. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="savingsPlanOrderId"> Order ID of the savings plan. </param>
        /// <param name="savingsPlanId"> ID of the savings plan. </param>
        /// <param name="content"> Request body for validating a savings plan patch request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/>, <paramref name="savingsPlanOrderId"/>, <paramref name="savingsPlanId"/> or <paramref name="content"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="savingsPlanOrderId"/> or <paramref name="savingsPlanId"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<SavingsPlanValidateResponse> ValidateUpdateNextPage(string nextLink, string savingsPlanOrderId, string savingsPlanId, SavingsPlanUpdateValidateContent content, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(nextLink, nameof(nextLink));
            Argument.AssertNotNullOrEmpty(savingsPlanOrderId, nameof(savingsPlanOrderId));
            Argument.AssertNotNullOrEmpty(savingsPlanId, nameof(savingsPlanId));
            Argument.AssertNotNull(content, nameof(content));

            using var message = CreateValidateUpdateNextPageRequest(nextLink, savingsPlanOrderId, savingsPlanId, content);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        SavingsPlanValidateResponse value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = SavingsPlanValidateResponse.DeserializeSavingsPlanValidateResponse(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }
    }
}
