// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.BillingBenefits.Models
{
    /// <summary> Benefit scope response property. </summary>
    public partial class SavingsPlanValidateResult
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SavingsPlanValidateResult"/>. </summary>
        internal SavingsPlanValidateResult()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SavingsPlanValidateResult"/>. </summary>
        /// <param name="isValid"> Indicates if the provided input was valid. </param>
        /// <param name="reasonCode"> Failure reason code if the provided input was invalid. </param>
        /// <param name="reason"> Failure reason if the provided input was invalid. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SavingsPlanValidateResult(bool? isValid, string reasonCode, string reason, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            IsValid = isValid;
            ReasonCode = reasonCode;
            Reason = reason;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Indicates if the provided input was valid. </summary>
        public bool? IsValid { get; }
        /// <summary> Failure reason code if the provided input was invalid. </summary>
        public string ReasonCode { get; }
        /// <summary> Failure reason if the provided input was invalid. </summary>
        public string Reason { get; }
    }
}
