// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.BillingBenefits.Models
{
    /// <summary> The SavingsPlanModelListResult. </summary>
    internal partial class SavingsPlanModelListResult
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SavingsPlanModelListResult"/>. </summary>
        internal SavingsPlanModelListResult()
        {
            Value = new ChangeTrackingList<BillingBenefitsSavingsPlanData>();
            AdditionalProperties = new ChangeTrackingList<SavingsPlanSummary>();
        }

        /// <summary> Initializes a new instance of <see cref="SavingsPlanModelListResult"/>. </summary>
        /// <param name="value"> The list of savings plans. </param>
        /// <param name="nextLink"> Url to get the next page. </param>
        /// <param name="additionalProperties"> The roll out count summary of the savings plans. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SavingsPlanModelListResult(IReadOnlyList<BillingBenefitsSavingsPlanData> value, string nextLink, IReadOnlyList<SavingsPlanSummary> additionalProperties, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Value = value;
            NextLink = nextLink;
            AdditionalProperties = additionalProperties;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The list of savings plans. </summary>
        public IReadOnlyList<BillingBenefitsSavingsPlanData> Value { get; }
        /// <summary> Url to get the next page. </summary>
        public string NextLink { get; }
        /// <summary> The roll out count summary of the savings plans. </summary>
        public IReadOnlyList<SavingsPlanSummary> AdditionalProperties { get; }
    }
}
