// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.BillingBenefits.Models
{
    /// <summary> Represent benefit term in ISO 8601 format. </summary>
    public readonly partial struct BillingBenefitsTerm : IEquatable<BillingBenefitsTerm>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BillingBenefitsTerm"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BillingBenefitsTerm(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string P1YValue = "P1Y";
        private const string P3YValue = "P3Y";
        private const string P5YValue = "P5Y";

        /// <summary> P1Y. </summary>
        public static BillingBenefitsTerm P1Y { get; } = new BillingBenefitsTerm(P1YValue);
        /// <summary> P3Y. </summary>
        public static BillingBenefitsTerm P3Y { get; } = new BillingBenefitsTerm(P3YValue);
        /// <summary> P5Y. </summary>
        public static BillingBenefitsTerm P5Y { get; } = new BillingBenefitsTerm(P5YValue);
        /// <summary> Determines if two <see cref="BillingBenefitsTerm"/> values are the same. </summary>
        public static bool operator ==(BillingBenefitsTerm left, BillingBenefitsTerm right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BillingBenefitsTerm"/> values are not the same. </summary>
        public static bool operator !=(BillingBenefitsTerm left, BillingBenefitsTerm right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BillingBenefitsTerm"/>. </summary>
        public static implicit operator BillingBenefitsTerm(string value) => new BillingBenefitsTerm(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BillingBenefitsTerm other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BillingBenefitsTerm other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
