// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.BillingBenefits.Models
{
    /// <summary> Savings plan patch request. </summary>
    public partial class BillingBenefitsSavingsPlanPatchProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BillingBenefitsSavingsPlanPatchProperties"/>. </summary>
        public BillingBenefitsSavingsPlanPatchProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="BillingBenefitsSavingsPlanPatchProperties"/>. </summary>
        /// <param name="displayName"> Display name. </param>
        /// <param name="appliedScopeType"> Type of the Applied Scope. </param>
        /// <param name="appliedScopeProperties"> Properties specific to applied scope type. Not required if not applicable. </param>
        /// <param name="isRenewed"> Setting this to true will automatically purchase a new benefit on the expiration date time. </param>
        /// <param name="renewProperties"></param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BillingBenefitsSavingsPlanPatchProperties(string displayName, BillingBenefitsAppliedScopeType? appliedScopeType, BillingBenefitsAppliedScopeProperties appliedScopeProperties, bool? isRenewed, RenewProperties renewProperties, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            DisplayName = displayName;
            AppliedScopeType = appliedScopeType;
            AppliedScopeProperties = appliedScopeProperties;
            IsRenewed = isRenewed;
            RenewProperties = renewProperties;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Display name. </summary>
        public string DisplayName { get; set; }
        /// <summary> Type of the Applied Scope. </summary>
        public BillingBenefitsAppliedScopeType? AppliedScopeType { get; set; }
        /// <summary> Properties specific to applied scope type. Not required if not applicable. </summary>
        public BillingBenefitsAppliedScopeProperties AppliedScopeProperties { get; set; }
        /// <summary> Setting this to true will automatically purchase a new benefit on the expiration date time. </summary>
        public bool? IsRenewed { get; set; }
        /// <summary> Gets or sets the renew properties. </summary>
        internal RenewProperties RenewProperties { get; set; }
        /// <summary> Gets or sets the renew purchase properties. </summary>
        public BillingBenefitsPurchaseContent RenewPurchaseProperties
        {
            get => RenewProperties is null ? default : RenewProperties.PurchaseProperties;
            set
            {
                if (RenewProperties is null)
                    RenewProperties = new RenewProperties();
                RenewProperties.PurchaseProperties = value;
            }
        }
    }
}
