// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.BillingBenefits.Models
{
    /// <summary> The type of the resource that is being reserved. </summary>
    public readonly partial struct BillingBenefitsReservedResourceType : IEquatable<BillingBenefitsReservedResourceType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BillingBenefitsReservedResourceType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BillingBenefitsReservedResourceType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string VirtualMachinesValue = "VirtualMachines";
        private const string SqlDatabasesValue = "SqlDatabases";
        private const string SuseLinuxValue = "SuseLinux";
        private const string CosmosDBValue = "CosmosDb";
        private const string RedHatValue = "RedHat";
        private const string SqlDataWarehouseValue = "SqlDataWarehouse";
        private const string VMwareCloudSimpleValue = "VMwareCloudSimple";
        private const string RedHatOsaValue = "RedHatOsa";
        private const string DatabricksValue = "Databricks";
        private const string AppServiceValue = "AppService";
        private const string ManagedDiskValue = "ManagedDisk";
        private const string BlockBlobValue = "BlockBlob";
        private const string RedisCacheValue = "RedisCache";
        private const string AzureDataExplorerValue = "AzureDataExplorer";
        private const string MySqlValue = "MySql";
        private const string MariaDBValue = "MariaDb";
        private const string PostgreSqlValue = "PostgreSql";
        private const string DedicatedHostValue = "DedicatedHost";
        private const string SapHanaValue = "SapHana";
        private const string SqlAzureHybridBenefitValue = "SqlAzureHybridBenefit";
        private const string AvsValue = "AVS";
        private const string DataFactoryValue = "DataFactory";
        private const string NetAppStorageValue = "NetAppStorage";
        private const string AzureFilesValue = "AzureFiles";
        private const string SqlEdgeValue = "SqlEdge";
        private const string VirtualMachineSoftwareValue = "VirtualMachineSoftware";

        /// <summary> VirtualMachines. </summary>
        public static BillingBenefitsReservedResourceType VirtualMachines { get; } = new BillingBenefitsReservedResourceType(VirtualMachinesValue);
        /// <summary> SqlDatabases. </summary>
        public static BillingBenefitsReservedResourceType SqlDatabases { get; } = new BillingBenefitsReservedResourceType(SqlDatabasesValue);
        /// <summary> SuseLinux. </summary>
        public static BillingBenefitsReservedResourceType SuseLinux { get; } = new BillingBenefitsReservedResourceType(SuseLinuxValue);
        /// <summary> CosmosDb. </summary>
        public static BillingBenefitsReservedResourceType CosmosDB { get; } = new BillingBenefitsReservedResourceType(CosmosDBValue);
        /// <summary> RedHat. </summary>
        public static BillingBenefitsReservedResourceType RedHat { get; } = new BillingBenefitsReservedResourceType(RedHatValue);
        /// <summary> SqlDataWarehouse. </summary>
        public static BillingBenefitsReservedResourceType SqlDataWarehouse { get; } = new BillingBenefitsReservedResourceType(SqlDataWarehouseValue);
        /// <summary> VMwareCloudSimple. </summary>
        public static BillingBenefitsReservedResourceType VMwareCloudSimple { get; } = new BillingBenefitsReservedResourceType(VMwareCloudSimpleValue);
        /// <summary> RedHatOsa. </summary>
        public static BillingBenefitsReservedResourceType RedHatOsa { get; } = new BillingBenefitsReservedResourceType(RedHatOsaValue);
        /// <summary> Databricks. </summary>
        public static BillingBenefitsReservedResourceType Databricks { get; } = new BillingBenefitsReservedResourceType(DatabricksValue);
        /// <summary> AppService. </summary>
        public static BillingBenefitsReservedResourceType AppService { get; } = new BillingBenefitsReservedResourceType(AppServiceValue);
        /// <summary> ManagedDisk. </summary>
        public static BillingBenefitsReservedResourceType ManagedDisk { get; } = new BillingBenefitsReservedResourceType(ManagedDiskValue);
        /// <summary> BlockBlob. </summary>
        public static BillingBenefitsReservedResourceType BlockBlob { get; } = new BillingBenefitsReservedResourceType(BlockBlobValue);
        /// <summary> RedisCache. </summary>
        public static BillingBenefitsReservedResourceType RedisCache { get; } = new BillingBenefitsReservedResourceType(RedisCacheValue);
        /// <summary> AzureDataExplorer. </summary>
        public static BillingBenefitsReservedResourceType AzureDataExplorer { get; } = new BillingBenefitsReservedResourceType(AzureDataExplorerValue);
        /// <summary> MySql. </summary>
        public static BillingBenefitsReservedResourceType MySql { get; } = new BillingBenefitsReservedResourceType(MySqlValue);
        /// <summary> MariaDb. </summary>
        public static BillingBenefitsReservedResourceType MariaDB { get; } = new BillingBenefitsReservedResourceType(MariaDBValue);
        /// <summary> PostgreSql. </summary>
        public static BillingBenefitsReservedResourceType PostgreSql { get; } = new BillingBenefitsReservedResourceType(PostgreSqlValue);
        /// <summary> DedicatedHost. </summary>
        public static BillingBenefitsReservedResourceType DedicatedHost { get; } = new BillingBenefitsReservedResourceType(DedicatedHostValue);
        /// <summary> SapHana. </summary>
        public static BillingBenefitsReservedResourceType SapHana { get; } = new BillingBenefitsReservedResourceType(SapHanaValue);
        /// <summary> SqlAzureHybridBenefit. </summary>
        public static BillingBenefitsReservedResourceType SqlAzureHybridBenefit { get; } = new BillingBenefitsReservedResourceType(SqlAzureHybridBenefitValue);
        /// <summary> AVS. </summary>
        public static BillingBenefitsReservedResourceType Avs { get; } = new BillingBenefitsReservedResourceType(AvsValue);
        /// <summary> DataFactory. </summary>
        public static BillingBenefitsReservedResourceType DataFactory { get; } = new BillingBenefitsReservedResourceType(DataFactoryValue);
        /// <summary> NetAppStorage. </summary>
        public static BillingBenefitsReservedResourceType NetAppStorage { get; } = new BillingBenefitsReservedResourceType(NetAppStorageValue);
        /// <summary> AzureFiles. </summary>
        public static BillingBenefitsReservedResourceType AzureFiles { get; } = new BillingBenefitsReservedResourceType(AzureFilesValue);
        /// <summary> SqlEdge. </summary>
        public static BillingBenefitsReservedResourceType SqlEdge { get; } = new BillingBenefitsReservedResourceType(SqlEdgeValue);
        /// <summary> VirtualMachineSoftware. </summary>
        public static BillingBenefitsReservedResourceType VirtualMachineSoftware { get; } = new BillingBenefitsReservedResourceType(VirtualMachineSoftwareValue);
        /// <summary> Determines if two <see cref="BillingBenefitsReservedResourceType"/> values are the same. </summary>
        public static bool operator ==(BillingBenefitsReservedResourceType left, BillingBenefitsReservedResourceType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BillingBenefitsReservedResourceType"/> values are not the same. </summary>
        public static bool operator !=(BillingBenefitsReservedResourceType left, BillingBenefitsReservedResourceType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BillingBenefitsReservedResourceType"/>. </summary>
        public static implicit operator BillingBenefitsReservedResourceType(string value) => new BillingBenefitsReservedResourceType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BillingBenefitsReservedResourceType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BillingBenefitsReservedResourceType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
