// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.BillingBenefits.Models
{
    /// <summary> Describes whether the payment is completed, failed, cancelled or scheduled in the future. </summary>
    public readonly partial struct BillingBenefitsPaymentStatus : IEquatable<BillingBenefitsPaymentStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BillingBenefitsPaymentStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BillingBenefitsPaymentStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SucceededValue = "Succeeded";
        private const string FailedValue = "Failed";
        private const string ScheduledValue = "Scheduled";
        private const string CancelledValue = "Cancelled";

        /// <summary> Succeeded. </summary>
        public static BillingBenefitsPaymentStatus Succeeded { get; } = new BillingBenefitsPaymentStatus(SucceededValue);
        /// <summary> Failed. </summary>
        public static BillingBenefitsPaymentStatus Failed { get; } = new BillingBenefitsPaymentStatus(FailedValue);
        /// <summary> Scheduled. </summary>
        public static BillingBenefitsPaymentStatus Scheduled { get; } = new BillingBenefitsPaymentStatus(ScheduledValue);
        /// <summary> Cancelled. </summary>
        public static BillingBenefitsPaymentStatus Cancelled { get; } = new BillingBenefitsPaymentStatus(CancelledValue);
        /// <summary> Determines if two <see cref="BillingBenefitsPaymentStatus"/> values are the same. </summary>
        public static bool operator ==(BillingBenefitsPaymentStatus left, BillingBenefitsPaymentStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BillingBenefitsPaymentStatus"/> values are not the same. </summary>
        public static bool operator !=(BillingBenefitsPaymentStatus left, BillingBenefitsPaymentStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BillingBenefitsPaymentStatus"/>. </summary>
        public static implicit operator BillingBenefitsPaymentStatus(string value) => new BillingBenefitsPaymentStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BillingBenefitsPaymentStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BillingBenefitsPaymentStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
