// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.BillingBenefits.Models
{
    /// <summary> Turning this on will apply the reservation discount to other VMs in the same VM size group. </summary>
    public readonly partial struct BillingBenefitsInstanceFlexibility : IEquatable<BillingBenefitsInstanceFlexibility>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BillingBenefitsInstanceFlexibility"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BillingBenefitsInstanceFlexibility(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OnValue = "On";
        private const string OffValue = "Off";

        /// <summary> On. </summary>
        public static BillingBenefitsInstanceFlexibility On { get; } = new BillingBenefitsInstanceFlexibility(OnValue);
        /// <summary> Off. </summary>
        public static BillingBenefitsInstanceFlexibility Off { get; } = new BillingBenefitsInstanceFlexibility(OffValue);
        /// <summary> Determines if two <see cref="BillingBenefitsInstanceFlexibility"/> values are the same. </summary>
        public static bool operator ==(BillingBenefitsInstanceFlexibility left, BillingBenefitsInstanceFlexibility right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BillingBenefitsInstanceFlexibility"/> values are not the same. </summary>
        public static bool operator !=(BillingBenefitsInstanceFlexibility left, BillingBenefitsInstanceFlexibility right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BillingBenefitsInstanceFlexibility"/>. </summary>
        public static implicit operator BillingBenefitsInstanceFlexibility(string value) => new BillingBenefitsInstanceFlexibility(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BillingBenefitsInstanceFlexibility other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BillingBenefitsInstanceFlexibility other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
