// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.BillingBenefits.Models
{
    /// <summary> Commitment grain. </summary>
    public readonly partial struct BillingBenefitsCommitmentGrain : IEquatable<BillingBenefitsCommitmentGrain>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BillingBenefitsCommitmentGrain"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BillingBenefitsCommitmentGrain(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string HourlyValue = "Hourly";

        /// <summary> Hourly. </summary>
        public static BillingBenefitsCommitmentGrain Hourly { get; } = new BillingBenefitsCommitmentGrain(HourlyValue);
        /// <summary> Determines if two <see cref="BillingBenefitsCommitmentGrain"/> values are the same. </summary>
        public static bool operator ==(BillingBenefitsCommitmentGrain left, BillingBenefitsCommitmentGrain right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BillingBenefitsCommitmentGrain"/> values are not the same. </summary>
        public static bool operator !=(BillingBenefitsCommitmentGrain left, BillingBenefitsCommitmentGrain right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BillingBenefitsCommitmentGrain"/>. </summary>
        public static implicit operator BillingBenefitsCommitmentGrain(string value) => new BillingBenefitsCommitmentGrain(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BillingBenefitsCommitmentGrain other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BillingBenefitsCommitmentGrain other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
