// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.BillingBenefits.Models
{
    /// <summary> Represents the billing plan in ISO 8601 format. Required only for monthly billing plans. </summary>
    public readonly partial struct BillingBenefitsBillingPlan : IEquatable<BillingBenefitsBillingPlan>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BillingBenefitsBillingPlan"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BillingBenefitsBillingPlan(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string P1MValue = "P1M";

        /// <summary> P1M. </summary>
        public static BillingBenefitsBillingPlan P1M { get; } = new BillingBenefitsBillingPlan(P1MValue);
        /// <summary> Determines if two <see cref="BillingBenefitsBillingPlan"/> values are the same. </summary>
        public static bool operator ==(BillingBenefitsBillingPlan left, BillingBenefitsBillingPlan right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BillingBenefitsBillingPlan"/> values are not the same. </summary>
        public static bool operator !=(BillingBenefitsBillingPlan left, BillingBenefitsBillingPlan right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BillingBenefitsBillingPlan"/>. </summary>
        public static implicit operator BillingBenefitsBillingPlan(string value) => new BillingBenefitsBillingPlan(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BillingBenefitsBillingPlan other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BillingBenefitsBillingPlan other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
