// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.BillingBenefits.Models
{
    /// <summary> Type of the Applied Scope. </summary>
    public readonly partial struct BillingBenefitsAppliedScopeType : IEquatable<BillingBenefitsAppliedScopeType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BillingBenefitsAppliedScopeType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BillingBenefitsAppliedScopeType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SingleValue = "Single";
        private const string SharedValue = "Shared";
        private const string ManagementGroupValue = "ManagementGroup";

        /// <summary> Single. </summary>
        public static BillingBenefitsAppliedScopeType Single { get; } = new BillingBenefitsAppliedScopeType(SingleValue);
        /// <summary> Shared. </summary>
        public static BillingBenefitsAppliedScopeType Shared { get; } = new BillingBenefitsAppliedScopeType(SharedValue);
        /// <summary> ManagementGroup. </summary>
        public static BillingBenefitsAppliedScopeType ManagementGroup { get; } = new BillingBenefitsAppliedScopeType(ManagementGroupValue);
        /// <summary> Determines if two <see cref="BillingBenefitsAppliedScopeType"/> values are the same. </summary>
        public static bool operator ==(BillingBenefitsAppliedScopeType left, BillingBenefitsAppliedScopeType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BillingBenefitsAppliedScopeType"/> values are not the same. </summary>
        public static bool operator !=(BillingBenefitsAppliedScopeType left, BillingBenefitsAppliedScopeType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BillingBenefitsAppliedScopeType"/>. </summary>
        public static implicit operator BillingBenefitsAppliedScopeType(string value) => new BillingBenefitsAppliedScopeType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BillingBenefitsAppliedScopeType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BillingBenefitsAppliedScopeType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
