// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.BillingBenefits
{
    internal class BillingBenefitsReservationOrderAliasOperationSource : IOperationSource<BillingBenefitsReservationOrderAliasResource>
    {
        private readonly ArmClient _client;

        internal BillingBenefitsReservationOrderAliasOperationSource(ArmClient client)
        {
            _client = client;
        }

        BillingBenefitsReservationOrderAliasResource IOperationSource<BillingBenefitsReservationOrderAliasResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = BillingBenefitsReservationOrderAliasData.DeserializeBillingBenefitsReservationOrderAliasData(document.RootElement);
            return new BillingBenefitsReservationOrderAliasResource(_client, data);
        }

        async ValueTask<BillingBenefitsReservationOrderAliasResource> IOperationSource<BillingBenefitsReservationOrderAliasResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = BillingBenefitsReservationOrderAliasData.DeserializeBillingBenefitsReservationOrderAliasData(document.RootElement);
            return new BillingBenefitsReservationOrderAliasResource(_client, data);
        }
    }
}
