// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.BillingBenefits.Models
{
    /// <summary> Model factory for models. </summary>
    public static partial class ArmBillingBenefitsModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="BillingBenefits.BillingBenefitsSavingsPlanOrderAliasData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="skuName"> Savings plan SKU. </param>
        /// <param name="kind"> Resource provider kind. </param>
        /// <param name="displayName"> Display name. </param>
        /// <param name="savingsPlanOrderId"> Identifier of the savings plan created. </param>
        /// <param name="provisioningState"> Provisioning state. </param>
        /// <param name="billingScopeId"> Subscription that will be charged for purchasing the benefit. </param>
        /// <param name="term"> Represent benefit term in ISO 8601 format. </param>
        /// <param name="billingPlan"> Represents the billing plan in ISO 8601 format. Required only for monthly billing plans. </param>
        /// <param name="appliedScopeType"> Type of the Applied Scope. </param>
        /// <param name="appliedScopeProperties"> Properties specific to applied scope type. Not required if not applicable. </param>
        /// <param name="commitment"> Commitment towards the benefit. </param>
        /// <returns> A new <see cref="BillingBenefits.BillingBenefitsSavingsPlanOrderAliasData"/> instance for mocking. </returns>
        public static BillingBenefitsSavingsPlanOrderAliasData BillingBenefitsSavingsPlanOrderAliasData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string skuName = null, string kind = null, string displayName = null, ResourceIdentifier savingsPlanOrderId = null, BillingBenefitsProvisioningState? provisioningState = null, ResourceIdentifier billingScopeId = null, BillingBenefitsTerm? term = null, BillingBenefitsBillingPlan? billingPlan = null, BillingBenefitsAppliedScopeType? appliedScopeType = null, BillingBenefitsAppliedScopeProperties appliedScopeProperties = null, BillingBenefitsCommitment commitment = null)
        {
            return new BillingBenefitsSavingsPlanOrderAliasData(
                id,
                name,
                resourceType,
                systemData,
                skuName != null ? new BillingBenefitsSku(skuName, serializedAdditionalRawData: null) : null,
                kind,
                displayName,
                savingsPlanOrderId,
                provisioningState,
                billingScopeId,
                term,
                billingPlan,
                appliedScopeType,
                appliedScopeProperties,
                commitment,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="BillingBenefits.BillingBenefitsSavingsPlanOrderData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="skuName"> Savings plan SKU. </param>
        /// <param name="displayName"> Display name. </param>
        /// <param name="provisioningState"> Provisioning state. </param>
        /// <param name="billingScopeId"> Subscription that will be charged for purchasing the benefit. </param>
        /// <param name="billingProfileId"> Fully-qualified identifier of the billing profile where the savings plan is applied. Present only for Field-led or Customer-led customers. </param>
        /// <param name="customerId"> Fully-qualified identifier of the customer where the savings plan is applied. Present only for Partner-led customers. </param>
        /// <param name="billingAccountId"> Fully-qualified identifier of the billing account where the savings plan is applied. Present only for Enterprise Agreement customers. </param>
        /// <param name="term"> Represent benefit term in ISO 8601 format. </param>
        /// <param name="billingPlan"> Represents the billing plan in ISO 8601 format. Required only for monthly billing plans. </param>
        /// <param name="expireOn"> Expiry date time. </param>
        /// <param name="benefitStartOn"> This is the DateTime when the savings plan benefit started. </param>
        /// <param name="planInformation"> Information describing the type of billing plan for this savings plan. </param>
        /// <param name="savingsPlans"></param>
        /// <param name="extendedStatusInfo"></param>
        /// <returns> A new <see cref="BillingBenefits.BillingBenefitsSavingsPlanOrderData"/> instance for mocking. </returns>
        public static BillingBenefitsSavingsPlanOrderData BillingBenefitsSavingsPlanOrderData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string skuName = null, string displayName = null, BillingBenefitsProvisioningState? provisioningState = null, ResourceIdentifier billingScopeId = null, ResourceIdentifier billingProfileId = null, string customerId = null, ResourceIdentifier billingAccountId = null, BillingBenefitsTerm? term = null, BillingBenefitsBillingPlan? billingPlan = null, DateTimeOffset? expireOn = null, DateTimeOffset? benefitStartOn = null, BillingPlanInformation planInformation = null, IEnumerable<string> savingsPlans = null, BillingBenefitsExtendedStatusInfo extendedStatusInfo = null)
        {
            savingsPlans ??= new List<string>();

            return new BillingBenefitsSavingsPlanOrderData(
                id,
                name,
                resourceType,
                systemData,
                skuName != null ? new BillingBenefitsSku(skuName, serializedAdditionalRawData: null) : null,
                displayName,
                provisioningState,
                billingScopeId,
                billingProfileId,
                customerId,
                billingAccountId,
                term,
                billingPlan,
                expireOn,
                benefitStartOn,
                planInformation,
                savingsPlans?.ToList(),
                extendedStatusInfo,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SavingsPlanOrderPaymentDetail"/>. </summary>
        /// <param name="dueOn"> Date when the payment needs to be done. </param>
        /// <param name="payOn"> Date when the transaction is completed. Is null when it is scheduled. </param>
        /// <param name="pricingCurrencyTotal"> Amount in pricing currency. Tax not included. </param>
        /// <param name="billingCurrencyTotal"> Amount charged in Billing currency. Tax not included. Is null for future payments. </param>
        /// <param name="status"> Describes whether the payment is completed, failed, cancelled or scheduled in the future. </param>
        /// <param name="extendedStatusInfo"></param>
        /// <param name="billingAccount"> Billing account. </param>
        /// <returns> A new <see cref="Models.SavingsPlanOrderPaymentDetail"/> instance for mocking. </returns>
        public static SavingsPlanOrderPaymentDetail SavingsPlanOrderPaymentDetail(DateTimeOffset? dueOn = null, DateTimeOffset? payOn = null, BillingBenefitsPrice pricingCurrencyTotal = null, BillingBenefitsPrice billingCurrencyTotal = null, BillingBenefitsPaymentStatus? status = null, BillingBenefitsExtendedStatusInfo extendedStatusInfo = null, string billingAccount = null)
        {
            return new SavingsPlanOrderPaymentDetail(
                dueOn,
                payOn,
                pricingCurrencyTotal,
                billingCurrencyTotal,
                status,
                extendedStatusInfo,
                billingAccount,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.BillingBenefitsExtendedStatusInfo"/>. </summary>
        /// <param name="statusCode"> Status code providing additional information. </param>
        /// <param name="message"> The message giving detailed information about the status code. </param>
        /// <returns> A new <see cref="Models.BillingBenefitsExtendedStatusInfo"/> instance for mocking. </returns>
        public static BillingBenefitsExtendedStatusInfo BillingBenefitsExtendedStatusInfo(string statusCode = null, string message = null)
        {
            return new BillingBenefitsExtendedStatusInfo(statusCode, message, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.BillingBenefitsRoleAssignmentEntity"/>. </summary>
        /// <param name="id"> Role assignment entity id. </param>
        /// <param name="name"> Role assignment entity name. </param>
        /// <param name="principalId"> Principal Id. </param>
        /// <param name="roleDefinitionId"> Role definition id. </param>
        /// <param name="scope"> Scope of the role assignment entity. </param>
        /// <returns> A new <see cref="Models.BillingBenefitsRoleAssignmentEntity"/> instance for mocking. </returns>
        public static BillingBenefitsRoleAssignmentEntity BillingBenefitsRoleAssignmentEntity(ResourceIdentifier id = null, string name = null, string principalId = null, ResourceIdentifier roleDefinitionId = null, ResourceIdentifier scope = null)
        {
            return new BillingBenefitsRoleAssignmentEntity(
                id,
                name,
                principalId,
                roleDefinitionId,
                scope,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="BillingBenefits.BillingBenefitsSavingsPlanData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="skuName"> Savings plan SKU. </param>
        /// <param name="displayName"> Display name. </param>
        /// <param name="provisioningState"> Provisioning state. </param>
        /// <param name="displayProvisioningState"> The provisioning state of the savings plan for display, e.g. Succeeded. </param>
        /// <param name="billingScopeId"> Subscription that will be charged for purchasing the benefit. </param>
        /// <param name="billingProfileId"> Fully-qualified identifier of the billing profile where the savings plan is applied. Present only for Field-led or Customer-led customers. </param>
        /// <param name="customerId"> Fully-qualified identifier of the customer where the savings plan is applied. Present only for Partner-led customers. </param>
        /// <param name="billingAccountId"> Fully-qualified identifier of the billing account where the savings plan is applied. Present only for Enterprise Agreement customers. </param>
        /// <param name="term"> Represent benefit term in ISO 8601 format. </param>
        /// <param name="billingPlan"> Represents the billing plan in ISO 8601 format. Required only for monthly billing plans. </param>
        /// <param name="appliedScopeType"> Type of the Applied Scope. </param>
        /// <param name="userFriendlyAppliedScopeType"> The applied scope type of the savings plan for display, e.g. Shared. </param>
        /// <param name="appliedScopeProperties"> Properties specific to applied scope type. Not required if not applicable. </param>
        /// <param name="commitment"> Commitment towards the benefit. </param>
        /// <param name="effectOn"> DateTime of the savings plan starts providing benefit from. </param>
        /// <param name="expireOn"> Expiry date time. </param>
        /// <param name="purchaseOn"> Date time when the savings plan was purchased. </param>
        /// <param name="benefitStartOn"> This is the DateTime when the savings plan benefit started. </param>
        /// <param name="extendedStatusInfo"></param>
        /// <param name="isRenewed"> Setting this to true will automatically purchase a new benefit on the expiration date time. </param>
        /// <param name="utilization"> Savings plan utilization. </param>
        /// <param name="renewSource"> SavingsPlan Id of the SavingsPlan from which this SavingsPlan is renewed. </param>
        /// <param name="renewDestination"> SavingsPlan Id of the SavingsPlan which is purchased because of renew. </param>
        /// <param name="renewPurchaseProperties"></param>
        /// <returns> A new <see cref="BillingBenefits.BillingBenefitsSavingsPlanData"/> instance for mocking. </returns>
        public static BillingBenefitsSavingsPlanData BillingBenefitsSavingsPlanData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string skuName = null, string displayName = null, BillingBenefitsProvisioningState? provisioningState = null, string displayProvisioningState = null, ResourceIdentifier billingScopeId = null, ResourceIdentifier billingProfileId = null, string customerId = null, ResourceIdentifier billingAccountId = null, BillingBenefitsTerm? term = null, BillingBenefitsBillingPlan? billingPlan = null, BillingBenefitsAppliedScopeType? appliedScopeType = null, string userFriendlyAppliedScopeType = null, BillingBenefitsAppliedScopeProperties appliedScopeProperties = null, BillingBenefitsCommitment commitment = null, DateTimeOffset? effectOn = null, DateTimeOffset? expireOn = null, DateTimeOffset? purchaseOn = null, DateTimeOffset? benefitStartOn = null, BillingBenefitsExtendedStatusInfo extendedStatusInfo = null, bool? isRenewed = null, BillingBenefitsSavingsPlanUtilization utilization = null, string renewSource = null, string renewDestination = null, BillingBenefitsPurchaseContent renewPurchaseProperties = null)
        {
            return new BillingBenefitsSavingsPlanData(
                id,
                name,
                resourceType,
                systemData,
                skuName != null ? new BillingBenefitsSku(skuName, serializedAdditionalRawData: null) : null,
                displayName,
                provisioningState,
                displayProvisioningState,
                billingScopeId,
                billingProfileId,
                customerId,
                billingAccountId,
                term,
                billingPlan,
                appliedScopeType,
                userFriendlyAppliedScopeType,
                appliedScopeProperties,
                commitment,
                effectOn,
                expireOn,
                purchaseOn,
                benefitStartOn,
                extendedStatusInfo,
                isRenewed,
                utilization,
                renewSource,
                renewDestination,
                renewPurchaseProperties != null ? new RenewProperties(renewPurchaseProperties, serializedAdditionalRawData: null) : null,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.BillingBenefitsSavingsPlanUtilization"/>. </summary>
        /// <param name="trend"> The number of days trend for a savings plan. </param>
        /// <param name="aggregates"> The array of aggregates of a savings plan's utilization. </param>
        /// <returns> A new <see cref="Models.BillingBenefitsSavingsPlanUtilization"/> instance for mocking. </returns>
        public static BillingBenefitsSavingsPlanUtilization BillingBenefitsSavingsPlanUtilization(string trend = null, IEnumerable<BillingBenefitsSavingsPlanUtilizationAggregate> aggregates = null)
        {
            aggregates ??= new List<BillingBenefitsSavingsPlanUtilizationAggregate>();

            return new BillingBenefitsSavingsPlanUtilization(trend, aggregates?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.BillingBenefitsSavingsPlanUtilizationAggregate"/>. </summary>
        /// <param name="grain"> The grain of the aggregate. </param>
        /// <param name="grainUnit"> The grain unit of the aggregate. </param>
        /// <param name="value"> The aggregate value. </param>
        /// <param name="valueUnit"> The aggregate value unit. </param>
        /// <returns> A new <see cref="Models.BillingBenefitsSavingsPlanUtilizationAggregate"/> instance for mocking. </returns>
        public static BillingBenefitsSavingsPlanUtilizationAggregate BillingBenefitsSavingsPlanUtilizationAggregate(float? grain = null, string grainUnit = null, float? value = null, string valueUnit = null)
        {
            return new BillingBenefitsSavingsPlanUtilizationAggregate(grain, grainUnit, value, valueUnit, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.BillingBenefitsPurchaseContent"/>. </summary>
        /// <param name="skuName"> The SKU to be applied for this resource. </param>
        /// <param name="displayName"> Friendly name of the savings plan. </param>
        /// <param name="billingScopeId"> Subscription that will be charged for purchasing the benefit. </param>
        /// <param name="term"> Represent benefit term in ISO 8601 format. </param>
        /// <param name="billingPlan"> Represents the billing plan in ISO 8601 format. Required only for monthly billing plans. </param>
        /// <param name="appliedScopeType"> Type of the Applied Scope. </param>
        /// <param name="commitment"> Commitment towards the benefit. </param>
        /// <param name="effectOn"> DateTime of the savings plan starts providing benefit from. </param>
        /// <param name="isRenewed"> Setting this to true will automatically purchase a new benefit on the expiration date time. </param>
        /// <param name="appliedScopeProperties"> Properties specific to applied scope type. Not required if not applicable. </param>
        /// <returns> A new <see cref="Models.BillingBenefitsPurchaseContent"/> instance for mocking. </returns>
        public static BillingBenefitsPurchaseContent BillingBenefitsPurchaseContent(string skuName = null, string displayName = null, ResourceIdentifier billingScopeId = null, BillingBenefitsTerm? term = null, BillingBenefitsBillingPlan? billingPlan = null, BillingBenefitsAppliedScopeType? appliedScopeType = null, BillingBenefitsCommitment commitment = null, DateTimeOffset? effectOn = null, bool? isRenewed = null, BillingBenefitsAppliedScopeProperties appliedScopeProperties = null)
        {
            return new BillingBenefitsPurchaseContent(
                skuName != null ? new BillingBenefitsSku(skuName, serializedAdditionalRawData: null) : null,
                displayName,
                billingScopeId,
                term,
                billingPlan,
                appliedScopeType,
                commitment,
                effectOn,
                isRenewed,
                appliedScopeProperties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SavingsPlanValidateResult"/>. </summary>
        /// <param name="isValid"> Indicates if the provided input was valid. </param>
        /// <param name="reasonCode"> Failure reason code if the provided input was invalid. </param>
        /// <param name="reason"> Failure reason if the provided input was invalid. </param>
        /// <returns> A new <see cref="Models.SavingsPlanValidateResult"/> instance for mocking. </returns>
        public static SavingsPlanValidateResult SavingsPlanValidateResult(bool? isValid = null, string reasonCode = null, string reason = null)
        {
            return new SavingsPlanValidateResult(isValid, reasonCode, reason, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.BillingBenefitsReservationOrderAliasCreateOrUpdateContent"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="skuName"> Reservation order SKU. </param>
        /// <param name="location"> The Azure Region where the reservation benefits are applied to. </param>
        /// <param name="displayName"> Display name. </param>
        /// <param name="billingScopeId"> Subscription that will be charged for purchasing the benefit. </param>
        /// <param name="term"> Represent benefit term in ISO 8601 format. </param>
        /// <param name="billingPlan"> Represents the billing plan in ISO 8601 format. Required only for monthly billing plans. </param>
        /// <param name="appliedScopeType"> Type of the Applied Scope. </param>
        /// <param name="appliedScopeProperties"> Properties specific to applied scope type. Not required if not applicable. </param>
        /// <param name="quantity"> Total Quantity of the SKUs purchased in the Reservation. </param>
        /// <param name="isRenewed"> Setting this to true will automatically purchase a new benefit on the expiration date time. </param>
        /// <param name="reservedResourceType"> The type of the resource that is being reserved. </param>
        /// <param name="reviewOn"> This is the date-time when the Azure Hybrid Benefit needs to be reviewed. </param>
        /// <param name="reservedResourceInstanceFlexibility"> Properties specific to each reserved resource type. Not required if not applicable. </param>
        /// <returns> A new <see cref="Models.BillingBenefitsReservationOrderAliasCreateOrUpdateContent"/> instance for mocking. </returns>
        public static BillingBenefitsReservationOrderAliasCreateOrUpdateContent BillingBenefitsReservationOrderAliasCreateOrUpdateContent(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string skuName = null, AzureLocation? location = null, string displayName = null, ResourceIdentifier billingScopeId = null, BillingBenefitsTerm? term = null, BillingBenefitsBillingPlan? billingPlan = null, BillingBenefitsAppliedScopeType? appliedScopeType = null, BillingBenefitsAppliedScopeProperties appliedScopeProperties = null, int? quantity = null, bool? isRenewed = null, BillingBenefitsReservedResourceType? reservedResourceType = null, DateTimeOffset? reviewOn = null, BillingBenefitsInstanceFlexibility? reservedResourceInstanceFlexibility = null)
        {
            return new BillingBenefitsReservationOrderAliasCreateOrUpdateContent(
                id,
                name,
                resourceType,
                systemData,
                skuName != null ? new BillingBenefitsSku(skuName, serializedAdditionalRawData: null) : null,
                location,
                displayName,
                billingScopeId,
                term,
                billingPlan,
                appliedScopeType,
                appliedScopeProperties,
                quantity,
                isRenewed,
                reservedResourceType,
                reviewOn,
                reservedResourceInstanceFlexibility != null ? new ReservationOrderAliasRequestPropertiesReservedResourceProperties(reservedResourceInstanceFlexibility, serializedAdditionalRawData: null) : null,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="BillingBenefits.BillingBenefitsReservationOrderAliasData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="skuName"> Reservation order SKU. </param>
        /// <param name="location"> The Azure Region where the reserved resource lives. </param>
        /// <param name="displayName"> Display name. </param>
        /// <param name="reservationOrderId"> Identifier of the reservation order created. </param>
        /// <param name="provisioningState"> Provisioning state. </param>
        /// <param name="billingScopeId"> Subscription that will be charged for purchasing the benefit. </param>
        /// <param name="term"> Represent benefit term in ISO 8601 format. </param>
        /// <param name="billingPlan"> Represents the billing plan in ISO 8601 format. Required only for monthly billing plans. </param>
        /// <param name="appliedScopeType"> Type of the Applied Scope. </param>
        /// <param name="appliedScopeProperties"> Properties specific to applied scope type. Not required if not applicable. </param>
        /// <param name="quantity"> Total Quantity of the SKUs purchased in the Reservation. </param>
        /// <param name="isRenewed"> Setting this to true will automatically purchase a new benefit on the expiration date time. </param>
        /// <param name="reservedResourceType"> The type of the resource that is being reserved. </param>
        /// <param name="reviewOn"> This is the date-time when the Reservation needs to be reviewed. </param>
        /// <param name="reservedResourceInstanceFlexibility"> Properties specific to each reserved resource type. Not required if not applicable. </param>
        /// <returns> A new <see cref="BillingBenefits.BillingBenefitsReservationOrderAliasData"/> instance for mocking. </returns>
        public static BillingBenefitsReservationOrderAliasData BillingBenefitsReservationOrderAliasData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string skuName = null, AzureLocation? location = null, string displayName = null, ResourceIdentifier reservationOrderId = null, BillingBenefitsProvisioningState? provisioningState = null, ResourceIdentifier billingScopeId = null, BillingBenefitsTerm? term = null, BillingBenefitsBillingPlan? billingPlan = null, BillingBenefitsAppliedScopeType? appliedScopeType = null, BillingBenefitsAppliedScopeProperties appliedScopeProperties = null, int? quantity = null, bool? isRenewed = null, BillingBenefitsReservedResourceType? reservedResourceType = null, DateTimeOffset? reviewOn = null, BillingBenefitsInstanceFlexibility? reservedResourceInstanceFlexibility = null)
        {
            return new BillingBenefitsReservationOrderAliasData(
                id,
                name,
                resourceType,
                systemData,
                skuName != null ? new BillingBenefitsSku(skuName, serializedAdditionalRawData: null) : null,
                location,
                displayName,
                reservationOrderId,
                provisioningState,
                billingScopeId,
                term,
                billingPlan,
                appliedScopeType,
                appliedScopeProperties,
                quantity,
                isRenewed,
                reservedResourceType,
                reviewOn,
                reservedResourceInstanceFlexibility != null ? new ReservationOrderAliasResponsePropertiesReservedResourceProperties(reservedResourceInstanceFlexibility, serializedAdditionalRawData: null) : null,
                serializedAdditionalRawData: null);
        }
    }
}
