// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Billing.Models;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.Billing
{
    /// <summary>
    /// A class representing a collection of <see cref="SubscriptionBillingInvoiceResource"/> and their operations.
    /// Each <see cref="SubscriptionBillingInvoiceResource"/> in the collection will belong to the same instance of <see cref="TenantResource"/>.
    /// To get a <see cref="SubscriptionBillingInvoiceCollection"/> instance call the GetSubscriptionBillingInvoices method from an instance of <see cref="TenantResource"/>.
    /// </summary>
    public partial class SubscriptionBillingInvoiceCollection : ArmCollection, IEnumerable<SubscriptionBillingInvoiceResource>, IAsyncEnumerable<SubscriptionBillingInvoiceResource>
    {
        private readonly ClientDiagnostics _subscriptionBillingInvoiceInvoicesClientDiagnostics;
        private readonly InvoicesRestOperations _subscriptionBillingInvoiceInvoicesRestClient;
        private readonly string _subscriptionId;

        /// <summary> Initializes a new instance of the <see cref="SubscriptionBillingInvoiceCollection"/> class for mocking. </summary>
        protected SubscriptionBillingInvoiceCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="SubscriptionBillingInvoiceCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        /// <param name="subscriptionId"> The ID that uniquely identifies a billing subscription. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/> is an empty string, and was expected to be non-empty. </exception>
        internal SubscriptionBillingInvoiceCollection(ArmClient client, ResourceIdentifier id, string subscriptionId) : base(client, id)
        {
            _subscriptionId = subscriptionId;
            _subscriptionBillingInvoiceInvoicesClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Billing", SubscriptionBillingInvoiceResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(SubscriptionBillingInvoiceResource.ResourceType, out string subscriptionBillingInvoiceInvoicesApiVersion);
            _subscriptionBillingInvoiceInvoicesRestClient = new InvoicesRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, subscriptionBillingInvoiceInvoicesApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != TenantResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, TenantResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Gets an invoice by subscription ID and invoice ID. The operation is supported for billing accounts with agreement type Microsoft Partner Agreement or Microsoft Customer Agreement.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/default/billingSubscriptions/{subscriptionId}/invoices/{invoiceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Invoices_GetByBillingSubscription</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SubscriptionBillingInvoiceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="invoiceName"> The ID that uniquely identifies an invoice. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="invoiceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="invoiceName"/> is null. </exception>
        public virtual async Task<Response<SubscriptionBillingInvoiceResource>> GetAsync(string invoiceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(invoiceName, nameof(invoiceName));

            using var scope = _subscriptionBillingInvoiceInvoicesClientDiagnostics.CreateScope("SubscriptionBillingInvoiceCollection.Get");
            scope.Start();
            try
            {
                var response = await _subscriptionBillingInvoiceInvoicesRestClient.GetByBillingSubscriptionAsync(_subscriptionId, invoiceName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SubscriptionBillingInvoiceResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets an invoice by subscription ID and invoice ID. The operation is supported for billing accounts with agreement type Microsoft Partner Agreement or Microsoft Customer Agreement.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/default/billingSubscriptions/{subscriptionId}/invoices/{invoiceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Invoices_GetByBillingSubscription</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SubscriptionBillingInvoiceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="invoiceName"> The ID that uniquely identifies an invoice. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="invoiceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="invoiceName"/> is null. </exception>
        public virtual Response<SubscriptionBillingInvoiceResource> Get(string invoiceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(invoiceName, nameof(invoiceName));

            using var scope = _subscriptionBillingInvoiceInvoicesClientDiagnostics.CreateScope("SubscriptionBillingInvoiceCollection.Get");
            scope.Start();
            try
            {
                var response = _subscriptionBillingInvoiceInvoicesRestClient.GetByBillingSubscription(_subscriptionId, invoiceName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SubscriptionBillingInvoiceResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Lists the invoices for a subscription. The operation is supported for billing accounts with agreement type Microsoft Partner Agreement or Microsoft Customer Agreement.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/default/billingSubscriptions/{subscriptionId}/invoices</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Invoices_ListByBillingSubscription</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SubscriptionBillingInvoiceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="options"> A property bag which contains all the parameters of this method except the LRO qualifier and request context parameter. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="SubscriptionBillingInvoiceResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<SubscriptionBillingInvoiceResource> GetAllAsync(SubscriptionBillingInvoiceCollectionGetAllOptions options, CancellationToken cancellationToken = default)
        {
            options ??= new SubscriptionBillingInvoiceCollectionGetAllOptions();

            HttpMessage FirstPageRequest(int? pageSizeHint) => _subscriptionBillingInvoiceInvoicesRestClient.CreateListByBillingSubscriptionRequest(_subscriptionId, options.PeriodStartDate, options.PeriodEndDate, options.Filter, options.OrderBy, options.Top, options.Skip, options.Count, options.Search);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _subscriptionBillingInvoiceInvoicesRestClient.CreateListByBillingSubscriptionNextPageRequest(nextLink, _subscriptionId, options.PeriodStartDate, options.PeriodEndDate, options.Filter, options.OrderBy, options.Top, options.Skip, options.Count, options.Search);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new SubscriptionBillingInvoiceResource(Client, BillingInvoiceData.DeserializeBillingInvoiceData(e)), _subscriptionBillingInvoiceInvoicesClientDiagnostics, Pipeline, "SubscriptionBillingInvoiceCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Lists the invoices for a subscription. The operation is supported for billing accounts with agreement type Microsoft Partner Agreement or Microsoft Customer Agreement.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/default/billingSubscriptions/{subscriptionId}/invoices</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Invoices_ListByBillingSubscription</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SubscriptionBillingInvoiceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="options"> A property bag which contains all the parameters of this method except the LRO qualifier and request context parameter. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="SubscriptionBillingInvoiceResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<SubscriptionBillingInvoiceResource> GetAll(SubscriptionBillingInvoiceCollectionGetAllOptions options, CancellationToken cancellationToken = default)
        {
            options ??= new SubscriptionBillingInvoiceCollectionGetAllOptions();

            HttpMessage FirstPageRequest(int? pageSizeHint) => _subscriptionBillingInvoiceInvoicesRestClient.CreateListByBillingSubscriptionRequest(_subscriptionId, options.PeriodStartDate, options.PeriodEndDate, options.Filter, options.OrderBy, options.Top, options.Skip, options.Count, options.Search);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _subscriptionBillingInvoiceInvoicesRestClient.CreateListByBillingSubscriptionNextPageRequest(nextLink, _subscriptionId, options.PeriodStartDate, options.PeriodEndDate, options.Filter, options.OrderBy, options.Top, options.Skip, options.Count, options.Search);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new SubscriptionBillingInvoiceResource(Client, BillingInvoiceData.DeserializeBillingInvoiceData(e)), _subscriptionBillingInvoiceInvoicesClientDiagnostics, Pipeline, "SubscriptionBillingInvoiceCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/default/billingSubscriptions/{subscriptionId}/invoices/{invoiceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Invoices_GetByBillingSubscription</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SubscriptionBillingInvoiceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="invoiceName"> The ID that uniquely identifies an invoice. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="invoiceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="invoiceName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string invoiceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(invoiceName, nameof(invoiceName));

            using var scope = _subscriptionBillingInvoiceInvoicesClientDiagnostics.CreateScope("SubscriptionBillingInvoiceCollection.Exists");
            scope.Start();
            try
            {
                var response = await _subscriptionBillingInvoiceInvoicesRestClient.GetByBillingSubscriptionAsync(_subscriptionId, invoiceName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/default/billingSubscriptions/{subscriptionId}/invoices/{invoiceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Invoices_GetByBillingSubscription</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SubscriptionBillingInvoiceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="invoiceName"> The ID that uniquely identifies an invoice. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="invoiceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="invoiceName"/> is null. </exception>
        public virtual Response<bool> Exists(string invoiceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(invoiceName, nameof(invoiceName));

            using var scope = _subscriptionBillingInvoiceInvoicesClientDiagnostics.CreateScope("SubscriptionBillingInvoiceCollection.Exists");
            scope.Start();
            try
            {
                var response = _subscriptionBillingInvoiceInvoicesRestClient.GetByBillingSubscription(_subscriptionId, invoiceName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/default/billingSubscriptions/{subscriptionId}/invoices/{invoiceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Invoices_GetByBillingSubscription</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SubscriptionBillingInvoiceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="invoiceName"> The ID that uniquely identifies an invoice. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="invoiceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="invoiceName"/> is null. </exception>
        public virtual async Task<NullableResponse<SubscriptionBillingInvoiceResource>> GetIfExistsAsync(string invoiceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(invoiceName, nameof(invoiceName));

            using var scope = _subscriptionBillingInvoiceInvoicesClientDiagnostics.CreateScope("SubscriptionBillingInvoiceCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _subscriptionBillingInvoiceInvoicesRestClient.GetByBillingSubscriptionAsync(_subscriptionId, invoiceName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<SubscriptionBillingInvoiceResource>(response.GetRawResponse());
                return Response.FromValue(new SubscriptionBillingInvoiceResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/default/billingSubscriptions/{subscriptionId}/invoices/{invoiceName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>Invoices_GetByBillingSubscription</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SubscriptionBillingInvoiceResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="invoiceName"> The ID that uniquely identifies an invoice. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="invoiceName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="invoiceName"/> is null. </exception>
        public virtual NullableResponse<SubscriptionBillingInvoiceResource> GetIfExists(string invoiceName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(invoiceName, nameof(invoiceName));

            using var scope = _subscriptionBillingInvoiceInvoicesClientDiagnostics.CreateScope("SubscriptionBillingInvoiceCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _subscriptionBillingInvoiceInvoicesRestClient.GetByBillingSubscription(_subscriptionId, invoiceName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<SubscriptionBillingInvoiceResource>(response.GetRawResponse());
                return Response.FromValue(new SubscriptionBillingInvoiceResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<SubscriptionBillingInvoiceResource> IEnumerable<SubscriptionBillingInvoiceResource>.GetEnumerator()
        {
            return GetAll(options: null).GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll(options: null).GetEnumerator();
        }

        IAsyncEnumerator<SubscriptionBillingInvoiceResource> IAsyncEnumerable<SubscriptionBillingInvoiceResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(options: null, cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
