// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.ResourceManager.Billing
{
    /// <summary>
    /// A class representing a collection of <see cref="SavingsPlanOrderModelResource"/> and their operations.
    /// Each <see cref="SavingsPlanOrderModelResource"/> in the collection will belong to the same instance of <see cref="BillingAccountResource"/>.
    /// To get a <see cref="SavingsPlanOrderModelCollection"/> instance call the GetSavingsPlanOrderModels method from an instance of <see cref="BillingAccountResource"/>.
    /// </summary>
    public partial class SavingsPlanOrderModelCollection : ArmCollection, IEnumerable<SavingsPlanOrderModelResource>, IAsyncEnumerable<SavingsPlanOrderModelResource>
    {
        private readonly ClientDiagnostics _savingsPlanOrderModelSavingsPlanOrdersClientDiagnostics;
        private readonly SavingsPlanOrdersRestOperations _savingsPlanOrderModelSavingsPlanOrdersRestClient;

        /// <summary> Initializes a new instance of the <see cref="SavingsPlanOrderModelCollection"/> class for mocking. </summary>
        protected SavingsPlanOrderModelCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="SavingsPlanOrderModelCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal SavingsPlanOrderModelCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _savingsPlanOrderModelSavingsPlanOrdersClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Billing", SavingsPlanOrderModelResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(SavingsPlanOrderModelResource.ResourceType, out string savingsPlanOrderModelSavingsPlanOrdersApiVersion);
            _savingsPlanOrderModelSavingsPlanOrdersRestClient = new SavingsPlanOrdersRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, savingsPlanOrderModelSavingsPlanOrdersApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != BillingAccountResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, BillingAccountResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Get a savings plan order by billing account.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/savingsPlanOrders/{savingsPlanOrderId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SavingsPlanOrders_GetByBillingAccount</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SavingsPlanOrderModelResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="savingsPlanOrderId"> Order ID of the savings plan. </param>
        /// <param name="expand"> May be used to expand the planInformation. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="savingsPlanOrderId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="savingsPlanOrderId"/> is null. </exception>
        public virtual async Task<Response<SavingsPlanOrderModelResource>> GetAsync(string savingsPlanOrderId, string expand = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(savingsPlanOrderId, nameof(savingsPlanOrderId));

            using var scope = _savingsPlanOrderModelSavingsPlanOrdersClientDiagnostics.CreateScope("SavingsPlanOrderModelCollection.Get");
            scope.Start();
            try
            {
                var response = await _savingsPlanOrderModelSavingsPlanOrdersRestClient.GetByBillingAccountAsync(Id.Name, savingsPlanOrderId, expand, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SavingsPlanOrderModelResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get a savings plan order by billing account.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/savingsPlanOrders/{savingsPlanOrderId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SavingsPlanOrders_GetByBillingAccount</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SavingsPlanOrderModelResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="savingsPlanOrderId"> Order ID of the savings plan. </param>
        /// <param name="expand"> May be used to expand the planInformation. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="savingsPlanOrderId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="savingsPlanOrderId"/> is null. </exception>
        public virtual Response<SavingsPlanOrderModelResource> Get(string savingsPlanOrderId, string expand = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(savingsPlanOrderId, nameof(savingsPlanOrderId));

            using var scope = _savingsPlanOrderModelSavingsPlanOrdersClientDiagnostics.CreateScope("SavingsPlanOrderModelCollection.Get");
            scope.Start();
            try
            {
                var response = _savingsPlanOrderModelSavingsPlanOrdersRestClient.GetByBillingAccount(Id.Name, savingsPlanOrderId, expand, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SavingsPlanOrderModelResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// List all Savings plan orders by billing account.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/savingsPlanOrders</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SavingsPlanOrders_ListByBillingAccount</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SavingsPlanOrderModelResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="filter"> The filter query option allows clients to filter a collection of resources that are addressed by a request URL. </param>
        /// <param name="orderBy"> The orderby query option allows clients to request resources in a particular order. </param>
        /// <param name="skiptoken"> The number of savings plans to skip from the list before returning results. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="SavingsPlanOrderModelResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<SavingsPlanOrderModelResource> GetAllAsync(string filter = null, string orderBy = null, float? skiptoken = null, CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _savingsPlanOrderModelSavingsPlanOrdersRestClient.CreateListByBillingAccountRequest(Id.Name, filter, orderBy, skiptoken);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _savingsPlanOrderModelSavingsPlanOrdersRestClient.CreateListByBillingAccountNextPageRequest(nextLink, Id.Name, filter, orderBy, skiptoken);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new SavingsPlanOrderModelResource(Client, SavingsPlanOrderModelData.DeserializeSavingsPlanOrderModelData(e)), _savingsPlanOrderModelSavingsPlanOrdersClientDiagnostics, Pipeline, "SavingsPlanOrderModelCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// List all Savings plan orders by billing account.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/savingsPlanOrders</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SavingsPlanOrders_ListByBillingAccount</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SavingsPlanOrderModelResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="filter"> The filter query option allows clients to filter a collection of resources that are addressed by a request URL. </param>
        /// <param name="orderBy"> The orderby query option allows clients to request resources in a particular order. </param>
        /// <param name="skiptoken"> The number of savings plans to skip from the list before returning results. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="SavingsPlanOrderModelResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<SavingsPlanOrderModelResource> GetAll(string filter = null, string orderBy = null, float? skiptoken = null, CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _savingsPlanOrderModelSavingsPlanOrdersRestClient.CreateListByBillingAccountRequest(Id.Name, filter, orderBy, skiptoken);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _savingsPlanOrderModelSavingsPlanOrdersRestClient.CreateListByBillingAccountNextPageRequest(nextLink, Id.Name, filter, orderBy, skiptoken);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new SavingsPlanOrderModelResource(Client, SavingsPlanOrderModelData.DeserializeSavingsPlanOrderModelData(e)), _savingsPlanOrderModelSavingsPlanOrdersClientDiagnostics, Pipeline, "SavingsPlanOrderModelCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/savingsPlanOrders/{savingsPlanOrderId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SavingsPlanOrders_GetByBillingAccount</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SavingsPlanOrderModelResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="savingsPlanOrderId"> Order ID of the savings plan. </param>
        /// <param name="expand"> May be used to expand the planInformation. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="savingsPlanOrderId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="savingsPlanOrderId"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string savingsPlanOrderId, string expand = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(savingsPlanOrderId, nameof(savingsPlanOrderId));

            using var scope = _savingsPlanOrderModelSavingsPlanOrdersClientDiagnostics.CreateScope("SavingsPlanOrderModelCollection.Exists");
            scope.Start();
            try
            {
                var response = await _savingsPlanOrderModelSavingsPlanOrdersRestClient.GetByBillingAccountAsync(Id.Name, savingsPlanOrderId, expand, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/savingsPlanOrders/{savingsPlanOrderId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SavingsPlanOrders_GetByBillingAccount</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SavingsPlanOrderModelResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="savingsPlanOrderId"> Order ID of the savings plan. </param>
        /// <param name="expand"> May be used to expand the planInformation. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="savingsPlanOrderId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="savingsPlanOrderId"/> is null. </exception>
        public virtual Response<bool> Exists(string savingsPlanOrderId, string expand = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(savingsPlanOrderId, nameof(savingsPlanOrderId));

            using var scope = _savingsPlanOrderModelSavingsPlanOrdersClientDiagnostics.CreateScope("SavingsPlanOrderModelCollection.Exists");
            scope.Start();
            try
            {
                var response = _savingsPlanOrderModelSavingsPlanOrdersRestClient.GetByBillingAccount(Id.Name, savingsPlanOrderId, expand, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/savingsPlanOrders/{savingsPlanOrderId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SavingsPlanOrders_GetByBillingAccount</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SavingsPlanOrderModelResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="savingsPlanOrderId"> Order ID of the savings plan. </param>
        /// <param name="expand"> May be used to expand the planInformation. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="savingsPlanOrderId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="savingsPlanOrderId"/> is null. </exception>
        public virtual async Task<NullableResponse<SavingsPlanOrderModelResource>> GetIfExistsAsync(string savingsPlanOrderId, string expand = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(savingsPlanOrderId, nameof(savingsPlanOrderId));

            using var scope = _savingsPlanOrderModelSavingsPlanOrdersClientDiagnostics.CreateScope("SavingsPlanOrderModelCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _savingsPlanOrderModelSavingsPlanOrdersRestClient.GetByBillingAccountAsync(Id.Name, savingsPlanOrderId, expand, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<SavingsPlanOrderModelResource>(response.GetRawResponse());
                return Response.FromValue(new SavingsPlanOrderModelResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/billingAccounts/{billingAccountName}/savingsPlanOrders/{savingsPlanOrderId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SavingsPlanOrders_GetByBillingAccount</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SavingsPlanOrderModelResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="savingsPlanOrderId"> Order ID of the savings plan. </param>
        /// <param name="expand"> May be used to expand the planInformation. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="savingsPlanOrderId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="savingsPlanOrderId"/> is null. </exception>
        public virtual NullableResponse<SavingsPlanOrderModelResource> GetIfExists(string savingsPlanOrderId, string expand = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(savingsPlanOrderId, nameof(savingsPlanOrderId));

            using var scope = _savingsPlanOrderModelSavingsPlanOrdersClientDiagnostics.CreateScope("SavingsPlanOrderModelCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _savingsPlanOrderModelSavingsPlanOrdersRestClient.GetByBillingAccount(Id.Name, savingsPlanOrderId, expand, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<SavingsPlanOrderModelResource>(response.GetRawResponse());
                return Response.FromValue(new SavingsPlanOrderModelResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<SavingsPlanOrderModelResource> IEnumerable<SavingsPlanOrderModelResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<SavingsPlanOrderModelResource> IAsyncEnumerable<SavingsPlanOrderModelResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
