// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.Billing.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Billing
{
    public partial class RecipientTransferDetailData : IUtf8JsonSerializable, IJsonModel<RecipientTransferDetailData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<RecipientTransferDetailData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<RecipientTransferDetailData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RecipientTransferDetailData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(RecipientTransferDetailData)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            if (Optional.IsCollectionDefined(Tags))
            {
                writer.WritePropertyName("tags"u8);
                writer.WriteStartObject();
                foreach (var item in Tags)
                {
                    writer.WritePropertyName(item.Key);
                    writer.WriteStringValue(item.Value);
                }
                writer.WriteEndObject();
            }
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (options.Format != "W" && Optional.IsDefined(ExpireOn))
            {
                writer.WritePropertyName("expirationTime"u8);
                writer.WriteStringValue(ExpireOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(AllowedProductType))
            {
                writer.WritePropertyName("allowedProductType"u8);
                writer.WriteStartArray();
                foreach (var item in AllowedProductType)
                {
                    writer.WriteStringValue(item.ToString());
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsDefined(TransferStatus))
            {
                writer.WritePropertyName("transferStatus"u8);
                writer.WriteStringValue(TransferStatus.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(RecipientEmailId))
            {
                writer.WritePropertyName("recipientEmailId"u8);
                writer.WriteStringValue(RecipientEmailId);
            }
            if (options.Format != "W" && Optional.IsDefined(InitiatorEmailId))
            {
                writer.WritePropertyName("initiatorEmailId"u8);
                writer.WriteStringValue(InitiatorEmailId);
            }
            if (options.Format != "W" && Optional.IsDefined(ResellerId))
            {
                writer.WritePropertyName("resellerId"u8);
                writer.WriteStringValue(ResellerId);
            }
            if (options.Format != "W" && Optional.IsDefined(ResellerName))
            {
                writer.WritePropertyName("resellerName"u8);
                writer.WriteStringValue(ResellerName);
            }
            if (options.Format != "W" && Optional.IsDefined(InitiatorCustomerType))
            {
                writer.WritePropertyName("initiatorCustomerType"u8);
                writer.WriteStringValue(InitiatorCustomerType.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(CanceledBy))
            {
                writer.WritePropertyName("canceledBy"u8);
                writer.WriteStringValue(CanceledBy);
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(DetailedTransferStatus))
            {
                writer.WritePropertyName("detailedTransferStatus"u8);
                writer.WriteStartArray();
                foreach (var item in DetailedTransferStatus)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsDefined(CustomerTenantId))
            {
                writer.WritePropertyName("customerTenantId"u8);
                writer.WriteStringValue(CustomerTenantId.Value);
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(SupportedAccounts))
            {
                writer.WritePropertyName("supportedAccounts"u8);
                writer.WriteStartArray();
                foreach (var item in SupportedAccounts)
                {
                    writer.WriteStringValue(item.ToString());
                }
                writer.WriteEndArray();
            }
            writer.WriteEndObject();
        }

        RecipientTransferDetailData IJsonModel<RecipientTransferDetailData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RecipientTransferDetailData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(RecipientTransferDetailData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeRecipientTransferDetailData(document.RootElement, options);
        }

        internal static RecipientTransferDetailData DeserializeRecipientTransferDetailData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IDictionary<string, string> tags = default;
            ResourceIdentifier id = default;
            string name = default;
            ResourceType type = default;
            SystemData systemData = default;
            DateTimeOffset? expirationTime = default;
            IReadOnlyList<EligibleProductType> allowedProductType = default;
            PartnerTransferStatus? transferStatus = default;
            string recipientEmailId = default;
            string initiatorEmailId = default;
            string resellerId = default;
            string resellerName = default;
            InitiatorCustomerType? initiatorCustomerType = default;
            string canceledBy = default;
            IReadOnlyList<DetailedTransferStatus> detailedTransferStatus = default;
            Guid? customerTenantId = default;
            IReadOnlyList<BillingSupportedAccountType> supportedAccounts = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("tags"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    Dictionary<string, string> dictionary = new Dictionary<string, string>();
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        dictionary.Add(property0.Name, property0.Value.GetString());
                    }
                    tags = dictionary;
                    continue;
                }
                if (property.NameEquals("id"u8))
                {
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemData = JsonSerializer.Deserialize<SystemData>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("expirationTime"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            expirationTime = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                        if (property0.NameEquals("allowedProductType"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<EligibleProductType> array = new List<EligibleProductType>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(new EligibleProductType(item.GetString()));
                            }
                            allowedProductType = array;
                            continue;
                        }
                        if (property0.NameEquals("transferStatus"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            transferStatus = new PartnerTransferStatus(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("recipientEmailId"u8))
                        {
                            recipientEmailId = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("initiatorEmailId"u8))
                        {
                            initiatorEmailId = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("resellerId"u8))
                        {
                            resellerId = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("resellerName"u8))
                        {
                            resellerName = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("initiatorCustomerType"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            initiatorCustomerType = new InitiatorCustomerType(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("canceledBy"u8))
                        {
                            canceledBy = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("detailedTransferStatus"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<DetailedTransferStatus> array = new List<DetailedTransferStatus>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(Models.DetailedTransferStatus.DeserializeDetailedTransferStatus(item, options));
                            }
                            detailedTransferStatus = array;
                            continue;
                        }
                        if (property0.NameEquals("customerTenantId"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            customerTenantId = property0.Value.GetGuid();
                            continue;
                        }
                        if (property0.NameEquals("supportedAccounts"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<BillingSupportedAccountType> array = new List<BillingSupportedAccountType>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(new BillingSupportedAccountType(item.GetString()));
                            }
                            supportedAccounts = array;
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new RecipientTransferDetailData(
                id,
                name,
                type,
                systemData,
                expirationTime,
                allowedProductType ?? new ChangeTrackingList<EligibleProductType>(),
                transferStatus,
                recipientEmailId,
                initiatorEmailId,
                resellerId,
                resellerName,
                initiatorCustomerType,
                canceledBy,
                detailedTransferStatus ?? new ChangeTrackingList<DetailedTransferStatus>(),
                customerTenantId,
                supportedAccounts ?? new ChangeTrackingList<BillingSupportedAccountType>(),
                tags ?? new ChangeTrackingDictionary<string, string>(),
                serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Name), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  name: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Name))
                {
                    builder.Append("  name: ");
                    if (Name.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Name}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Name}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Tags), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  tags: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(Tags))
                {
                    if (Tags.Any())
                    {
                        builder.Append("  tags: ");
                        builder.AppendLine("{");
                        foreach (var item in Tags)
                        {
                            builder.Append($"    '{item.Key}': ");
                            if (item.Value == null)
                            {
                                builder.Append("null");
                                continue;
                            }
                            if (item.Value.Contains(Environment.NewLine))
                            {
                                builder.AppendLine("'''");
                                builder.AppendLine($"{item.Value}'''");
                            }
                            else
                            {
                                builder.AppendLine($"'{item.Value}'");
                            }
                        }
                        builder.AppendLine("  }");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Id), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  id: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Id))
                {
                    builder.Append("  id: ");
                    builder.AppendLine($"'{Id.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SystemData), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  systemData: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SystemData))
                {
                    builder.Append("  systemData: ");
                    builder.AppendLine($"'{SystemData.ToString()}'");
                }
            }

            builder.Append("  properties:");
            builder.AppendLine(" {");
            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ExpireOn), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    expirationTime: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ExpireOn))
                {
                    builder.Append("    expirationTime: ");
                    var formattedDateTimeString = TypeFormatters.ToString(ExpireOn.Value, "o");
                    builder.AppendLine($"'{formattedDateTimeString}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AllowedProductType), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    allowedProductType: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(AllowedProductType))
                {
                    if (AllowedProductType.Any())
                    {
                        builder.Append("    allowedProductType: ");
                        builder.AppendLine("[");
                        foreach (var item in AllowedProductType)
                        {
                            builder.AppendLine($"      '{item.ToString()}'");
                        }
                        builder.AppendLine("    ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(TransferStatus), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    transferStatus: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(TransferStatus))
                {
                    builder.Append("    transferStatus: ");
                    builder.AppendLine($"'{TransferStatus.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(RecipientEmailId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    recipientEmailId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(RecipientEmailId))
                {
                    builder.Append("    recipientEmailId: ");
                    if (RecipientEmailId.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{RecipientEmailId}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{RecipientEmailId}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(InitiatorEmailId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    initiatorEmailId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(InitiatorEmailId))
                {
                    builder.Append("    initiatorEmailId: ");
                    if (InitiatorEmailId.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{InitiatorEmailId}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{InitiatorEmailId}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ResellerId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    resellerId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ResellerId))
                {
                    builder.Append("    resellerId: ");
                    if (ResellerId.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{ResellerId}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{ResellerId}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ResellerName), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    resellerName: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ResellerName))
                {
                    builder.Append("    resellerName: ");
                    if (ResellerName.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{ResellerName}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{ResellerName}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(InitiatorCustomerType), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    initiatorCustomerType: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(InitiatorCustomerType))
                {
                    builder.Append("    initiatorCustomerType: ");
                    builder.AppendLine($"'{InitiatorCustomerType.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(CanceledBy), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    canceledBy: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(CanceledBy))
                {
                    builder.Append("    canceledBy: ");
                    if (CanceledBy.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{CanceledBy}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{CanceledBy}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(DetailedTransferStatus), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    detailedTransferStatus: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(DetailedTransferStatus))
                {
                    if (DetailedTransferStatus.Any())
                    {
                        builder.Append("    detailedTransferStatus: ");
                        builder.AppendLine("[");
                        foreach (var item in DetailedTransferStatus)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 6, true, "    detailedTransferStatus: ");
                        }
                        builder.AppendLine("    ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(CustomerTenantId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    customerTenantId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(CustomerTenantId))
                {
                    builder.Append("    customerTenantId: ");
                    builder.AppendLine($"'{CustomerTenantId.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SupportedAccounts), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    supportedAccounts: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(SupportedAccounts))
                {
                    if (SupportedAccounts.Any())
                    {
                        builder.Append("    supportedAccounts: ");
                        builder.AppendLine("[");
                        foreach (var item in SupportedAccounts)
                        {
                            builder.AppendLine($"      '{item.ToString()}'");
                        }
                        builder.AppendLine("    ]");
                    }
                }
            }

            builder.AppendLine("  }");
            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<RecipientTransferDetailData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RecipientTransferDetailData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(RecipientTransferDetailData)} does not support writing '{options.Format}' format.");
            }
        }

        RecipientTransferDetailData IPersistableModel<RecipientTransferDetailData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RecipientTransferDetailData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeRecipientTransferDetailData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(RecipientTransferDetailData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<RecipientTransferDetailData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
