// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.Billing
{
    /// <summary>
    /// A class representing a collection of <see cref="RecipientTransferDetailResource"/> and their operations.
    /// Each <see cref="RecipientTransferDetailResource"/> in the collection will belong to the same instance of <see cref="TenantResource"/>.
    /// To get a <see cref="RecipientTransferDetailCollection"/> instance call the GetRecipientTransferDetails method from an instance of <see cref="TenantResource"/>.
    /// </summary>
    public partial class RecipientTransferDetailCollection : ArmCollection, IEnumerable<RecipientTransferDetailResource>, IAsyncEnumerable<RecipientTransferDetailResource>
    {
        private readonly ClientDiagnostics _recipientTransferDetailRecipientTransfersClientDiagnostics;
        private readonly RecipientTransfersRestOperations _recipientTransferDetailRecipientTransfersRestClient;

        /// <summary> Initializes a new instance of the <see cref="RecipientTransferDetailCollection"/> class for mocking. </summary>
        protected RecipientTransferDetailCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="RecipientTransferDetailCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal RecipientTransferDetailCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _recipientTransferDetailRecipientTransfersClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Billing", RecipientTransferDetailResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(RecipientTransferDetailResource.ResourceType, out string recipientTransferDetailRecipientTransfersApiVersion);
            _recipientTransferDetailRecipientTransfersRestClient = new RecipientTransfersRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, recipientTransferDetailRecipientTransfersApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != TenantResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, TenantResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Gets a transfer request by ID. The caller must be the recipient of the transfer request.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/transfers/{transferName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>RecipientTransfers_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="RecipientTransferDetailResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="transferName"> The ID that uniquely identifies a transfer request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="transferName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="transferName"/> is null. </exception>
        public virtual async Task<Response<RecipientTransferDetailResource>> GetAsync(string transferName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(transferName, nameof(transferName));

            using var scope = _recipientTransferDetailRecipientTransfersClientDiagnostics.CreateScope("RecipientTransferDetailCollection.Get");
            scope.Start();
            try
            {
                var response = await _recipientTransferDetailRecipientTransfersRestClient.GetAsync(transferName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new RecipientTransferDetailResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets a transfer request by ID. The caller must be the recipient of the transfer request.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/transfers/{transferName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>RecipientTransfers_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="RecipientTransferDetailResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="transferName"> The ID that uniquely identifies a transfer request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="transferName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="transferName"/> is null. </exception>
        public virtual Response<RecipientTransferDetailResource> Get(string transferName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(transferName, nameof(transferName));

            using var scope = _recipientTransferDetailRecipientTransfersClientDiagnostics.CreateScope("RecipientTransferDetailCollection.Get");
            scope.Start();
            try
            {
                var response = _recipientTransferDetailRecipientTransfersRestClient.Get(transferName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new RecipientTransferDetailResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Lists the transfer requests received by the caller.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/transfers</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>RecipientTransfers_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="RecipientTransferDetailResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="RecipientTransferDetailResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<RecipientTransferDetailResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _recipientTransferDetailRecipientTransfersRestClient.CreateListRequest();
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _recipientTransferDetailRecipientTransfersRestClient.CreateListNextPageRequest(nextLink);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new RecipientTransferDetailResource(Client, RecipientTransferDetailData.DeserializeRecipientTransferDetailData(e)), _recipientTransferDetailRecipientTransfersClientDiagnostics, Pipeline, "RecipientTransferDetailCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Lists the transfer requests received by the caller.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/transfers</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>RecipientTransfers_List</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="RecipientTransferDetailResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="RecipientTransferDetailResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<RecipientTransferDetailResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _recipientTransferDetailRecipientTransfersRestClient.CreateListRequest();
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _recipientTransferDetailRecipientTransfersRestClient.CreateListNextPageRequest(nextLink);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new RecipientTransferDetailResource(Client, RecipientTransferDetailData.DeserializeRecipientTransferDetailData(e)), _recipientTransferDetailRecipientTransfersClientDiagnostics, Pipeline, "RecipientTransferDetailCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/transfers/{transferName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>RecipientTransfers_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="RecipientTransferDetailResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="transferName"> The ID that uniquely identifies a transfer request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="transferName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="transferName"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string transferName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(transferName, nameof(transferName));

            using var scope = _recipientTransferDetailRecipientTransfersClientDiagnostics.CreateScope("RecipientTransferDetailCollection.Exists");
            scope.Start();
            try
            {
                var response = await _recipientTransferDetailRecipientTransfersRestClient.GetAsync(transferName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/transfers/{transferName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>RecipientTransfers_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="RecipientTransferDetailResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="transferName"> The ID that uniquely identifies a transfer request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="transferName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="transferName"/> is null. </exception>
        public virtual Response<bool> Exists(string transferName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(transferName, nameof(transferName));

            using var scope = _recipientTransferDetailRecipientTransfersClientDiagnostics.CreateScope("RecipientTransferDetailCollection.Exists");
            scope.Start();
            try
            {
                var response = _recipientTransferDetailRecipientTransfersRestClient.Get(transferName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/transfers/{transferName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>RecipientTransfers_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="RecipientTransferDetailResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="transferName"> The ID that uniquely identifies a transfer request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="transferName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="transferName"/> is null. </exception>
        public virtual async Task<NullableResponse<RecipientTransferDetailResource>> GetIfExistsAsync(string transferName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(transferName, nameof(transferName));

            using var scope = _recipientTransferDetailRecipientTransfersClientDiagnostics.CreateScope("RecipientTransferDetailCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _recipientTransferDetailRecipientTransfersRestClient.GetAsync(transferName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<RecipientTransferDetailResource>(response.GetRawResponse());
                return Response.FromValue(new RecipientTransferDetailResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Billing/transfers/{transferName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>RecipientTransfers_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2024-04-01</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="RecipientTransferDetailResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="transferName"> The ID that uniquely identifies a transfer request. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="transferName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="transferName"/> is null. </exception>
        public virtual NullableResponse<RecipientTransferDetailResource> GetIfExists(string transferName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(transferName, nameof(transferName));

            using var scope = _recipientTransferDetailRecipientTransfersClientDiagnostics.CreateScope("RecipientTransferDetailCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _recipientTransferDetailRecipientTransfersRestClient.Get(transferName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<RecipientTransferDetailResource>(response.GetRawResponse());
                return Response.FromValue(new RecipientTransferDetailResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<RecipientTransferDetailResource> IEnumerable<RecipientTransferDetailResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<RecipientTransferDetailResource> IAsyncEnumerable<RecipientTransferDetailResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
