// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Billing.Models;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Billing
{
    /// <summary>
    /// A class representing the PartnerTransferDetail data model.
    /// Details of the transfer.
    /// </summary>
    public partial class PartnerTransferDetailData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="PartnerTransferDetailData"/>. </summary>
        public PartnerTransferDetailData()
        {
            DetailedTransferStatus = new ChangeTrackingList<DetailedTransferStatus>();
            Tags = new ChangeTrackingDictionary<string, string>();
        }

        /// <summary> Initializes a new instance of <see cref="PartnerTransferDetailData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="expireOn"> The time at which the transfer request expires. </param>
        /// <param name="transferStatus"> Overall transfer status. </param>
        /// <param name="recipientEmailId"> The email ID of the user to whom the transfer request was sent. </param>
        /// <param name="initiatorCustomerType"> The type of customer who sent the transfer request. </param>
        /// <param name="initiatorEmailId"> The email ID of the user who sent the transfer request. </param>
        /// <param name="resellerId"> Optional MPN ID of the reseller for transfer requests that are sent from a Microsoft Partner Agreement billing account. </param>
        /// <param name="resellerName"> Optional name of the reseller for transfer requests that are sent from Microsoft Partner Agreement billing account. </param>
        /// <param name="canceledBy"> The email ID of the user who canceled the transfer request. </param>
        /// <param name="detailedTransferStatus"> Detailed transfer status. </param>
        /// <param name="tags"> Dictionary of metadata associated with the resource. It may not be populated for all resource types. Maximum key/value length supported of 256 characters. Keys/value should not empty value nor null. Keys can not contain &lt; &gt; % &amp; \ ? /. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal PartnerTransferDetailData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, DateTimeOffset? expireOn, PartnerTransferStatus? transferStatus, string recipientEmailId, InitiatorCustomerType? initiatorCustomerType, string initiatorEmailId, string resellerId, string resellerName, string canceledBy, IReadOnlyList<DetailedTransferStatus> detailedTransferStatus, IDictionary<string, string> tags, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            ExpireOn = expireOn;
            TransferStatus = transferStatus;
            RecipientEmailId = recipientEmailId;
            InitiatorCustomerType = initiatorCustomerType;
            InitiatorEmailId = initiatorEmailId;
            ResellerId = resellerId;
            ResellerName = resellerName;
            CanceledBy = canceledBy;
            DetailedTransferStatus = detailedTransferStatus;
            Tags = tags;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The time at which the transfer request expires. </summary>
        [WirePath("properties.expirationTime")]
        public DateTimeOffset? ExpireOn { get; }
        /// <summary> Overall transfer status. </summary>
        [WirePath("properties.transferStatus")]
        public PartnerTransferStatus? TransferStatus { get; }
        /// <summary> The email ID of the user to whom the transfer request was sent. </summary>
        [WirePath("properties.recipientEmailId")]
        public string RecipientEmailId { get; }
        /// <summary> The type of customer who sent the transfer request. </summary>
        [WirePath("properties.initiatorCustomerType")]
        public InitiatorCustomerType? InitiatorCustomerType { get; }
        /// <summary> The email ID of the user who sent the transfer request. </summary>
        [WirePath("properties.initiatorEmailId")]
        public string InitiatorEmailId { get; }
        /// <summary> Optional MPN ID of the reseller for transfer requests that are sent from a Microsoft Partner Agreement billing account. </summary>
        [WirePath("properties.resellerId")]
        public string ResellerId { get; }
        /// <summary> Optional name of the reseller for transfer requests that are sent from Microsoft Partner Agreement billing account. </summary>
        [WirePath("properties.resellerName")]
        public string ResellerName { get; }
        /// <summary> The email ID of the user who canceled the transfer request. </summary>
        [WirePath("properties.canceledBy")]
        public string CanceledBy { get; }
        /// <summary> Detailed transfer status. </summary>
        [WirePath("properties.detailedTransferStatus")]
        public IReadOnlyList<DetailedTransferStatus> DetailedTransferStatus { get; }
        /// <summary> Dictionary of metadata associated with the resource. It may not be populated for all resource types. Maximum key/value length supported of 256 characters. Keys/value should not empty value nor null. Keys can not contain &lt; &gt; % &amp; \ ? /. </summary>
        [WirePath("tags")]
        public IDictionary<string, string> Tags { get; }
    }
}
