// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> The policy that controls whether the users in customer's organization can view charges at pay-as-you-go prices. </summary>
    public readonly partial struct ViewChargesPolicy : IEquatable<ViewChargesPolicy>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ViewChargesPolicy"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ViewChargesPolicy(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OtherValue = "Other";
        private const string AllowedValue = "Allowed";
        private const string NotAllowedValue = "NotAllowed";

        /// <summary> Other. </summary>
        public static ViewChargesPolicy Other { get; } = new ViewChargesPolicy(OtherValue);
        /// <summary> Allowed. </summary>
        public static ViewChargesPolicy Allowed { get; } = new ViewChargesPolicy(AllowedValue);
        /// <summary> NotAllowed. </summary>
        public static ViewChargesPolicy NotAllowed { get; } = new ViewChargesPolicy(NotAllowedValue);
        /// <summary> Determines if two <see cref="ViewChargesPolicy"/> values are the same. </summary>
        public static bool operator ==(ViewChargesPolicy left, ViewChargesPolicy right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ViewChargesPolicy"/> values are not the same. </summary>
        public static bool operator !=(ViewChargesPolicy left, ViewChargesPolicy right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ViewChargesPolicy"/>. </summary>
        public static implicit operator ViewChargesPolicy(string value) => new ViewChargesPolicy(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ViewChargesPolicy other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ViewChargesPolicy other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
