// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> The Azure workload type of the subscription. </summary>
    public readonly partial struct SubscriptionWorkloadType : IEquatable<SubscriptionWorkloadType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SubscriptionWorkloadType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SubscriptionWorkloadType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string ProductionValue = "Production";
        private const string DevTestValue = "DevTest";
        private const string InternalValue = "Internal";

        /// <summary> None. </summary>
        public static SubscriptionWorkloadType None { get; } = new SubscriptionWorkloadType(NoneValue);
        /// <summary> Production. </summary>
        public static SubscriptionWorkloadType Production { get; } = new SubscriptionWorkloadType(ProductionValue);
        /// <summary> DevTest. </summary>
        public static SubscriptionWorkloadType DevTest { get; } = new SubscriptionWorkloadType(DevTestValue);
        /// <summary> Internal. </summary>
        public static SubscriptionWorkloadType Internal { get; } = new SubscriptionWorkloadType(InternalValue);
        /// <summary> Determines if two <see cref="SubscriptionWorkloadType"/> values are the same. </summary>
        public static bool operator ==(SubscriptionWorkloadType left, SubscriptionWorkloadType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SubscriptionWorkloadType"/> values are not the same. </summary>
        public static bool operator !=(SubscriptionWorkloadType left, SubscriptionWorkloadType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SubscriptionWorkloadType"/>. </summary>
        public static implicit operator SubscriptionWorkloadType(string value) => new SubscriptionWorkloadType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SubscriptionWorkloadType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SubscriptionWorkloadType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
