// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> Error code of the transfer validation response. </summary>
    public readonly partial struct SubscriptionTransferValidationErrorCode : IEquatable<SubscriptionTransferValidationErrorCode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SubscriptionTransferValidationErrorCode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SubscriptionTransferValidationErrorCode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OtherValue = "Other";
        private const string BillingAccountInactiveValue = "BillingAccountInactive";
        private const string DestinationBillingProfileInactiveValue = "DestinationBillingProfileInactive";
        private const string DestinationBillingProfileNotFoundValue = "DestinationBillingProfileNotFound";
        private const string DestinationBillingProfilePastDueValue = "DestinationBillingProfilePastDue";
        private const string DestinationInvoiceSectionInactiveValue = "DestinationInvoiceSectionInactive";
        private const string DestinationInvoiceSectionNotFoundValue = "DestinationInvoiceSectionNotFound";
        private const string InsufficientPermissionOnDestinationValue = "InsufficientPermissionOnDestination";
        private const string InsufficientPermissionOnSourceValue = "InsufficientPermissionOnSource";
        private const string InvalidDestinationValue = "InvalidDestination";
        private const string InvalidSourceValue = "InvalidSource";
        private const string MarketplaceNotEnabledOnDestinationValue = "MarketplaceNotEnabledOnDestination";
        private const string ProductInactiveValue = "ProductInactive";
        private const string ProductNotFoundValue = "ProductNotFound";
        private const string ProductTypeNotSupportedValue = "ProductTypeNotSupported";
        private const string SourceBillingProfilePastDueValue = "SourceBillingProfilePastDue";
        private const string SourceInvoiceSectionInactiveValue = "SourceInvoiceSectionInactive";
        private const string AccountIsLockedValue = "AccountIsLocked";
        private const string AssetHasCapValue = "AssetHasCap";
        private const string AssetNotActiveValue = "AssetNotActive";
        private const string BillingProfilePastDueValue = "BillingProfilePastDue";
        private const string CrossBillingAccountNotAllowedValue = "CrossBillingAccountNotAllowed";
        private const string NoActiveAzurePlanValue = "NoActiveAzurePlan";
        private const string NoneValue = "None";
        private const string SubscriptionNotActiveValue = "SubscriptionNotActive";
        private const string SubscriptionHasReservationsValue = "SubscriptionHasReservations";
        private const string SubscriptionTypeNotSupportedValue = "SubscriptionTypeNotSupported";
        private const string InvoiceSectionIsRestrictedValue = "InvoiceSectionIsRestricted";

        /// <summary> Other. </summary>
        public static SubscriptionTransferValidationErrorCode Other { get; } = new SubscriptionTransferValidationErrorCode(OtherValue);
        /// <summary> BillingAccountInactive. </summary>
        public static SubscriptionTransferValidationErrorCode BillingAccountInactive { get; } = new SubscriptionTransferValidationErrorCode(BillingAccountInactiveValue);
        /// <summary> DestinationBillingProfileInactive. </summary>
        public static SubscriptionTransferValidationErrorCode DestinationBillingProfileInactive { get; } = new SubscriptionTransferValidationErrorCode(DestinationBillingProfileInactiveValue);
        /// <summary> DestinationBillingProfileNotFound. </summary>
        public static SubscriptionTransferValidationErrorCode DestinationBillingProfileNotFound { get; } = new SubscriptionTransferValidationErrorCode(DestinationBillingProfileNotFoundValue);
        /// <summary> DestinationBillingProfilePastDue. </summary>
        public static SubscriptionTransferValidationErrorCode DestinationBillingProfilePastDue { get; } = new SubscriptionTransferValidationErrorCode(DestinationBillingProfilePastDueValue);
        /// <summary> DestinationInvoiceSectionInactive. </summary>
        public static SubscriptionTransferValidationErrorCode DestinationInvoiceSectionInactive { get; } = new SubscriptionTransferValidationErrorCode(DestinationInvoiceSectionInactiveValue);
        /// <summary> DestinationInvoiceSectionNotFound. </summary>
        public static SubscriptionTransferValidationErrorCode DestinationInvoiceSectionNotFound { get; } = new SubscriptionTransferValidationErrorCode(DestinationInvoiceSectionNotFoundValue);
        /// <summary> InsufficientPermissionOnDestination. </summary>
        public static SubscriptionTransferValidationErrorCode InsufficientPermissionOnDestination { get; } = new SubscriptionTransferValidationErrorCode(InsufficientPermissionOnDestinationValue);
        /// <summary> InsufficientPermissionOnSource. </summary>
        public static SubscriptionTransferValidationErrorCode InsufficientPermissionOnSource { get; } = new SubscriptionTransferValidationErrorCode(InsufficientPermissionOnSourceValue);
        /// <summary> InvalidDestination. </summary>
        public static SubscriptionTransferValidationErrorCode InvalidDestination { get; } = new SubscriptionTransferValidationErrorCode(InvalidDestinationValue);
        /// <summary> InvalidSource. </summary>
        public static SubscriptionTransferValidationErrorCode InvalidSource { get; } = new SubscriptionTransferValidationErrorCode(InvalidSourceValue);
        /// <summary> MarketplaceNotEnabledOnDestination. </summary>
        public static SubscriptionTransferValidationErrorCode MarketplaceNotEnabledOnDestination { get; } = new SubscriptionTransferValidationErrorCode(MarketplaceNotEnabledOnDestinationValue);
        /// <summary> ProductInactive. </summary>
        public static SubscriptionTransferValidationErrorCode ProductInactive { get; } = new SubscriptionTransferValidationErrorCode(ProductInactiveValue);
        /// <summary> ProductNotFound. </summary>
        public static SubscriptionTransferValidationErrorCode ProductNotFound { get; } = new SubscriptionTransferValidationErrorCode(ProductNotFoundValue);
        /// <summary> ProductTypeNotSupported. </summary>
        public static SubscriptionTransferValidationErrorCode ProductTypeNotSupported { get; } = new SubscriptionTransferValidationErrorCode(ProductTypeNotSupportedValue);
        /// <summary> SourceBillingProfilePastDue. </summary>
        public static SubscriptionTransferValidationErrorCode SourceBillingProfilePastDue { get; } = new SubscriptionTransferValidationErrorCode(SourceBillingProfilePastDueValue);
        /// <summary> SourceInvoiceSectionInactive. </summary>
        public static SubscriptionTransferValidationErrorCode SourceInvoiceSectionInactive { get; } = new SubscriptionTransferValidationErrorCode(SourceInvoiceSectionInactiveValue);
        /// <summary> AccountIsLocked. </summary>
        public static SubscriptionTransferValidationErrorCode AccountIsLocked { get; } = new SubscriptionTransferValidationErrorCode(AccountIsLockedValue);
        /// <summary> AssetHasCap. </summary>
        public static SubscriptionTransferValidationErrorCode AssetHasCap { get; } = new SubscriptionTransferValidationErrorCode(AssetHasCapValue);
        /// <summary> AssetNotActive. </summary>
        public static SubscriptionTransferValidationErrorCode AssetNotActive { get; } = new SubscriptionTransferValidationErrorCode(AssetNotActiveValue);
        /// <summary> BillingProfilePastDue. </summary>
        public static SubscriptionTransferValidationErrorCode BillingProfilePastDue { get; } = new SubscriptionTransferValidationErrorCode(BillingProfilePastDueValue);
        /// <summary> CrossBillingAccountNotAllowed. </summary>
        public static SubscriptionTransferValidationErrorCode CrossBillingAccountNotAllowed { get; } = new SubscriptionTransferValidationErrorCode(CrossBillingAccountNotAllowedValue);
        /// <summary> NoActiveAzurePlan. </summary>
        public static SubscriptionTransferValidationErrorCode NoActiveAzurePlan { get; } = new SubscriptionTransferValidationErrorCode(NoActiveAzurePlanValue);
        /// <summary> None. </summary>
        public static SubscriptionTransferValidationErrorCode None { get; } = new SubscriptionTransferValidationErrorCode(NoneValue);
        /// <summary> SubscriptionNotActive. </summary>
        public static SubscriptionTransferValidationErrorCode SubscriptionNotActive { get; } = new SubscriptionTransferValidationErrorCode(SubscriptionNotActiveValue);
        /// <summary> SubscriptionHasReservations. </summary>
        public static SubscriptionTransferValidationErrorCode SubscriptionHasReservations { get; } = new SubscriptionTransferValidationErrorCode(SubscriptionHasReservationsValue);
        /// <summary> SubscriptionTypeNotSupported. </summary>
        public static SubscriptionTransferValidationErrorCode SubscriptionTypeNotSupported { get; } = new SubscriptionTransferValidationErrorCode(SubscriptionTypeNotSupportedValue);
        /// <summary> InvoiceSectionIsRestricted. </summary>
        public static SubscriptionTransferValidationErrorCode InvoiceSectionIsRestricted { get; } = new SubscriptionTransferValidationErrorCode(InvoiceSectionIsRestrictedValue);
        /// <summary> Determines if two <see cref="SubscriptionTransferValidationErrorCode"/> values are the same. </summary>
        public static bool operator ==(SubscriptionTransferValidationErrorCode left, SubscriptionTransferValidationErrorCode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SubscriptionTransferValidationErrorCode"/> values are not the same. </summary>
        public static bool operator !=(SubscriptionTransferValidationErrorCode left, SubscriptionTransferValidationErrorCode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SubscriptionTransferValidationErrorCode"/>. </summary>
        public static implicit operator SubscriptionTransferValidationErrorCode(string value) => new SubscriptionTransferValidationErrorCode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SubscriptionTransferValidationErrorCode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SubscriptionTransferValidationErrorCode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
