// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> The suspension reason for a subscription. This field is not available for Enterprise Agreement billing accounts. </summary>
    public readonly partial struct SubscriptionStatusReason : IEquatable<SubscriptionStatusReason>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SubscriptionStatusReason"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SubscriptionStatusReason(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string CancelledValue = "Cancelled";
        private const string PastDueValue = "PastDue";
        private const string SuspiciousActivityValue = "SuspiciousActivity";
        private const string OtherValue = "Other";
        private const string TransferredValue = "Transferred";
        private const string PolicyViolationValue = "PolicyViolation";
        private const string SpendingLimitReachedValue = "SpendingLimitReached";
        private const string ExpiredValue = "Expired";

        /// <summary> None. </summary>
        public static SubscriptionStatusReason None { get; } = new SubscriptionStatusReason(NoneValue);
        /// <summary> Cancelled. </summary>
        public static SubscriptionStatusReason Cancelled { get; } = new SubscriptionStatusReason(CancelledValue);
        /// <summary> PastDue. </summary>
        public static SubscriptionStatusReason PastDue { get; } = new SubscriptionStatusReason(PastDueValue);
        /// <summary> SuspiciousActivity. </summary>
        public static SubscriptionStatusReason SuspiciousActivity { get; } = new SubscriptionStatusReason(SuspiciousActivityValue);
        /// <summary> Other. </summary>
        public static SubscriptionStatusReason Other { get; } = new SubscriptionStatusReason(OtherValue);
        /// <summary> Transferred. </summary>
        public static SubscriptionStatusReason Transferred { get; } = new SubscriptionStatusReason(TransferredValue);
        /// <summary> PolicyViolation. </summary>
        public static SubscriptionStatusReason PolicyViolation { get; } = new SubscriptionStatusReason(PolicyViolationValue);
        /// <summary> SpendingLimitReached. </summary>
        public static SubscriptionStatusReason SpendingLimitReached { get; } = new SubscriptionStatusReason(SpendingLimitReachedValue);
        /// <summary> Expired. </summary>
        public static SubscriptionStatusReason Expired { get; } = new SubscriptionStatusReason(ExpiredValue);
        /// <summary> Determines if two <see cref="SubscriptionStatusReason"/> values are the same. </summary>
        public static bool operator ==(SubscriptionStatusReason left, SubscriptionStatusReason right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SubscriptionStatusReason"/> values are not the same. </summary>
        public static bool operator !=(SubscriptionStatusReason left, SubscriptionStatusReason right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SubscriptionStatusReason"/>. </summary>
        public static implicit operator SubscriptionStatusReason(string value) => new SubscriptionStatusReason(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SubscriptionStatusReason other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SubscriptionStatusReason other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
