// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> The current enrollment account status of the subscription. This field is available only for the Enterprise Agreement Type. </summary>
    public readonly partial struct SubscriptionEnrollmentAccountStatus : IEquatable<SubscriptionEnrollmentAccountStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SubscriptionEnrollmentAccountStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SubscriptionEnrollmentAccountStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ActiveValue = "Active";
        private const string CancelledValue = "Cancelled";
        private const string ExpiredValue = "Expired";
        private const string DeletedValue = "Deleted";
        private const string TransferredOutValue = "TransferredOut";
        private const string TransferringValue = "Transferring";
        private const string InactiveValue = "Inactive";

        /// <summary> Active. </summary>
        public static SubscriptionEnrollmentAccountStatus Active { get; } = new SubscriptionEnrollmentAccountStatus(ActiveValue);
        /// <summary> Cancelled. </summary>
        public static SubscriptionEnrollmentAccountStatus Cancelled { get; } = new SubscriptionEnrollmentAccountStatus(CancelledValue);
        /// <summary> Expired. </summary>
        public static SubscriptionEnrollmentAccountStatus Expired { get; } = new SubscriptionEnrollmentAccountStatus(ExpiredValue);
        /// <summary> Deleted. </summary>
        public static SubscriptionEnrollmentAccountStatus Deleted { get; } = new SubscriptionEnrollmentAccountStatus(DeletedValue);
        /// <summary> TransferredOut. </summary>
        public static SubscriptionEnrollmentAccountStatus TransferredOut { get; } = new SubscriptionEnrollmentAccountStatus(TransferredOutValue);
        /// <summary> Transferring. </summary>
        public static SubscriptionEnrollmentAccountStatus Transferring { get; } = new SubscriptionEnrollmentAccountStatus(TransferringValue);
        /// <summary> Inactive. </summary>
        public static SubscriptionEnrollmentAccountStatus Inactive { get; } = new SubscriptionEnrollmentAccountStatus(InactiveValue);
        /// <summary> Determines if two <see cref="SubscriptionEnrollmentAccountStatus"/> values are the same. </summary>
        public static bool operator ==(SubscriptionEnrollmentAccountStatus left, SubscriptionEnrollmentAccountStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SubscriptionEnrollmentAccountStatus"/> values are not the same. </summary>
        public static bool operator !=(SubscriptionEnrollmentAccountStatus left, SubscriptionEnrollmentAccountStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SubscriptionEnrollmentAccountStatus"/>. </summary>
        public static implicit operator SubscriptionEnrollmentAccountStatus(string value) => new SubscriptionEnrollmentAccountStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SubscriptionEnrollmentAccountStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SubscriptionEnrollmentAccountStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
