// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Billing.Models
{
    /// <summary> The type of billing subscription. </summary>
    public readonly partial struct SubscriptionBillingType : IEquatable<SubscriptionBillingType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SubscriptionBillingType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SubscriptionBillingType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string BenefitValue = "Benefit";
        private const string FreeValue = "Free";
        private const string PaidValue = "Paid";
        private const string PrePaidValue = "PrePaid";

        /// <summary> None. </summary>
        public static SubscriptionBillingType None { get; } = new SubscriptionBillingType(NoneValue);
        /// <summary> Benefit. </summary>
        public static SubscriptionBillingType Benefit { get; } = new SubscriptionBillingType(BenefitValue);
        /// <summary> Free. </summary>
        public static SubscriptionBillingType Free { get; } = new SubscriptionBillingType(FreeValue);
        /// <summary> Paid. </summary>
        public static SubscriptionBillingType Paid { get; } = new SubscriptionBillingType(PaidValue);
        /// <summary> PrePaid. </summary>
        public static SubscriptionBillingType PrePaid { get; } = new SubscriptionBillingType(PrePaidValue);
        /// <summary> Determines if two <see cref="SubscriptionBillingType"/> values are the same. </summary>
        public static bool operator ==(SubscriptionBillingType left, SubscriptionBillingType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SubscriptionBillingType"/> values are not the same. </summary>
        public static bool operator !=(SubscriptionBillingType left, SubscriptionBillingType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SubscriptionBillingType"/>. </summary>
        public static implicit operator SubscriptionBillingType(string value) => new SubscriptionBillingType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SubscriptionBillingType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SubscriptionBillingType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
